INCLUDE CLIBC_16.INC

; stricmp() -- Compare strings, case insensitive (lowercase)
;int __near stricmp(const char __near * const, const char __near * const);

;GIVEN:
;   p_str1	near pointer, offset from ss
;   p_str2	near pointer, offset from ds
; RETURNS:
;   <0		str1 < str2
;   0		str1 = str2
;   >0		str1 > str2
_TEXT SEGMENT
stricmp PROC NEAR16 C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax

	    mov di,[p_str1]	    ;es/ss:di = p_str1
	    mov si,[p_str2]	    ;ds:si = p_str2

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
stricmp ENDP

; __farcall
;   bx	    p_str1
;   ax	    p_str2
;int __farcall __near stricmp(const char __near * const, const char __near * const);
@stricmp PROC NEAR16 USES es si di cx dx

	    mov di, bx	    ;es/ss:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ss
	    mov es, ax


	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@stricmp ENDP
_TEXT ENDS
END
