INCLUDE CLIB_16.INC

;strcat() -- Concatenate strings
; appends string2 to end of string1
;char __far * __far strcat(char __far * const, const char __far * const);

_TEXT SEGMENT
strcat PROC FAR16 C uses ds es si di, p_str1:FAR16 PTR BYTE, p_str2:FAR16 PTR BYTE

	    les di,[p_str1]	    ;es:di = destination
	    lds si, [p_str2]	    ; ds:si = source

	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    jmp @@exit
@@cont:
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]	 ;check for zero
	    dec di

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    les di, [p_str1]
@@exit:
	    mov dx, es
	    mov ax, di
	    ret
strcat ENDP
_TEXT ENDS
END
