
/* ibmcurs.c follows: */
#define         screensize      80*2*24 /* IBM screen size (savable part) */
#define         crtbuffer       0Xb800

static char buf1[screensize];
static int cursor  = 0;

Savescrn()

{
register char *diptr;
register char *siptr;

	diptr = &buf1[0];                  /* save this screen */
	siptr = crtbuffer;                      /* screen segment addr */
	asm(" mov dx,si");                      /* hold segment loc */
	asm(" mov ax,*24");                     /* num lines to save */
	asm(" mov si,*0");                      /* offset in buffer */
	asm("movel1: mov cx,*160");             /* bytes per bfr line */
	asm(" cli");                            /* stop interrupts */
	asm(" mov ds,dx");                      /* set dest seg reg */
	asm(" rep");                            /* do string move */
	asm(" movb");
	asm(" sti");                            /* reenable interrupts */
	asm(" dec ax");                         /* decrement lines left */
	asm(" jnz movel1");                     /* loop thru lines */
	asm(" mov ax,es");                      /* restore seg reg */
	asm(" mov ds,ax");
}

Restscrn()

{
register char *diptr1;
register char *siptr1;

	siptr1 = &buf1[0];                  /* restore the screen */
	diptr1 = crtbuffer;
	asm(" mov dx,di");
	asm(" mov ax,*24");
	asm(" mov di,*0");
	asm("movel2: mov cx,*160");
	asm(" cli");
	asm(" mov es,dx");
	asm(" rep");
	asm(" movb");
	asm(" sti");
	asm(" dec ax");
	asm(" jnz movel2");
	asm(" mov ax,ds");
	asm(" mov es,ax");

}

ibmcur(Y,X)
int     X;
int     Y;

{                                               /* compute the display */
	cursor = X - 1;                         /* screen loc of cursor */
	if (X < 0) cursor = 0;
	cursor = cursor + cursor + ((Y - 1) * 160);
}

ibmprt(s)
char *s;

{
register char *diptr2;
register char *siptr2;

	siptr2 = s;                             /* users input pointer */
	diptr2 = crtbuffer;                     /* screen buffer address */
	asm(" mov bx,di");                      /* set into a register */
	diptr2 = cursor;                        /* get the last cursor loc */
	asm(" mov cx,ds");                      /* save current data seg */
	asm(" mov dx,#0x3da");                  /* crt status port addr */
	asm("prtl1: movb ah,(si)");             /* get next char to output */
	asm(" cmp ah,*0");                      /* end of string??? */
	asm(" je prtdone");
	asm(" in");                             /* wait for vert. retrace */
	asm(" testb al,*8");                    /* bit 3 on during retrace */
	asm(" jz prtl1");
	asm(" cli");                            /* hold all interrupts */
	asm(" mov ds,bx");                      /* use screen buf segment */
	asm(" movb (di),ah");                   /* output the char */
	asm(" mov ds,cx");                      /* restore seg register */
	asm(" sti");                            /* reenable interrupts */
	asm(" inc si");                         /* incr source pointer */
	asm(" add di,*2");                      /* dbl incr dest pointer */
	asm(" j prtl1");                        /* go get another char */
	asm("prtdone: ");                       /* end of all it */
	cursor = diptr2;                        /* save new cursor loc */
}
