;Flat real mode for C/C++
;Copyright (C) 1999 Tobias Romann <t.rossmann@gmx.at>

;This library is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation; either version 2 of the License, or
;(at your option) any later version.

;This library is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this library; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%include "stdc.mac"

;constants
CODE_SEL   equ 0x08        ;code-segment selector
DATA32_SEL equ 0x10        ;32-bit data selector

dgroup

udataseg
global _em_avail
global _em_base
global _em_top

global _em_max

global _cpu_type
global _mem_mode

_em_avail resd 1
_em_base  resd 1
_em_top   resd 1

_cpu_type resw 1

XMM_call:
        XMM_off resw 1
        XMM_seg resw 1

_mem_mode:
em_handle: resw 1

dataseg
_em_max dw -1

codeseg

;gdt-pointer, contains the size and adress of the gdt
GDTptr dw 24, GDT, 0

GDT dd 0, 0

code_discr:
        ;code-segment descriptor
        dw 0xffff, 0, 0x9a00, 0

;the following could be used to really *exit* flat real mode, if you want
;to do so
;       ;16-bit data-segment descriptor
;       dw 0xffff, 0, 0x9200, 0

        ;32-bit data-segment descriptor
        dw 0xffff, 0, 0x9200, 10001111b  ;4gb size!

;init_flat, try to switch to flat real mode
;returns: 0 = no error
;         1 = 80386 or better cpu not detected
;         2 = cpu is in v86-mode
;         3 = XMS allocation failed
;         4 = Cannot lock extended memory block
global _init_flat
_init_flat:
        call    near get_cpu
        mov     [_cpu_type], dx
        mov     ax, 1
        cmp     dl, 2
        jnb     short $+3
        retf

        mov     eax, cr0
        test    al, 1                    ;are we in pm?
        jz      short $+6
        mov     ax, 2
        retf

        push    ds
        xor     edx, edx
        mov     dx, cs                  ;EDX = CS
        mov     ds, dx                  ;DS=CS
        shl     edx, 4                  ;EDX = code-segment base adress

        add     [GDTptr+2], edx         ;load the gdt-pointer with the base
                                        ;adress of the gdt
        or      [code_discr+2], edx

        cli
        lgdt    [GDTptr]
        or      al, 1
        mov     cr0, eax

        db      0xea
        dw      .pmode, CODE_SEL

.pmode: mov     dx, DATA32_SEL
        mov     ds, dx
        mov     es, dx
        mov     fs, dx
        mov     gs, dx

        and     al, 0xfe
        mov     cr0, eax                ;CR0 = EAX

        db      0xea
        dw      .rmode, seg .rmode

.rmode: sti
        pop     ds

        xor     eax, eax
        cmp     [_em_max], ax           ;extended memory wanted?
        jz      .good_ret               ;if not, exit now

        mov     ax, 0x4300              ;check for himem.sys
        int     0x2f
        cmp     al, 0x80
        jnz     short .raw_mode         ;if not loaded, use bios

        mov     ax, 0x4310              ;get entry point
        int     0x2f
        mov     [XMM_seg], es
        mov     [XMM_off], bx

        xor     edx, edx
        mov     ah, 8
        call    far [XMM_call]
        mov     dx, ax                  ;DX = AX = biggest free block
        or      ax, ax                  ;check for extended memory
        jz      short .ret              ;leave if no available

        mov     bx, [_em_max]
        cmp     dx, bx                  ;available memory > max. memory to
                                        ;be used?
        jna     .himem_too_much         ;if, than reduce dx
        xchg    dx, bx

.himem_too_much:
        mov     [_em_avail], edx        ;em_avail is in bytes
        shl     dword [_em_avail], 10   ;* 1024

        mov     ah, 9                   ;allocate memory
        call    far [XMM_call]
        or      ax, ax                  ;abort on error
        mov     ax, 3
        jz      .ret
        mov     [em_handle], dx

        mov     ah, 0x0c                ;lock memory
        call    far [XMM_call]
        or      ax, ax
        mov     ax, 4                   ;this is actually the most fatal
        jz      .ret                    ;error as it requires exit_flat to
                                        ;be called and lets the em_ vars
                                        ;contain garbage
        shl     edx, 16                 ;EDX = DX:BX
        xchg    dx, bx
        mov     [_em_base], edx

        add     edx, [_em_avail]        ;add free memory
        mov     [_em_top], edx


.good_ret:
        call    near enable_a20
        xor     ax, ax                  ;no error
.ret:  retf

.raw_mode:
        mov     ah, 0x88
        int     0x15                    ;AX = size in kb

        or      ax, ax                  ;if no available, leave again
        jz      short .ret

        mov     dx, [_em_max]
        cmp     ax, dx                  ;available memory > max. memory to
                                        ;be used?
        jna     .raw_too_much           ;if, than reduce dx
        xchg    ax, dx

.raw_too_much:
        mov     edx, 0x100000           ;extended memory start at 1mb
        mov     [_em_base], edx

        shl     eax, 10
        mov     [_em_avail], eax

        add     eax, edx                ;upper limit = base adress + free
        mov     [_em_top], eax          ;mem

        xor     ax, ax
        jmp     short .good_ret

;exit_flat, free allocated memory
;This doesn't resize the segment limits to 64k, as I didn't encounter any
;problems leaving them at 4G.
global _exit_flat
_exit_flat:
        mov     dx, [em_handle]
        or      dx, dx                  ;xms in use?
        jz      short .ret

        mov     ah, 0xd                 ;unlock memory
        call    far [XMM_call]
        mov     ah, 0xa
        call    far [XMM_call]
.ret:   retf

;get_cpu, detect cpu type
;returns: dx =
;             0 8088/8086
;             1 80286
;             3 80386
;             4 80486+
;crashes: EAX, BX, ECX
;written by Randall Hyde and others, from the UCR Standard Library for
;Assembly Language Programmers
get_cpu:
        pushf

; 8088/8086
        pushf
        pop     bx                      ;BX = FLAGS
        mov     ax, 0x0fff              ;clear bits 12-15
        and     ax, bx
        push    ax
        popf                            ;FLAGS = AX
        pushf
        pop     ax                      ;AX = FLAGS
        xor     dx, dx                  ;0 = 8088/8086
        and     ax, 0xf000              ;if bits 12-15 are set,
        cmp     ax, 0xf000              ;it's a 8086/8088
        jz      short .ret

; 80286
        or      bx, 0xf000              ;try to set bits 12-15
        push    bx
        popf
        pushf
        pop     ax
        and     ax, 0xf000              ;if they are cleared
        inc     dx                      ;=> 286
        jz      short .ret

; 80386
        mov     bx, sp                  ;save SP
        and     sp, 0xfc
        pushfd
        pop     eax
        mov     ecx, eax                ;try to toggle the AC bit
        xor     eax, 0x40000
        push    eax
        popfd
        pushfd
        pop     eax
        inc     dx
        xor     eax, ecx                ;if it can't be modified
        mov     sp, bx                  ;=> 386
        jz      short .ret

; 80486
        inc     dx                      ;newer cpus are not detected

.ret:   popf
        retn

enable_a20:
        mov     al, 0xd1                ;command: write data
        out     0x64, al
        call    near wait_8042          ;wait for controller to be ready
        mov     al, 0xdf                ;command: unlock a20
        out     0x60, al
        call    near wait_8042
        retn

disable_a20:
        mov     al, 0xd1
        out     0x64, al
        call    near wait_8042
        mov     al, 0xdd                ;command: lock a20
        out     0x60, al
        call    near wait_8042
        retn

; wait for keyboard controller to be ready
wait_8042:
        in      al, 0x64                ;read status
        test    al, 2                   ;until new data can be send
        jnz     short wait_8042
        retn
