/*
**      Another hard error handler for the CXL windowing library.
**
**      Place call to _harderr after call to video_init.
**
**      Syntax:     _harderr(CXL_error_handler);
**
**      From:       Ian Journeaux, EASYL SOFTWARE
**                  CIS: 76214,1427
**                  or the CXL Support BBS: (512)590-0460
**
*/



#include    <bios.h>
#include    <conio.h>
#include    <dos.h>
#include    <malloc.h>
#include    <process.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    "cxldef.h"
#include    "cxlkey.h"
#include    "cxlmou.h"
#include    "cxlstr.h"
#include    "cxlvid.h"
#include    "cxlwin.h"
#include    "cxlxwin.h"

/* Type definitions */

/* Prototypes */
void get_devname( void );

/*---------------------------------------------------------------------------*/
/* Extended Error table */
static char *exterror[]=
    { "Successful call", "Invalid service number", "File not found",
      "Path not found", "Too many files open", "Access denied",
      "Invalid file handle", "Memory control blocks destroyed",
      "Insufficient memory", "Invalid memory-block address",
      "Invalid environment", "Invalid format", "Invalid access code",
      "Invalid data", "Reserved for future use", "Invalid drive",
      "Attempt to remove current directory", "Not same device",
      "No more files", "Disk is write protected", "Unknown unit",
      "Device not ready", "Unknown command", "CRC data error",
      "Unknown command", "CRC data error", "Bad request-structure length",
      "Seek error", "Not a dos disk", "Sector not found",
      "Printer out of paper", "Write fault", "Read fault", "General Failure",
      "Sharing violation", "Lock violation", "Disk change invalid",
      "File control block unavailable", "Network busy",
      "Reserved", "Handle end-of-file not completed",
      "Reserved", "Reserved", "Reserved", "Reserved", "Reserved", "Reserved",
      "Reserved", "Reserved", "Reserved", "Reserved", "Reserved",
      "Network support unavailable", "Remote computer unavailable",
      "Network request not supported", "Remote computer not listening",
      "Duplicate name on network", "Network name not found", "Network busy",
      "Network device no longer exists", "Network BIOS command limit exceeded",
      "Network adapter hardware error", "Incorrect response from network",
      "Unexpected network error", "Incompatible remote adapter",
      "Print queue full", "Queue not full", "Not enough space to print file",
      "Network name was deleted", "Access denied by network",
      "Network device type incorrect", "Network name not found",
      "Network name limit exceeded", "Network BIOS session limit exceeded",
      "Temporarily paused", "Network request not accepted",
      "Print/disk redirection paused", "File already exists",
      "Cannot make directory", "Fail on INT 24h", "Too many redirections",
      "Duplicate redirection", "Invalid password", "Invalid parameter",
      "Network write fault", "Function not supported on network",
      "Required system component not installed",  NULL };

/*---------------------------------------------------------------------------*/
/* Class table */
static char *class[]=
    { "Out of storage space or I/O channels", "Temporary situation (file or record lock)",
      "Authorization (access denied)", "Internal system error", "Hardware failure",
      "System failure (or bad config.sys)", "Application program error", "Item not found",
      "Bad format", "Resource currently locked", "Media error",
      "Item already exists", "Unknown", NULL };

/*---------------------------------------------------------------------------*/
/* Action table */
static char *action[]=
    { "Retry the operation", "Delay and then retry", "Re-enter user input",
      "Abort application after closing files", "Abort immediately",
        "Ignore the error", "Retry after correcting error", NULL };

/*---------------------------------------------------------------------------*/
/* Locus table */
static char *locus[]=
    { "Unknown source", "Block device (disk error)", "Network error",
        "Serial device error (timeout)", "System memory error", NULL };

/*---------------------------------------------------------------------------*/
/* Location of disk error */
static char *location[]=
    { "DOS error", "FAT error", "Directory error", "File error", NULL };

/*---------------------------------------------------------------------------*/
/* Tpye of disk error */
static char *read_write[]=
    { "Read error", "Write error", NULL };

/*---------------------------------------------------------------------------*/
/* Drive Letters */
static char *drive_letter[]=
    { "A:", "B:", "C:", "D:", "E:", "F:", "G:", "H:", "I:", "J:", "K:", "L:",
      "M:", "N:", "O:", "P:", "Q:", "R:", "S:", "T:", "U:", "V:", "W:", "X:",
      "Y:", "Z:",   NULL };

/*---------------------------------------------------------------------------*/
static struct
{
    unsigned deverr;
    unsigned errcode;
    unsigned far *devhdr;  /* Pointer to HEADER structure. READ ONLY!       */
} near _hflags;

struct DOSERROR error;

#define HEADER struct _device_header
extern HEADER
{
     long     far *devptr;
     unsigned far *attrib;
     unsigned far *stratptr;
     unsigned far *intrptr;
     char     far *devname;
};

unsigned int critical_error;
char device_name[8];

void far CXL_error_handler(unsigned deverr, unsigned errcode, unsigned far *devhdr)
{
    int i;
    int status;
    int done = 0;
    unsigned int fail;
    unsigned int retry;
    unsigned int ignore;
    unsigned int disk;
    unsigned int drive;
    unsigned int disk_error;
    unsigned int disk_error_type;
    unsigned int disk_error_location;
    unsigned int di_low, di_high;
    unsigned far *headptr;
    HEADER header;

    _hflags.deverr  = deverr;
    _hflags.errcode = errcode;
    _hflags.devhdr  = devhdr;

    disk_error = (deverr & 0x8000) >> 15;
    ignore     = (deverr & 0x2000) >> 13;
    retry      = (deverr & 0x1000) >> 12;
    fail       = (deverr & 0x0800) >> 11;
    drive      = (deverr & 0x00FF);
    disk_error_location = (deverr & 0x0600) >> 9;
    disk_error_type = (deverr & 0x0100) >> 8;
    dosexterr(&error);

    if((error.exterror < 0) || (error.exterror > 90)) {
        error.exterror = 1;
    }
    if((error.class < 1) || (error.class > 13)) {
        error.class = 13;
    }
    if((error.locus < 1) || (error.locus > 5)) {
        error.locus = 1;
    }
    if((error.action < 1) || (error.action > 7)) {
        error.action = 1;
    }

    if(!wopen(6,10,15,70,1,YELLOW|_RED,YELLOW|_RED)) error_exit();
    wtitle("[ CRITICAL ERROR ]",TCENTER,YELLOW|BLINK|_RED);
    whline(6, 0, 60, 0, YELLOW|_RED);

    wprintf("\033R%c\033C%cError Code     : %s", 1, 1, exterror[error.exterror]);
    wprintf("\033R%c\033C%cClass of Error : %s", 2, 1, class[error.class-1]);
    wprintf("\033R%c\033C%cLocation       : %s", 3, 1, locus[error.locus-1]);
    if(disk_error == 0) {
        wprintf("\033R%c\033C%c%s on drive %s  %s", 4, 18, read_write[disk_error_type], drive_letter[drive], location[disk_error_location]);
    } else {
        get_devname();
        wprintf("\033R%c\033C%cDevice: %s", 4, 18, device_name);
    }

    wprintf("\033R%c\033C%cRecommended Action : %s", 5, 1, action[error.action-1]);
    if(error.action == 6) {
        i = 'I';
    } else if ((error.action == 4)||(error.action == 5)) {
        i = 'A';
    } else {
        i = 'R';
    }
    wsetesc(0);
    wmenubeg(14,16,14,65,5,YELLOW|_RED,YELLOW|_RED,NULL);
    wmenuitem( 0, 0 , "Retry",  'R', 'R', 0, NULL, 0, 0);
    wmenuitem( 0, 13, "Abort",  'A', 'A', 0, NULL, 0, 0);
    wmenuitem( 0, 26, "Ignore", 'I', 'I', 0, NULL, 0, 0);
    wmenuitem( 0, 39, "Fail",   'F', 'F', 0, NULL, 0, 0);
    wmenuend(i, M_HORZ, 0, 0, LMAGENTA|_BLACK, WHITE|_BLACK, LGREY|_BLACK, RED|BLINK|_LGREY);
    i = wmenuget();

    switch (i)
    {
        case 'R':   critical_error = _HARDERR_RETRY;
                    break;

        case 'A':   critical_error = _HARDERR_ABORT;
                    cls();
                    break;

        case 'I':   critical_error = _HARDERR_IGNORE;
                    break;

        case 'F':   critical_error = _HARDERR_FAIL;
                    break;
    }

    wclose();
    _hardresume(critical_error);
}

void get_devname( void )
/* Returns the name of the device on which the error occured.               */
/* For example, PRN is returned if writing to a printer which               */
/* is out of paper.                                                         */
{
    int i;
    for(i=0; i < 8; i++) {
        device_name[i] = ((char *) &(_hflags.devhdr[5]))[i];
    }
}

