#include <alloc.h>
#include <stdlib.h>
#include <graphics.h>
#include "colors.h"
#include "!bestlib.h"

#define BGCOLOR BLACK                  /* background color                  */

   /*** NOTE  the names and structure of the routines used in these examples
              have changed in The Best Library 2.00; the updated examples will
              be released soon                                            ***/

   /*** NOTE  even though this program only uses the "keyp" and "msdata"
              structures, the other two are necessary for the assembler
              routines in the !BESTLIB.LIB library to function properly.  C
              would also produce a "linker warning" if you have enabled that
              warning                                                     ***/
filldata fidata;                       /* create a "filldata" structure     */
printdata prdata;                      /* create a "printdata" structure    */
mousedata msdata;                      /* create a "mousedata" structure    */
asciiscan keyp;                        /* create an "asciiscan" structure   */

void main(void)
{
   typedef struct {
      int x;
      int y;
      int maxx;
      int maxy;
   } graphicobject;

   graphicobject *graphic;
   int oldmode, mouse, gdrv = VGA, gmod = VGAHI;
   register int i, ii;
   void *bgscrn[3], *image_or[1], *image[3];

   if (coreleft() < 280000L) {         /* if we do not have enough memory.. */
      textm(0);                        /* make sure we are in a text mode   */
      printsatcur("Insufficient memory to run EXAMP006.EXE");
      exit(1);                         /* exit to DOS with errorlevel 1     */
   }
   if (isitega() == FALSE) {
      textm(0);                        /* make sure we are in a text mode   */
      printsatcur("An EGA/VGA card is required to run EXAMP006.EXE");
      exit(2);                         /* exit to DOS with errorlevel 2     */
   }
   if ((oldmode = readvideomode()) == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(3);                      /* store text video memory           */
      cursor(3, 1);                    /* hide and store cursor position    */
   }
   initgraph(&gdrv, &gmod, "");        /* initialize graphics mode          */
   settextjustify(LEFT_TEXT, TOP_TEXT);
   settextstyle(SMALL_FONT, HORIZ_DIR, 4);         /* setup font size/style */

   mouse = initms_gr();             /* initialize mouse driver if installed */
   floodall(BGCOLOR);                  /* create the screen background      */

   for (i = 0; i < 5; i++)             /* create the screen border          */
      boxoutline(i, i, MAXX - i*2, MAXY - i*2, YELLOW, COPY_IMAGE);

                                       /* create the screen background      */
   for (i = BLACK, ii = 5; i <= WHITE; i++, ii += 21)
      boxfill(ii, 5, 21, MAXY - 10, i, COPY_IMAGE);
   for (i = YELLOW; i > BLACK; i--, ii += 21)
      boxfill(ii, 5, 21, MAXY - 10, i, COPY_IMAGE);

            /* print messages showing user each animation routine in action */
   boxfill(5, 36, 50, 12, BLACK, COPY_IMAGE);
   outtextxy(5, 36, "animate()");
   boxfill(5, 136, 57, 12, BLACK, COPY_IMAGE);
   outtextxy(5, 136, "animate1()");
   boxfill(5, 236, 78, 12, BLACK, COPY_IMAGE);
   outtextxy(5, 236, "animatepixel()");
   boxfill(5, 336, 85, 12, BLACK, COPY_IMAGE);
   outtextxy(5, 336, "animatebestss()");

                                       /* store the background into memory  */
   bgscrn[0] = (void *) malloc(imagememreq(640, 204));
   bgscrn[1] = (void *) malloc(imagememreq(640, 204));
   bgscrn[2] = (void *) malloc(imagememreq(640, 72));
   storeimage(0, 0, 640, 204, bgscrn[0]);
   storeimage(0, 204, 640, 204, bgscrn[1]);
   storeimage(0, 408, 640, 72, bgscrn[2]);

                             /* allocate memory for graphicobject structure */
   graphic = (graphicobject *) malloc(sizeof(graphicobject));

                 /* draw the image to animate outside the visible video RAM */
 /* because it is outside the visible range, mouse cursor can stay onscreen */
   #define CLR1 LIGHTBLUE
   #define CLR2 YELLOW                         /* draw the true-color image */
   boxfill(0, MAXY, 32, 32, BGCOLOR, COPY_IMAGE);
   boxfill(13, MAXY, 7, 32, CLR1, COPY_IMAGE);
   boxfill(0, MAXY+13, 32, 7, CLR1, COPY_IMAGE);
   linexy(16, MAXY, 31, MAXY+15, CLR2);
   linexy(31, MAXY+15, 15, MAXY+31, CLR2);
   linexy(15, MAXY+31, 0, MAXY+16, CLR2);
   linexy(0, MAXY+16, 16, MAXY, CLR2);
   boxfill(12, MAXY+12, 9, 9, BLACK, COPY_IMAGE);

   image[0] = (void *) malloc(imagememreq(32, 32));       /* for storeimage */
   image_or[0] = (void *) malloc(imagememreq(32, 32));    /* for storeimage */
   image[1] = (void *) malloc(pixelimagememreq(32, 32));
                                                     /* for storepixelimage */
   image[2] = (void *) malloc(pixelrcompressimagememreq(0, MAXY, 32, 32));
                                             /* for storepixelcompressimage */
   storeimage(0, MAXY, 32, 32, image[0]);                     /* save image */
   storepixelimage(0, MAXY, 32, 32, BGCOLOR, image[1]);       /* save image */
   storepixelcompressimage(0, MAXY, 32, 32, BGCOLOR, image[2]); /* sv image */

            /* draw the graphics to animate outside the visible screen area */
   #undef CLR1
   #undef CLR2
   #define CLR1 WHITE
   #define CLR2 WHITE                          /* draw the pure-white image */
   boxfill(0, MAXY, 32, 32, BGCOLOR, COPY_IMAGE);
   boxfill(13, MAXY, 7, 32, CLR1, COPY_IMAGE);
   boxfill(0, MAXY+13, 32, 7, CLR1, COPY_IMAGE);
   linexy(16, MAXY, 31, MAXY+15, CLR2);
   linexy(31, MAXY+15, 15, MAXY+31, CLR2);
   linexy(15, MAXY+31, 0, MAXY+16, CLR2);
   linexy(0, MAXY+16, 16, MAXY, CLR2);
   boxfill(12, MAXY+12, 9, 9, BLACK, COPY_IMAGE);
   storeimage(0, MAXY, 32, 32, image_or[0]);   /* save the pure-white image */

                            /* display all the graphics -- ready to animate */
   writeimage(6, 50, COPY_IMAGE, image[0]);
   writeimage(6, 150, COPY_IMAGE, image[0]);
   writepixelimage(6, 250, image[1]);
   writepixelcompressimage(6, 350, image[2]);
   if (mouse == TRUE) showms();        /* if mouse detected, show ms cursor */
   getchr();    /* wait for a keypress before beginning animation sequences */
   graphic->maxx = graphic->maxy = 32; /* initialize the graphic dimensions */
   graphic->x = 6, graphic->y = 50;   /* initialize graphic coordinates    */
   if (mouse == TRUE) hidems();        /* if mouse detected, hide ms cursor */

   for (i = 6; i < MAXX - 37; graphic->x = i, i += 2) {
      if (keyhit()) {                  /* if the user hit a key..           */
         getchr();                     /* read the key                      */
         if (keyp.ascii == 27)         /* if it was the <ESC> key..         */
            exit(0);                   /* exit to DOS with errorlevel 0     */
         break;                       /* else abort this animation sequence */
      }
      animate((int *)graphic, i, 50, 0, image_or, image, bgscrn);
   }

   graphic->x = 6, graphic->y = 150;
   for (i = 6; i < MAXX - 37; graphic->x = i, i += 2) {
      if (keyhit()) {                  /* if the user hit a key..           */
         getchr();                     /* read the key                      */
         if (keyp.ascii == 27)         /* if it was the <ESC> key..         */
            exit(0);                   /* exit to DOS with errorlevel 0     */
         break;                       /* else abort this animation sequence */
      }
      animate1((int *)graphic, i, 150, 0, image, bgscrn);
   }

   graphic->x = 6, graphic->y = 250;
   for (i = 6; i < MAXX - 37; graphic->x = i, i += 2) {
      if (keyhit()) {                  /* if the user hit a key..           */
         getchr();                     /* read the key                      */
         if (keyp.ascii == 27)         /* if it was the <ESC> key..         */
            exit(0);                   /* exit to DOS with errorlevel 0     */
         break;                       /* else abort this animation sequence */
      }
      animatepixel((int *)graphic, i, 250, 1, image, bgscrn);
   }

   graphic->x = 6;
   for (i = 6; i < MAXX - 37; graphic->x = i, i += 2) {
      if (keyhit()) {                  /* if the user hit a key..           */
         getchr();                     /* read the key                      */
         if (keyp.ascii == 27)         /* if it was the <ESC> key..         */
            exit(0);                   /* exit to DOS with errorlevel 0     */
         break;                       /* else abort this animation sequence */
      }
      animatebestss(graphic->x, 350, i, 350, image[2], image[2], bgscrn);
   }

   free(image_or[0]);                  /* free all allocated memory         */
   for (i = 0; i < 3; i++) free(image[i]);
   if (mouse == TRUE) showms();        /* if mouse detected, show ms cursor */
   getchr();                           /* wait for keypress before exitting */
   if (mouse == TRUE) hidems();        /* if mouse detected, hide ms cursor */
   changevideomode(oldmode);           /* restore the original video mode   */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(1);                      /* restore text video memory         */
      cursor(1, 1);                    /* show and restore cursor position  */
   }
}
