/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strinsert
 *
 *  Description :  Insert a string in another.
 *
 *  Parameters  :  in   char   *out_str    out string
 *                 in   char   *in_str     in string 
 *                 in   char   *to_insert  in string to insert into the other
 *                 in   int    place       place to insert string
 *                                        
 *  Decisions   :  Does nothing if place specified out of range.
 *
 *  Return      :  pointer to result
 *
 *  OS/Compiler :  All
 ***/

char *strinsert( char *out_str, const char *in_str, const char *to_insert, int place )

{ char *out_ptr = out_str, buffer[255], *ptr = buffer;

  if ( place <= 0 ) return ptr;
                           
  if ( in_str == out_str ) { while( -- place ) if ( ! *out_str++ ) return(out_ptr);
  			     while ( *ptr++ = *in_str++ ); /* strcpy : used if in_str = out_str */
			     ptr = buffer;
			   }
		      else { while( -- place ) if ( ! (*out_str++ = *in_str++) ) return(out_ptr);
		      	     ptr = in_str;
			   }

  while( *out_str++ = *to_insert++ );
  out_str --;

  while ( *out_str++ = *ptr++ );

  return out_ptr;
}
