MASM51
.XALL

MaxDriversNo    = 24;  <----- If you want to define more drivers change this number

; ----------------------------------------------------------------------
; Adding, deleting or changing the order of drivers definitions requires
; appriopriate changes in PRTGRAPH.H and PDrivers.pas.
; ----------------------------------------------------------------------

include drivers.inc

MODEL FarStack large
;;.MODEL FarStack large pascal

IFDEF WithCode

   .CODE

   PUBLIC pascal PRT_GetDriversAddress
   PRT_GetDriversAddress PROC pascal FAR
                   mov  AX , offset PRT__Drivers
                   mov  DX , seg PRT__Drivers
                   RET
   PRT_GetDriversAddress ENDP

ENDIF

  .DATA

               even
PRT__Drivers   LABEL WORD
                 db  'PR' ; identification word
                 dw  EndHeadSection-PRT__Drivers     ; head size in bytes
HeadSection      LABEL  word
                 db  96,0   ; version
                 db  96,0   ; minimum program version
PRT__DriversNo dw  ?  ; will be defined at the end of the file
                 dw  (DriversOffsets - PRT__Drivers) /2  ; index to DriversOffsets
                 dw  (DriversNamesOffsets-PRT__Drivers)/2  ; index to DriversNamesOffsets
DriversOffsets  dw  MaxDriversNo+1 dup (0) ; place for drivers definitions offsets

EndHeadSection label word


        ; /*===============================*/
        ; /* NULL (dummy) driver - not used currently */
        ; /*===============================*/
         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType 0
         DriverName      <'Dummy'> ;
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin      NULL,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin       NULL,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings   NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options         0

         ModeDef  60,60,2,<Do-not use this driver>;  /* X and Y densities, ColorsNo */
         ModeOptions    0;                       /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer   NULL,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr        NULL;                         /* EolnStr          */
         SmallEoln      NULL,NULL,2,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

        ; /*===============================*/
        ; /* 9-pins : STAR SR              */
        ; /*===============================*/
         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType 0
         DriverName      <'9 pins: STAR SG/SR'> ;
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <1bh,'M'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <1bh,'R'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'g',0>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,2,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'g',1>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,2,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,144,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'g',1>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,144,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette     NULL;                  /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'g',3>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         EndDriverDef   ; <----------------------------


         ;/*===============================*/
         ;/* 9 pins : IBM, EPSON */
         ;/* graphic mode: Esc, 'K'/'L'/'Z'  */
         ;/*===============================*/

         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType 0
         DriverName     <'9 pins: IBM, EPSON'>
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'K'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     3
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'Z'>,NULL
         PinsPerHead    8
         PixelsStep     3
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         EndDriverDef   ; <----------------------------


         ;/*===============================*/
         ;/* 9 pins : EPSON  II            */
         ;/* graphic mode: Esc '*' n       */
         ;/*===============================*/

         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType 0
         DriverName     <'9 pins: Epson'>
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',0>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',1>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',1>,NULL
         PinsPerHead    8
         PixelsStep     3
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',3>,NULL
         PinsPerHead    8
         PixelsStep     3
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/* 9-pins : PANASONIC KX-P1124   */
         ;/*===============================*/

         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType 0
         DriverName       <'9 pins: Panasonic KX-P1124'>
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'K'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,5,2          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,5,2;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,144,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,5,4;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,144,2;                     /* X and Y densities,, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'Z'>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,5,4;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         if 0
            ;/*===============================*/
            ;/* 9 pins : IBM, EPSON color */
            ;/*===============================*/

            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType 0
            DriverName       <'9 pins(color): IBM, EPSON'>
            InitPRTStr      <_Esc,'U1'>;             /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
            ColorsStrings  <_Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */
            Options        0

            ModeDef  60,72,8;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette   NULL;                    /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'K'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,72,8;                      /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */ /* ?????????????????????????????? */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,216,8;                     /* X and Y densities */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  240,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'Z'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------

         else

            ;/*===============================*/
            ;/* 9 pins : IBM, EPSON color */
            ;/*===============================*/
            ;/* the same as previous but with Planes and SimPlanes bits on */
            ;/* This introduces some optimalization in changing ribbon  */
            ;/* current color but it assumes that any composed color */
            ;/* can be build from colors c1 and c2 which are  */
            ;/* power of 2. E.G. color orange(0x5) is composed */
            ;/* of yellow(4) and red(1).                      */
            ;/* It may not work for more than 7 colors available. */
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType 0
            DriverName       <'9 pins(color): IBM, EPSON'>
            InitPRTStr      <_Esc,'U1'>;             /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
            ColorsStrings  <_Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */
            Options        0

            ModeDef  60,72,8;                       /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'K'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,72,8;                      /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */ /* ?????????????????????????????? */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  240,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'Z'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------
         endif


            ;/*===============================*/
            ;/* 9 pins : Epson II color */
            ;/*===============================*/
            ;/* graphic mode: Esc '*' n */
            ;/*
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType 0
            DriverName       <'9 pins(color): Epson'>
            InitPRTStr      <_Esc,'U1'>;             /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
            ColorsStrings  <_Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */
            Options        0

            ModeDef  60,72,8;                       /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'*',0>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,72,8;                      /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */ /* ?????????????????????????????? */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'*',1>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransfer <CR, _Esc,'*',1>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  240,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
			InitTransfer <CR, _Esc,'*',3>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------


         ;/*===============================*/
         ;/* Epson LQ 1000                 */
         ;/*===============================*/

         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType 0
         DriverName       <'24 pins: Epson LQ1000'>
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
		 CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <_Esc,'r'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv ??????????????? ?????????? */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  60,180,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',20h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
		 ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',21h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',27h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
		 SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
		 EolnStr   NULL;                         /* EolnStr          */
		 SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

		 ModeDef  360,360,2;                     /* X and Y densities, ColorsNo */
		 ModeOptions  0;                         /* Planes, SimPlanes */
		 ColorPalette       NULL;                /* Color palette        */
		 InitGraphStr   NULL                    /* InitGraphStr */
		 EndGraphStr    <_Esc,'@'>;               /* EndGraphStr  */
		 PicWidth
		 InitTransfer <CR, _Esc,'*',28h>,NULL
		 PinsPerHead    24
		 PixelsStep     2
		 EolnStr   NULL;                         /* EolnStr          */
		 SmallEoln  <_Esc,'+'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
		 EndDriverDef   ; <----------------------------

		 ;/*===============================*/
		 ;/*   IBM Pro X24                 */
		 ;/*===============================*/
		 DriverDef
		 ;         5,                            /* ModesNo  */
       CompressionType 0
		 DriverName       <'24 pins: IBM Pro X24'>
		 InitPRTStr      NULL;                   /* Init PRT string */
		 EndPRTStr       NULL;                   /* End PRT string */
		 CompressedStr   NULL;                   /* CompressedStr  */
		 UncompressedStr NULL;                   /* UncompressedStr  */
		 LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
       TopMargin      <_Esc,'r'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
       ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
       Options        TransferValueInBytes

       ModeDef  60,180,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<8>,-1
		   PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

       ModeDef  120,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
		   EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<9>,-1
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

       ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
		   InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<11>,-1
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

		 ModeDef  360,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<12>,-1
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

      ModeDef  360,360,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <_Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<12>,-1
         PinsPerHead    24
		   PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
		   SmallEoln  <_FS,'3'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/* EPSON LQ860                   */
         ;/*===============================*/
         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType 0
		   DriverName       <'24 pins(color): EPSON LQ860'>
         InitPRTStr      <_Esc,'U1'>;             /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      NULL,NULL,1,1;             /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????????? */
		   ColorsStrings  <_Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  60,180,8;                      /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',20h>,NULL
         PinsPerHead    24
         PixelsStep     1
		   EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
		   InitTransfer <CR, _Esc,'*',21h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,8;                     /* X and Y densities,, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
		   PicWidth
         InitTransfer <CR, _Esc,'*',27h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
		   ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,360,8;                     /* X and Y densities, ColorsNo */
		   ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <_Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     2
         EolnStr        NULL;                    /* EolnStr          */
		   SmallEoln  <_Esc,'+'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/* 24 pin IBM Pro X24 (color)    */
         ;/*===============================*/
         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType 0
         DriverName       <'24 pins(color): IBM Pro X24'>
         InitPRTStr      <_Esc,'U1'>;             /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      NULL,NULL,1,1;             /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
         ColorsStrings  <_Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */
         Options        TransferValueInBytes

         ModeDef  60,180,8;                      /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<8>,-1
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<9>,-1
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<11>,-1
		   PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<12>,-1
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,360,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
		   InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <_Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,'[g'>,<12>,-1
         PinsPerHead    24
         PixelsStep     2
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_FS,'3'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

            ;/* PaintJet */
            ;/*    without Run Length Encoding compression     */
            ;/*===============================*/
            ;/* general PaintJet       */
            ;/*===============================*/
            DriverDef
            ;         3,                            /* ModesNo  */
            CompressionType 0
            DriverName       <'PaintJet'>
            InitPRTStr      <_Esc,'9', _Esc,'&s1C',_Esc,'*b0M'>;  /* Init PRT string */
            EndPRTStr       <_Esc,'*r0B'>;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <_Esc,'&a'>,<'H'>,1,1;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
            Options        ASCIInumbers+TransferValueInBytes

            ModeDef  90,90,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t90R', _Esc,'*r1U', _Esc,'*r1A' >;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t180R', _Esc,'*r1U', _Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  90,90,16;                      /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t90R', _Esc,'*r4U', _Esc,'*r1A' >;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <_Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t180R', _Esc,'*r3U', _Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <_Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------


            ;/*===============================*/
            ;/* Hewlet Packard PaintJet       */
            ;/*===============================*/
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType RLE_COMPRESSION
            DriverName       <'HP PaintJet'>
            InitPRTStr      <_Esc,'9', _Esc,'&s1C'>;  /* Init PRT string */
            EndPRTStr       <_Esc,'*r0B'>;           /* End PRT string */
            CompressedStr   <_Esc,'*b1M'>;           /* CompressedStr  */
            UncompressedStr <_Esc,'*b0M'>;           /* UncompressedStr  */
            LeftMargin     <_Esc,'&a'>,<'H'>,1,1;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
            Options        ASCIInumbers+TransferValueInBytes

            ModeDef  90,90,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t90R', _Esc,'*r1U', _Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t180R', _Esc,'*r1U', _Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  90,90,16;                      /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t90R', _Esc,'*r4U', _Esc,'*r1A'>;
            COMMENT \\
               following commands should set Paintjet palette as close
               to VGA one as possible.
                 <_Esc,'*v90A', _Esc,'*v88B', _Esc,'*v85C', _Esc,'*v00I' >;
                 <_Esc,'*v04A', _Esc,'*v04B', _Esc,'*v29C', _Esc,'*v01I' >;
                 <_Esc,'*v03A', _Esc,'*v26B', _Esc,'*v22C', _Esc,'*v02I' >;
                 <_Esc,'*v02A', _Esc,'*v22B', _Esc,'*v64C', _Esc,'*v03I' >;
                 <_Esc,'*v53A', _Esc,'*v08B', _Esc,'*v14C', _Esc,'*v04I' >;
                 <_Esc,'*v53A', _Esc,'*v05B', _Esc,'*v25C', _Esc,'*v05I' >;
                 <_Esc,'*v12A', _Esc,'*v08B', _Esc,'*v10C', _Esc,'*v06I' >;
                 <_Esc,'*v43A', _Esc,'*v43B', _Esc,'*v45C', _Esc,'*v07I' >;
                 <_Esc,'*v15A', _Esc,'*v16B', _Esc,'*v18C', _Esc,'*v08I' >;
                 <_Esc,'*v03A', _Esc,'*v10B', _Esc,'*v46C', _Esc,'*v09I' >;
                 <_Esc,'*v29A', _Esc,'*v57B', _Esc,'*v28C', _Esc,'*v10I' >;
                 <_Esc,'*v38A', _Esc,'*v58B', _Esc,'*v78C', _Esc,'*v11I' >;
                 <_Esc,'*v62A', _Esc,'*v18B', _Esc,'*v18C', _Esc,'*v12I' >;
                 <_Esc,'*v76A', _Esc,'*v45B', _Esc,'*v62C', _Esc,'*v13I' >;
                 <_Esc,'*v89A', _Esc,'*v83B', _Esc,'*v13C', _Esc,'*v14I' >;
                 <_Esc,'*v04A', _Esc,'*v04B', _Esc,'*v06C', _Esc,'*v15I' >;
           \\

            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <_Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t180R', _Esc,'*r3U', _Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <_Esc,'*r'>,<'S'>,1,1
            InitTransfer <_Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <_Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------

            ;/* LaserJet */
            ;/*    without Run Length Encoding compression     */
            ;/*===============================*/
            ;/* general HP LaserJet       */
            ;/*===============================*/
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType 0
            DriverName       <'HP LaserJet'>
            InitPRTStr      <_Esc,'9', _Esc,'&s1C', _Esc,'*b0M'>;  /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <_Esc,'*p'>,<'X'>,3,10;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
            Options        ASCIInumbers+FormFeedNeeded+TransferValueInBytes

            ModeDef  75,75,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t75R', _Esc,'*r1A' >;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  100,100,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t100R', _Esc,'*r1A' >;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  150,150,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t150R', _Esc,'*r1A'>;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  300,300,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t300R', _Esc,'*r1A'>;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------


            ;/*===============================*/
            ;/* Hewlet Packard LaserJet II      */
            ;/*===============================*/
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType RLE_COMPRESSION
            DriverName       <'HP LaserJet II'>
            InitPRTStr      <_Esc,'9', _Esc,'&s1C'>;  /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   <_Esc,'*b1M'>;           /* CompressedStr  */
            UncompressedStr <_Esc,'*b0M'>;           /* UncompressedStr  */
            LeftMargin     <_Esc,'*p'>,<'X'>,3,10;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <_Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
            Options        ASCIInumbers+FormFeedNeeded+TransferValueInBytes

            ModeDef  75,75,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t75R', _Esc,'*r1A'>;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  100,100,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t100R', _Esc,'*r1A'>;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  150,150,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t150R', _Esc,'*r1A'>;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  300,300,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <_Esc,'*t300R', _Esc,'*r1A'>;
            EndGraphStr    <_Esc,'*rB'>;
            PicWidth
            InitTransfer <_Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------


   if   0
         ;/*===============================*/
         ;/* 9 pins : EPSON                */
         ;/*===============================*/
         DriverDef
         ;         2,                            /* ModesNo  */
         CompressionType 0
         DriverName       <'9 pin: EPSON (9 pin graphic)'>
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <_Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <_Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */
         Options        0

         ModeDef  120,72;                        /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,05Eh,1>,NULL
         PinsPerHead    9
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransfer <CR, _Esc,05Eh,1>,NULL
         PinsPerHead    9
         PixelsStep     3
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <_Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------
   endif


   EndDrivers

     END

     END
