    name GETCPU
    page 55,132
    title    'GETCPU.BIN --- Determines which INTEL CPU is installed'
;--------------------------------------------------------------------
; This program determines which Intel CPU is being used in the
; machine, whether it is an 8088/86, 80188/186, 80286 or 80386.
; It uses documented and supported differences in flag register bit
; configurations to determine whether the CPU is an 80286 or 80386,
; and differences in shifting using CL to determine if it is an
; 8088/86 or 80188/186. It is intended to be used as an external
; routine from Turbo Pascal, and returns an integer result in the
; form of the last three digits of the processor type,
; as depicted in the table below.
;
; If the processor is    The routine returns
; -------------------    -------------------
;      80386                    386
;      80286                    286
;      80188/186                186
;      8088/86                   86
;
;--------------------------------------------------------------------
; Declaration of the routine in Pascal V4.0 is:
;
;      {$L GETCPU}
;      function GETCPU : integer; external;
;
;--------------------------------------------------------------------
; To assemble:
;
; MASM GETCPU;
;--------------------------------------------------------------------
; Code segment begins here
;--------------------------------------------------------------------
code     segment   para public 'CODE'
    assume    cs:code
    public    getcpu
;--------------------------------------------------------------------
; Actual id routine begins here
;--------------------------------------------------------------------
getcpu   proc near
    pushf              ; Save the flag registers, we use them here...
    xor  ax,ax         ; Clear AX and push it onto the stack
    push ax
    popf           ; Pop 0 into flag registers (all bits to 0),
    pushf          ; attempting to set bits 12-15 of flags to 0's
    pop  ax        ; Recover the saved flags
    and  ax,08000h ; If bits 12-15 of flags are set to zero then
    cmp  ax,08000h ; cpu is 8088/86 or 80188/86
    jz   _8x_18x
;--------------------------------------------------------------------
; It is either an 80286 or an 80386, let's find out which...
;--------------------------------------------------------------------
    mov  ax,07000h ; Try to set flag bits 12-14 to 1's
    push ax        ; Push the test value onto the stack
    popf           ; Pop it into the flag register
    pushf               ; Push it back onto the stack
    pop  ax        ; Pop it into AX for check
    and  ax,07000h ; If bits 12-14 are cleared then the chip is
    jz   _286      ; an 80286
;--------------------------------------------------------------------
; Ok, we know it's an 80386 now, tell the user about it!
;--------------------------------------------------------------------
    mov  ax,386         ; It's not a 286, so it must be a 386
    jmp  DONE
;--------------------------------------------------------------------
; Tell the user it is an 80286
;--------------------------------------------------------------------
_286:    mov  ax,286         ; Get the msg ready
    jmp  DONE
;--------------------------------------------------------------------
; We know it is either an 8088/86 or 80188/86, but which one is it?
;--------------------------------------------------------------------
_8x_18x:
    mov  ax,0ffffh ; Set AX to all 1's
    mov  cl,33          ; Now we try to shift left 33 times. If it's
    shl  ax,cl          ; an 808x it will shift it 33 times, if it's
                   ; an 8018x it will only shift one time.
    jnz  _18x      ; Shifting 33 times would have left all 0's.
                   ; If any 1's are left it's an 80188/186
    mov  ax,86          ; No 1's, it's an 8088/86
    jmp  DONE
;--------------------------------------------------------------------
; It's an 80188 or 80186...
;--------------------------------------------------------------------
_18x:    mov  ax,186   ; Found a 1 in there somewhere, it's an 80188
                       ; or an 80186
;--------------------------------------------------------------------
; All done, let's go back...
;--------------------------------------------------------------------
DONE:    popf          ; Restore the flag registers
    ret
;--------------------------------------------------------------------
; End of code and segment
;--------------------------------------------------------------------
getcpu   endp
code     ends
    end  getcpu
