/* inptrrxd.i: initializes pointers to Reflex data base control
   info entry points.
     Assumes reflex.h has been #included and globals 'base' and
   'head' have been initialized for stack operation. 
     This file is #included inline after loading the control
   info onto the heap and before the application tries to use
   the control info to do anything */

                     /* ---- initialize pointers to fixed sections */
  descr = (DFDESC*)(base + 66);             /* section descriptors */
  sort = (SORTSPEC*)(base + head->hdrSz);            /* sort specs */
                      /* ---- initialize ptrs to variable sections */
                                                /* field name pool */
  work = (int*)((unsigned)(sort) + 11);
  temp = (unsigned)(work) + *work + 4;
  pool = (char*) temp;
                                         /* field descriptor table */
  temp = (unsigned)(pool) - 2;
  work = (int*)(temp);
  temp += (unsigned)(*work + 4);
  dtable = (FLDDESC*) temp;
                                     /* calculate number of fields */
  work = (int*)(unsigned)(dtable) - 1;
  nflds = *work / sizeof (FLDDESC);
              /* enumerated text pool (point to first index length */
  temp += (unsigned) *work + 8;
  etpool = (int*) temp;
                                                  /* master record */
  mast = (MASTREC*)(unsigned)((descr+1)->dfAddr + base - 1);

