/*
    Filename: C:\DAVE\CPP\E\random.cpp
    Author  : Dave Nelson
    Created : Sun 18-Oct-1998 19:45:01
    Modified: Sat 24-Jul-1999 11:15:04 - Dave Nelson

    Gruesomely inefficient routines for obtaining pseudo-random numbers
    within a specific range.
*/

#include <time.h>
#include <stdlib.h>

static int seeded = 0;

/*Function: seedgen
      Descr: Seeds the standard library's random number generator using a
             couple of machinations around the system time.
       Args: none
     Return: void
*/
void seedgen(){
time_t t = time(NULL);
struct tm *tp = localtime(&t);
    srand( (tp->tm_sec+1) * (tp->tm_min+1) );
    for(int b=rand(); b; b--){ rand(); }
    srand( rand()* ((unsigned)clock()) );
    seeded = -1;
    }

/*Function: random
      Descr: Returns a random number within the specified range, eventually.
             The distribution is actually pretty good, but it's SLOW!
       Args: int min    - Minimum acceptable value
             int max    - Maximum acceptable value
     Return: int
*/
int random(int min, int max){
int x;
double d,m;
    if(!seeded) seedgen();
    do {
        d = ((double)rand())*.0001;
        x=(int)(d*max);
        }
    while (x<min||x>max);
    return x;
    }

#if 0
#include <stdio.h>
void main(){
    printf("Random number from 1 to 100: %d", random(1,100) );
    }
#endif
