(*

Psych0Tag - version 0.499
Public Domain by Andrew Ziem

Compiles with Turbo Pascal v7.00 and Virtual Pascal 0.003 beta.
See included files for more information.

Note: This is messy, but I do not wish to clean it up.  I have little notes
      and such spread about, and I like them there.  =)

Bug:  Line is not split properly under certain conditions.  I think when it's
      shorter than 79 without the three periods, but longer than that with
      them.

 *)

{.$define __OS2__}   { required when compiling in OS/2 }

{.$DEFINE BETA}

{$R-} {Range checking off}
{$S-} {Stack checking on}
{$X+} {extended syntax}
{$I-} {Io checking}
{$V-} {var string checking switch}
{$Q-} {over flow checking}
{$S-} {stack checking}
{$R-} {range checking}
{$D+} {.map}
{$L+} {.map}

{$IFDEF BETA} {.$D+,R+,Q+} {$ENDIF}
{$M 16384,0,16384}


uses
{$IFDEF __OS2__} {$IFDEF TMT} BASE32, {$ELSE} USE32, {$ENDIF} {$ENDIF}
 DOS,
 CRT;

{                  Psych0's Tagline Program...

Needs:
 * .., 1,2,3 type.. Always,Never,Check
 * diffrent line search modes

 }

const
fnamelength = 79;

nothing_str = 'Nothing to do; for help run "PTAG ?".';
errstr_inputfilenotfound     = 'input file not found' ;
errstr_couldnotopenoutputfile= 'could not open output file' ;
warningstr = 'WARNING: ' ;
debugstr   = 'DEBUG: ' ;
betastr   =  'BETA: ' ;

BetaNumber   = '2';
PTVersionID  = 'v0.492' {$IFDEF BETA}  +''+BetaNumber {$ENDIF} {$IFDEF TMT}+'.TMT'{$ENDIF} ;
CfgName      = 'PTAG.CFG';
Date1        = '97/09/01';
Date2        = 'Sep 01 97';
BaseName     = 'Psych0Tag' {$ifdef __OS2__} +'/2 '{$ENDIF} ;
Hdr1 = basename+' '+PTVersionId+' -- '+Date2+#13#10
       +'Public Domain by Andrew Ziem.  Enjoy!  (or else...)';
Hdr2 = 'Psychosis Fido 1:128/234, psych0o@juno.com, psych0o@aol.com';

bragline = '-=- ' + basename + ' ' + PtVersionId ;

helplevelRegular    = 0 ;
helplevelCompilation= 1 ;
helplevelExtraComp  = 2 ;

tagsize      = 255;                            { standard length is 72 bytes }
splitlength : byte = 79;                                { screen wraps at 80 }

maxcfg       = 256;

c_error      = 12;

{ commands }
cmNone    =  0;
cmHelp    =  1;
cmTag     =  2;
cmCompile =  3;
cmUpdate  =  4;

{ braglines }
blTop    =  0;
blBottom =  1;
blNone   =  2;

{ how to handle long taglines }
ltHang   =  0;
ltTrunc  =  1;
ltWrap   =  2;

{ ellipses }
aeIgnore =  0;
aeAdd    =  1;
aeRemove =  2;

wcHdr    =    0;
wcHelp   =    1;
wcInfo   =    2;
wcAction =    3;    { eg: Compling, Updating }
wcTag    =    4;
wcBeta   =  252;
wcDebug  =  253;
wcWarning=  254;
wcError  =  255;



type

fnamestring = string[fnamelength];

TagRec = record
     Title           : string[30];
     FileName        : string[70];
     Quantity        : LongInt; {2,147,483,647}
     Weight          : byte;
     TimeDate        : longint;
     end;


RCfg = record  {never written to disk}
     CfgName       ,           {Cfg name}
     OutputFile    : string;    {File to append}
     TagtoUse      : string[TagSize];
{     tmpstr        : string[TagSize]; {temp string}
{     t_text        : text;    {text for various uses}
{     t_text2       : text;
{     tmplint       : longint; {Temporary longint var}
{     tmpint        : integer;
{     tmpval        : }
     handle_long,
     ellipsis       : byte;
     write_to_file,
     makefile       : boolean;
     bragline       : byte;
     end;

tagcfgarray = Array[1..maxcfg] of ^tagrec;

var

{x         : word;
TmpWord   : word;    {Temporary Word variable}

TagCfg    : record
             tag   : tagrec;
             arr   : tagcfgarray;
             f     : file of tagrec;
             max   : word;
             end;
Cfg       : RCfg;
error     : byte;
debugmode : boolean;
oldcolor  : byte;


{$I consts.pas}
 {$define existdirinfo}
{$I common.pas}


procedure halt (b:byte) ;
var
 x: byte;

begin;
textattr:=oldcolor;
for x := 1 to tagcfg.max do
 if tagcfg.arr[x]<>nil then dispose (tagcfg.arr[x]) ;
{if textrec(cfg.t_text).mode<>fmClosed then close(cfg.t_text);}
system.halt(b);
end;

procedure CritError (errorstr:string);
begin;
textattr:=c_error;
writeln('*** ',errorstr, ' (ERR) ***');
halt(255);
end;

procedure WriteLnPtag(class: byte; str: string);
begin;
case class of
 wcHdr       : textattr:=9;
 wcInfo      : textattr:=7;
 wcTag,
 wcAction,
 wcHelp      : textattr:=3;
 wcBeta,
 wcDebug     : textattr:=yellow;
 wcWarning,
 wcError     : textattr:=12;
 end;
case class of
 {$IFDEF BETA}
 wcBeta      : write(betastr);
 {$ENDIF}
 wcDebug     : if debugmode then write(debugstr);
 wcWarning   : write(warningstr);
 end;
if (class=wcDebug) and (debugmode) then
 writeln(str) else
 if class<>wcDebug then
 writeln(str);

end;

{$ifdef extrhelp}
procedure givehelp(level:byte); {$else}
procedure givehelp;
{$endif}

begin;
clrscr;
writelnptag(wchdr, hdr1);
writeln(hdr2);
Writeln;

 WritelnPtag(wcHelp,
         'Help'+CRLF);

 writeln('Usage: PTAG <command> <command stuff> [-<switch> [-<switch>...]]');
 writeln;
 writeln('  Commands:');
 writeln;
 writeln('  c: compile text configuration');
 writeln('  u: update configuration');
 writeln('  o: output a tagline to a file');
 writeln;
 writeln('  Switches:');
 writeln;
 writeln('  ac: specify compiled configuration file');
 writeln('   b: brag-line (``-=- Psych0Tag'')');
 writeln('   c: creates output file if it does not exist');
 writeln('   d: enable debug mode and extra information');
 writeln('   e: allow ellipsis (``...'')');
 writeln('   l: long taglines handling');
 writeln;
 writeln('See accompanying documentation for more detailed information.');

halt(0);
end;

procedure ReadTxtCfgLine (var T: Text; Var S: String );
begin;
repeat
 readln(T, S);
{ writeln('read "'+S+'"');
 readkey; }
 {HERE!}
 until (S[1] <> ';') or (EOF(T)=TRUE);
end;

function CalculateLinesInFile (calcfilename:string): longint;
var
 txt  : text;
 str  : string;
 lint : longint;

begin;
writelnptag(wcDebug,'calculating the number of lines in "'+calcfilename+'"');
lint:=0;

assign(txt,calcfilename);
{$I-} reset(txt); {$I+}
if ioresult > 0 then
 writeLnptag(wcwarning,'cannot open "'+calcfilename+'"; assuming presence of 0 lines.') else
 begin
 while not eof(txt) do
  begin;
  readln(txt,str);
  inc(lint);
  end;
 close(txt);
 end;

CalculateLinesInFile:=lint;
end;


procedure ReadTxtConfig (configfile:string);
var
 int   : os_int;
 w     : word;
 txt   : text;
 txt2  : text;
 str   : string;

begin;
if not exist(configfile) then
 CritError('can not find text config file "'+configfile+'"');

assign(txt, configfile);
reset(txt);
tagcfg.max:=0;
w:=0;

{figure out if we have enough lines}
while not eof(txt) do
 begin;
 ReadTxtCfgLine(txt,str);
 inc(tagcfg.max);
 end;
tagcfg.max:=trunc(tagcfg.max/3);

if tagcfg.max=0 then
 CritError('text config must contain atleast one full entry');

{we do...}

reset(txt);

new(tagcfg.arr[1]);

while not EOF(txt) do
 begin;
 ReadTxtCfgLine(txt,TagCfg.tag.title);
 ReadTxtCfgLine(txt,TagCfg.tag.filename);

 if not exist(tagcfg.tag.filename) then
  WritelnPtag(wcWarning,
   'tagline file "'+tagcfg.tag.filename+'" does not exist');

 ReadTxtCfgLine(txt,str);

 val(str, tagcfg.tag.quantity, int);

 if int > 0 then
  writelnptag(wcWarning,
    'numeric conversion at position'+inttostr(int)+' of "'+str+'"');

{ writeln('exist=',exist(tagcfg.tag.filename));
 writeln('other=',(tagcfg.tag.quantity=0));
 writeln('and=',exist(tagcfg.tag.filename) and (tagcfg.tag.quantity=0));}

 if {(exist(tagcfg.tag.filename) and} (tagcfg.tag.quantity=0) then
  tagcfg.tag.quantity:=CalculateLinesInFile(tagcfg.tag.filename);


 if TagCfg.tag.filename <> '' {and (TagCfg.tag.name<>'')} then
  begin;

  writelnPtag(wcDebug,
   padr('"'+tagcfg.tag.title+'"',33,' ')+inttostr(tagcfg.tag.quantity));

  inc(w);
  new(tagcfg.arr[w]);
  tagcfg.arr[w]^:=tagcfg.tag;
  tagcfg.arr[w]^.weight:=1;
  end;
 end; { tagline is good }

tagcfg.max:=w;
close(txt);
end;

procedure CompileCfg(x:word);
var
 txt   : text;
 w     : word;
 str   : string[TagSize];

begin;
WritelnPtag(wcAction,
 'Compiling "'+ParamStr(x+1)+'" > "'+ParamStr(x+2)+'" ...');

if not exist(ParamStr(X+1)) then
 CritError(errstr_inputfilenotfound);
{ If not FileExists(ParamStr(X+1),'input file',true); {then begin end; }
{    If not FileExists(ParamStr(X+2),'output file',true) then exit;  }
readtxtconfig(paramstr(x+1));

for w:=1 to tagcfg.max do
 if tagcfg.arr[w]^.quantity=0 then
  tagcfg.arr[w]^.quantity:=CalculateLinesInFile(tagcfg.arr[x]^.filename);

WritelnPtag(wcAction,
 'Writing '+IntToStr(tagcfg.max)+' entries to "'+paramstr(X+2)+'" ...');

assign(tagcfg.f,paramstr(X+2));
rewrite(tagcfg.f);
for w:=1 to tagcfg.max do
 write(tagcfg.f,tagcfg.arr[w]^);
close(tagcfg.f);
halt(0);

end;

Procedure ReadConfig(configfile: string);
var
 w   : word;

begin;
if not exist(configfile) then
 CritError('can not find compiled config file "'+configfile+'"');

w:=0;
assign(tagcfg.f,configfile);
reset(tagcfg.f);
tagcfg.max:=filesize(tagcfg.f);
{create_array(tagcfg.arr,1,tagcfg.max,sizeof(tagcfg.tag));}

while not eof(TagCfg.f) do
 begin
 inc(w);
 if memavail < sizeof(tagrec) then
  begin;
  writelnptag(wcWarning,'not enough memory to read entire file');
  break;
  end;
 new(tagcfg.arr[w]);
 {$I-} read(TagCfg.f, TagCfg.arr[w]^); {$I+}
 if IOResult = 100 then CritError('the configuration files are invalid, try recompiling')
  else if ioresult > 0 then criterror('can''t read configuration files');
 end;
tagcfg.max:=filesize(tagcfg.f);
close(tagcfg.f);
end;


procedure Update(filename:string);
var
 w     : word;
 lint  : longint;

begin;
WritelnPtag(wcaction, 'Updating "'+filename+'"');

if not exist(filename) then
 CritError('can not find file for update');

readconfig(filename);

for w:=1 to tagcfg.max do
 begin;
 textattr:=7;
 write(padr('"'+tagcfg.arr[w]^.title+'"',33,' '),#13);

 lint:=CalculateLinesInFile(tagcfg.arr[w]^.filename);

 if lint <> tagcfg.arr[w]^.quantity then
  begin;
  textattr:=3;
  write(padr('"'+tagcfg.arr[w]^.title+'"',33,' ')+' > ');
  textattr:=11;
  write(padr(inttostr(w),5,' '));
  if tagcfg.arr[w]^.quantity <> lint then
   begin;
   textattr:=7;
   write(' (',calcchange(tagcfg.arr[w]^.quantity,lint),')');
   end;
  writeln;
  tagcfg.arr[w]^.quantity:=lint;
  end;
 end;

write(padr(' ',33,' '),#13);
rewrite(tagcfg.f);
For w:=1 to tagcfg.max do
 write(tagcfg.f,tagcfg.arr[w]^);
close(tagcfg.f);
halt(0);
end;


function GetLine(LineNumber:LongInt; FileName: string) : string;
var
 lint   : longint;
 str    : string;
 txt    : text;

begin;
{writeln(', using #',linenumber);}
Assign(txt,filename);
reset(txt);
lint:=0; {Take out??}
{$R-}
    Repeat
    readln(txt,str);
    inc(lint);
    until lint > linenumber;
{.$R+}
getline:=str;
close(txt);
end;

function Detectperiods:boolean;
{ var tl:string;}
 begin;
{tl:=cfg.tagtouse;}
 detectperiods:=(Pos('...',cfg.tagtouse)=1);
{ if Tl[1]+Tl[2]+Tl[3]='...' then Detectperiods:=true else detectperiods:=false;}
 end;


procedure wwrap(var orig,wrapped,left:string; ellipses:boolean);
var
 x:integer;

begin

if (ellipses) and (cfg.ellipsis=aeAdd) then
 begin;
 x:=splitlength-4;
 wrapped:='... ';
 end else
 begin
 x:=splitlength;
 wrapped:='';
 end;


if (length(orig)>splitlength) then
 begin
 if (pos(#32,orig)<>0) then
  begin
  {x:=72}
  while (x>1) and (orig[x]<>#32) do dec(x);
  if (x=1) then
   begin
   wrapped:=wrapped+copy(orig,1,splitlength);
   left:=copy(orig,splitlength+1,255);
   end else begin
   wrapped:=wrapped+copy(orig,1,x);
   left:=copy(orig,x+1,255);
   end;
  end else begin
  wrapped:=wrapped+copy(orig,1,splitlength);
  left:=copy(orig,splitlength+1,255);
  end;
 end
 else
 begin
 wrapped:=wrapped+orig;
 left:='';
 end;
end;


procedure TagDisplaywrite;
var
safety : byte;
w      : word;
txt    : text;


 procedure WriteSplitTag(wststr:string; screen:boolean);

 var
  wrapped,
  left      : string;

 { #210 ('', Pi) should hard-split the line }

 begin;
 wrapped:='';
 left:='';

 while (wststr<>'') do
  begin
  wwrap(wststr,wrapped,left,not screen);
  wststr:=left;
  if screen then
   writelnptag(wcTag, wrapped) else
   writeln(txt, wrapped);
  end;

 end;

 procedure WriteTag;
 begin;
 WriteLnPtag(wcDebug, 'adding tagline to "'+cfg.outputfile+'"');
 {$I-}
 assign(txt, cfg.outputfile);
 append(txt);
 if ioresult > 0 then
  CritError(errstr_couldnotopenoutputfile);
{ if (ioresult>0) and (cfg.makefile) then rewrite(cfg.t_text);}
 {HERE!}

 if cfg.bragline=blTop then
  writeln(txt,bragline);

{ writeln(txt, cfg.TagtoUse); }

 WriteSplitTag(cfg.TagtoUse,false);

 if cfg.bragline=blBottom then
  writeln(txt,bragline);

 if ioresult > 0 then
  CritError('could not write to output file "'+cfg.outputfile+'"');

 close(txt);

{ if ioresult > 0 then
  criterror('could not close file'); }

 {$I+}
 end;

begin;{main}
randomize;
{ cfg.Tmpword:=random(Cfg.tagfiles)+1;}
safety:=0;

repeat
 w:=random(tagcfg.max)+1;
 inc(safety);
  if safety>50 then CritError('config does not have enough valid tagline filenames');
 until (exist(tagcfg.arr[w]^.filename)) ; {or (safety>50)}

 WritelnPtag(wcDebug, tagcfg.arr[w]^.filename+' contains '+
  inttostr(tagcfg.arr[w]^.quantity)+' taglines');

safety:=0;
repeat
 cfg.TagToUse:= GetLine(Random(TagCfg.arr[w]^.quantity){+1},
  tagcfg.arr[w]^.filename);
 if safety>100 then CritError('tagline file has too many empty lines');
 until (cfg.tagtouse<>'')  {or (safety<100)};

{textattr:=3;}

{Writeln({', using #',linenumber,}{cfg.tagtouse);}

{if (detectperiods=false) and (cfg.ellipsis=aeAdd) then
 cfg.tagtouse:='... '+cfg.tagtouse; }


if length(cfg.tagtouse) = tagsize then
 writelnptag(wcWarning,'tagline may have exceeded the limit ('+inttostr(tagsize)+'b)');

if (detectperiods) and (cfg.ellipsis=aeRemove) then
 delete(cfg.tagtouse,1,4);

WriteSplitTag(cfg.tagtouse,true);

{ if detectperiods then
 dec(splitlength,4); }

{writeln(' File creation ',cfg.makefile);}
{if cfg.outputfile='' then exit;
{if (exist(cfg.outputfile)=false) and (cfg.makefile=false) then
 writeln('WARNING: output file non existant and creation not permitted') else}

{***********************append tagline***************************** }
{writetag;}

if Cfg.Write_To_File then

case exist(cfg.outputfile) of
 true :   WriteTag;
  {if debugmode then writelnPtag(wcDebug,debugstr+'appending tagline to "'+cfg.outputfile+'"');}

 false: begin;
        if cfg.makefile then
         begin;
         WritelnPtag(wcDebug,'creating "'+cfg.outputfile+'"');
         {$I-}
         Assign(txt, cfg.outputfile);
         rewrite(txt);
         close(txt);
         {$I+}
         writetag;
         end else if debugmode then
          if cfg.outputfile<>'' then
           writelnptag(wcWarning,
           'output file does not exist and creation not permited');
         end;
  end;
end;




procedure InitCommandLine;


var
 int  : integer;
 w    : word;
 str  : string;

 command : byte;
{ cmdpos  : byte; }

begin;

{lse begin;
     textattr:=3;
     Writeln('Nothing to do. For help run "PTAG /?"');
     halt(0);
     end;}


command:=cmNone;
w:=1;

str:=ParamStr(w);

if upcase(str[1]) in ['?','C','D','U','O'] then
 begin { we have a command }
 case upcase(str[1]) of
  '?': command:=cmHelp;     { 1 }
  'D': begin;
{         cfg.write_to_file:=(upcase(str[1])='O'); }
       cfg.write_to_file:=false;
       command:=cmTag;      { 2 }
       end;
  'O': begin;
       cfg.write_to_file:=true;
       command:=cmTag;      { 2 }
       inc(w);
       end;
  'C': begin;
       command:=cmCompile;  { 3 }
       inc(w,2);
       end;
  'U': begin;
       command:=cmUpdate;   { 4 }
       inc(w);
       end;
  end; { case of str[1] }

 end
 else CritError('unknown command "'+str+'"');

for w:=w+1 to ParamCount do
 begin;

 {$IFDEF BETA}
 if w > paramcount then
  begin;
  break;
  writelnptag(wcerror,'uh-ohh!! (beta error#001)');
  end;
 {$ENDIF}

 str:=ParamStr(w);

 if str[1] in ['-' , '/'] then
 begin { switches }
 case upcase(str[2]) of

  '?': givehelp{$ifdef extrahelp}(helplevelRegular){$endif};

  'A': if upcase(str[3])='C' then
        Cfg.Cfgname:=ParamStr(w+1);

  'B': case upcase(str[3]) of
        '+','0': cfg.bragline:=blTop;
        'T','1': cfg.bragline:=blBottom;
        '-','2': cfg.bragline:=blNone;
{        else
         begin;
         writelnptag(wcwarning,'yo');
         val(copy(str,3,length(str)-3), splitlength, int);

         if int > 0 then
         writelnptag(wcWarning,
          'numeric conversion at position'+inttostr(int-3)+' of "'+str+'"');
         end;}
        end; { 'B' }

  'C': case str[3] of
        '-': cfg.makefile:=false;
        else cfg.makefile:=true;
        end; { 'C' }

    'D': debugmode:=true;

    'E': case str[3] of
          '+': cfg.ellipsis:=aeAdd;
          '-': cfg.ellipsis:=aeRemove;
          else if str[3]=#0 then
           cfg.ellipsis:=aeIgnore;
          end; { 'E' }


    'L': case upcase(str[5]) of
          '0': cfg.handle_long:=ltHang;
          '1': cfg.handle_long:=ltTrunc;
          '2': cfg.handle_long:=ltWrap;
{          else def long}
          end; { 'L' }

{    'O': cfg.outputfile:=ParamStr(w+1); }


    else
     begin;
     writelnptag(wcWarning,'unknown command-line paramater "'+str+'"');{str case}
     {inc(w);}

{     dog }
     if w>paramcount then
      break;

     end;
    end; { switch }
   end; { for w:= 1 to paramcount }
end;
{if debugmode=true then Writeln(debugstr,'on');}

checkbreak:=debugmode;

case command of
 cmHelp    : givehelp{$ifdef extrahelp}(helplevelRegular){$endif};
 cmTag     : begin;
             cfg.outputfile:=ParamStr(2);
             if cfg.cfgname='' then
              begin;
              writelnptag(wcDebug,'defaulting to use PTAG.CFG');
              cfg.cfgname:='PTAG.CFG';
              end;
             if exist(cfg.cfgname) then
             begin;
              if debugmode then
              writelnptag(wcDebug, 'using config file '+cfg.cfgname);
              readconfig(cfg.cfgname);
              TagDisplayWrite;
             end else
              WriteLnPTag(wcError,'No configuration file to process.');
             end;
 cmCompile : CompileCfg(1);
 cmUpdate  : Update(paramstr(2));

 else writelnptag(wcerror,nothing_Str);

{ else
  begin;
  textattr:=
  Writeln}
 end;

end; { InitCommandLine}



begin;
oldcolor:=textattr;
textattr:=9;
writeln(hdr1);
{$IFDEF BETA}
writelnptag(wcbeta,'for personal (person-to-person) distribution only');
{$ENDIF}

if (paramcount = 0) and (exist(cfgname)=true) then
 begin;
 {if debugmode then
  Writeln(debugstr,'default config file ',cfgname,' found');}
 ReadConfig(cfgname);
 TagDisplayWrite;
 halt(0);
end;

if (paramcount=0) and (exist(cfgname)=false) then
 begin;
 WritelnPtag(wcError,nothing_str);
 halt(0);
 end;

initcommandline;


{If cfg.cfgname = ''  then
 begin;
 ;
 halt(0);
 end;}

halt(0);

{.$IFNDEF __OS2__}
end.
{.$ENDIF}


