/* Tosser for net/echo mail */

#include "msgg.h"
#include "twindow.h"
#include "keys.h"
#include "headedit.h"


#define MAXKLUDGE 133


static ulong totalmsgs=0;
static word *anum;		   /* Pointer to area # msgs array */
static word pmnum;		   /* # messages in packet */
static struct _pkthdr pi;  /* The current incoming packet's header */
static struct _xmsg xmsg;  /* The current msg's header */
static char *text;         /* Pointer to current msg's text body */
static char *pathline;     /* Pointer to current msg's PATH line(s) */
static char *seenby;       /* Pointer to current msg's SEEN-BY line(s) */
static char *area;         /* Pointer to current msg's AREA: tag */
static char *kludge;       /* Pointer to first kludge line in msg */
static char *endptr;       /* End-of-msg pointer */
static char *arcext[]={"MO","TU","WE","TH","FR","SA","SU",NULL};
static char mailerless;

char no_strip=0;	/* Don't remove EID's & SEENBYs if > 0 */
char no_fillin=0;   /* Don't complete addresses from kludges if > 0 */


/* Function declarations */

void   pascal import_mail(void);
FILE * pascal open_pkt (word zone,word net,word dest,word d_point,char *domain,word attr,word m_attr);
void   pascal close_pkt (FILE *fp);
static void   pascal close_msg_files(void);
int    pascal write_pkt_msg (FILE *fp,struct _xmsg *amsg,char *text,char *area);
static int    pascal are_we_in_here (char *buf,word net,word node);
static int    pascal crack_pkt (char *pktname);
static int    pascal crack_arc (char *in, char *arcname);
static int    pascal import (void);
static int    pascal move_2_safety (char *pktname);
static int    pascal unknown_msg ();
static int    pascal get_msg (word buflen,char *buffer,FILE *fp);
static void   pascal report(void);





void pascal import_mail (void) {

	register int x;
	word areanum[4096];
	struct ffblk f;
	char s[133];
	char ss[133];

	printf("\x1b[2J");
	if(!*inbound) {
		printf("\07I don't know where your Inbound directory is!\n");
		return;
	}

	anum=areanum;	/* So it can be accessed globally */

    printf("\nImporting mail...");

	for(x=0;x<4096;x++) {
		anum[x]=0;
	}
	if(!netboard)netboard=1;

	sprintf(s,"%s*.PKT",inbound);
	if(!findfirst(s,&f,0)) {		/* Got naked packet(s) */
		do {
			sprintf(s,"%s%s",inbound,f.ff_name);
			crack_pkt(s);
		} while(!findnext(&f));
	}

	x=0;
	while(arcext[x]!=NULL) {
		sprintf(s,"%s*.%s?",inbound,arcext[x]);
		if(!findfirst(s,&f,0)) {		/* Got archived mail */
			do {
				strcpy(s,inbound);
				s[strlen(s)-1]=0;
				if(crack_arc(s,f.ff_name)) continue;
				else {
					sprintf(ss,"%s*.PKT",inbound);
					if(!findfirst(ss,&f,0)) {		/* Got naked packet(s) */
						unlink(s);
						do {
							sprintf(ss,"%s%s",inbound,f.ff_name);
							crack_pkt(ss);
						} while(!findnext(&f));
					}
				}

			} while(!findnext(&f));
		}
		x++;
	}

	close_msg_files();	/* All done; pack the bags and go home */

	report();
}



void pascal report (void) {

	register int x;

	printf("\n");
	if(!totalmsgs) {
		printf("No messages imported.\n");
		return;
	}
	for(x=0;x<maxareas;x++) {
		if(anum[x]) {
			printf("Imported %u msgs to area #%u %s.\n",anum[x],marea[x].number,marea[x].name);
		}
	}
	printf("\nTotal msgs imported: %lu\n",totalmsgs);
	if(domail!=2 && domail!=4 && domail!=6) get_char();
}



int pascal crack_arc (char *in,char *arcname) {

	char s[256];

	sprintf(s,"%s /c UNARC.BAT %s %s",getenv("COMSPEC"),in,arcname);
	do_spawn(s);
}



int pascal crack_pkt (char *pktname) {

    register word x;
	FILE *fp;
    long pos;
    long len;
	char *buffer;
	word buflen;
	int  temp;

	pmnum=0;
	fp=fopen(pktname,"rb");
	if(!fp) return -1;      /* Return Can't Open */
	fseek(fp,0L,SEEK_END);	/* Get packet size */
    len=ftell(fp);
	if(len<=(long)sizeof(struct _pkthdr)) {
		fclose(fp);
		unlink(pktname);
		printf("\nShort packet discarded.\n");
		return 0;			/* Ignore 'short' packet */
	}
	fseek(fp,0L,SEEK_SET);

	if((len-(long)sizeof(struct _pkthdr))<65533L) buflen=(word)((len-(long)sizeof(struct _pkthdr))+1L);
	else buflen=65534;		/* Set minimum buffer length */
	buffer=(char *)malloc(buflen+1);		/* Allocate text buffer */
	if(!buffer) {
		fclose(fp);
		return -2;		/* Return OOM */
	}

	fread(&pi,sizeof(struct _pkthdr),1,fp);	/* Get packet header */

    printf("\nPacket `%s' is from address %u:%u/%u.%u@%s\n",pktname,pi.orig_zone,pi.orig_net,pi.orig_node,pi.orig_point,pi.domain);
    if(!strcmp(pi.domain,"XBBS")) {
        printf("Mailerless point packet.\n");
        mailerless=1;
    }
    else mailerless=0;
    for(x=0;x<(word)noaddress;x++) {
		if((pi.dest_zone==0 || pi.dest_zone==address[x]->zone) && (pi.dest_net==address[x]->net) && (pi.dest_node==address[x]->node) && (pi.dest_point==0 || pi.dest_point==address[x]->point)) {
			curaddress.zone=address[x]->zone;
			curaddress.net=address[x]->net;
			curaddress.node=address[x]->node;
			curaddress.point=address[x]->point;
			strcpy(curaddress.domain,address[x]->domain);
			break;
		}
	}
	if((pi.dest_zone!=0 && pi.dest_zone!=curaddress.zone) || (pi.dest_net!=curaddress.net) || (pi.dest_node!=curaddress.node) || (pi.dest_point!=0 && pi.dest_point!=curaddress.point)) {
		printf("Packet isn't ours; addressed to %u:%u/%u.%u\n",pi.dest_zone,pi.dest_net,pi.dest_node,pi.dest_point);
		fclose(fp);
        if(buffer)free(buffer);
/*		return(forward_pkt(pktname));	*/
		move_2_safety(pktname);
		return 0;
	}

	while(!feof(fp)) {
		temp=get_msg(buflen,buffer,fp);
		if(temp==-1) {
			fclose(fp);
            if(buffer)free(buffer);
			move_2_safety(pktname);
			return -3;	/* Return 'minor' error */
		}
		if(temp<0) break;	/* End of packet */
		if(text==NULL || !*text) {
			printf("\nNULL message discarded.\r");
			continue;	/* NULL message */
		}
		if(!temp) {
            for(x=0;x<(word)noaddress;x++) {
				if(xmsg.dest_net==address[x]->net && xmsg.dest==address[x]->node) {
					curaddress.zone=address[x]->zone;
					curaddress.net=address[x]->net;
					curaddress.node=address[x]->node;
					curaddress.point=address[x]->point;
					strcpy(curaddress.domain,address[x]->domain);
					break;
				}
			}
			if(xmsg.dest_net==curaddress.net && xmsg.dest==curaddress.node) temp=import();
/*			else forward_msg(buffer);	*/
			if(temp) {
/*              unknown_msg();	*/
			}
		}
	}
    fclose(fp);         /* Close packet */
	unlink(pktname); 	/* Get rid of packet after unpacking */
    if(buffer)free(buffer);
	return 0;			/* Return success */
}


	static FILE *dataptr=NULL,*textptr=NULL;

void pascal close_msg_files (void) {

	if(dataptr) fclose(dataptr);
	if(textptr) fclose(textptr);
	dataptr=textptr=NULL;
}


int pascal import () {  /* Put msg in XBBS base */

	register int x;
	static word lastarea=0;
	static word lastmarea;
	word temp=0;
	char textname[133];
	char dataname[133];

	if(area==NULL) temp=netboard;
	else {
		for(x=0;x<maxareas;x++) {	/* Find the area tag */
			if(!stricmp(area,marea[x].name)) {
				temp=marea[x].number;
				break;
			}
		}
		lastmarea=x;
	}

	if(!temp) {
		printf("\nMsg in unknown area \"%s\" ignored.\n",area);
		return 1;		/* Unknown area */
	}

	if(temp!=lastarea) {
		if(dataptr)fclose(dataptr);
		if(textptr)fclose(textptr);
		lastarea=temp;
		sprintf(textname,"%sXTEXT.%03x",path,temp);
		sprintf(dataname,"%sXDATA.%03x",path,temp);
		dataptr=fopen(dataname,"a+b");
		textptr=fopen(textname,"a+b");
		if(!dataptr || !textptr) {
			if(dataptr)fclose(dataptr);
			if(textptr)fclose(textptr);
			dataptr=textptr=NULL;
			printf("\nCan't open message base file(s)\n");
			return 2;		/* Error opening message area */
		}
		printf("\n");
	}

	if(!area) printf("\x1b[KPkt area NETMAIL (#%u) -=> Msg area %u (#%u)\r",++pmnum,lastarea,++anum[lastmarea]);
	else printf("\x1b[KPkt area %s (#%u) -=> Msg area %u (#%u)\r",area,++pmnum,lastarea,++anum[lastmarea]);
	totalmsgs++;

	fseek(dataptr,0L,SEEK_END);
	fseek(textptr,0L,SEEK_END);

	xmsg.start=ftell(textptr);
	if((marea[lastmarea].attr & COMPRESS) && xmsg.length>packsize) {

		char *hold;
		unsigned int temp;

		temp=strlen(text);
		if(temp>65100) {
			text[65099]=0;
			temp=65100;
		}
		hold=(char *)malloc(temp+256);
		if(!hold) {
			printf("\nInsufficient memory for compression\n");
			fwrite(text,temp,1,textptr);
		}
		else {
			hold=pack_msg(hold);
			if(!hold) {
			   printf("\nCompression failed\n");
			   fwrite(text,temp,1,textptr);
			}
			else {
				msg.m_attr = xmsg.m_attr | MSGPACKED;
				fwrite(hold,xmsg.length,1,textptr);
			}
			if(hold)free(hold);
	   }
	}
	else fwrite(text,strlen(text),1,textptr);
	fwrite(&xmsg,sizeof(struct _xmsg),1,dataptr);
	fputc(0,textptr);
	return 0;
}



int pascal move_2_safety (char *pktname) {	/* Copy indecipherable packet to safe 'place' */

	char s[166];
	char newname[133];
	char *p;

	strcpy(newname,pktname);
	p=strrchr(newname,'.');
	if(p) {
		*p=0;
	}
	strcat(newname,".BKT");
	sprintf(s,"COPY %s %s > NUL",pktname,newname);
	printf("\n%s\n",s);
	system(s); 							/* Replace with inline code later */
	sprintf(s,"DEL %s > NUL",pktname);
	printf("%s\n",s);
	return (system(s));
}



int pascal unknown_msg () { /* Place unknown echomail msgs into UNKNOWN.PKT XST-style */




}



int pascal get_msg (word buflen,char *buffer,FILE *fp) {

	/* This could be sped up as explained to me by Wayne Michaels:
	   read only 8K on first pass.  If you don't find EOM in that,
	   read 8K more, and so on until you find EOM (or run out of
	   buffer).  Then process message. */

	register word x;
	char *p;
	long pos;
	word len;
	word *temp;

Again:
	if(feof(fp)) return -2;
	pos=ftell(fp);
	if(fread(buffer,1,buflen,fp)==0) return -2;
	buffer[buflen]=0;
	p=buffer;
	if(*p!='\02' || p[1]!='\0') {
		if(feof(fp) || (*p=='\0' && p[1]=='\0')) return -2;
		while(*p!='\02' && p<(buffer+buflen)) {
			p++;
			pos++;
		}
		fseek(fp,pos,SEEK_SET);
		goto Again;
	}
	p+=2;
	temp=(word *)p;
	xmsg.orig=*temp;
	p+=2;
	temp=(word *)p;
	xmsg.dest=*temp;
	p+=2;
	temp=(word *)p;
	xmsg.orig_net=*temp;
	p+=2;
	temp=(word *)p;
	xmsg.dest_net=*temp;
	p+=2;
	temp=(word *)p;
	xmsg.attr=*temp;
    if(!mailerless) {
        temp=(word *)p;
        xmsg.cost=*temp;
        p+=2;
    }
    else {
        xmsg.cost=0;
        p+=4;
    }
	strncpy(xmsg.date,p,20);
	xmsg.date[19]=0;
	while(*p)p++;	/* <--This goddamn kludge thanks to Opus & assoc utils */
	p++;
	strncpy(xmsg.to,p,36);
	xmsg.to[35]=0;
	while(*p)p++;
	p++;
#ifdef DEBUG
printf("\x1b[KTo: %s\n",xmsg.to);
#endif
	strncpy(xmsg.from,p,36);
	xmsg.from[35]=0;
	while(*p)p++;
	p++;
#ifdef DEBUG
printf("\x1b[KFrom: %s\n",xmsg.from);
#endif
	strncpy(xmsg.subj,p,64);
	xmsg.subj[63]=0;
	while(*p)p++;
	p++;
#ifdef DEBUG
printf("\x1b[KSubj: %s\n",xmsg.subj);
#endif
	text=p;
	while(*p)p++;
	p++;							/* Should be start of next msg */
	endptr=p;
	pos+=(long)(endptr-buffer);
	fseek(fp,pos,SEEK_SET);			/* Now positioned to start of next msg */
	len=strlen(text);
#ifdef DEBUG
printf("\x1b[KText: %s\n",text);
#endif

	p=text;
	while (*p) {	/* Strip linefeeds and soft cr's FAST */
		if(*p=='\x8d' || *p=='\n') {
			if(*p=='\n') {
				memmove(p,&p[1],len-((word)p-(word)text));
			}
			else {
				if(*(p-1)==' ' && p>text) {
					memmove(p,&p[1],len-((word)p-(word)text));
				}
				else *p=' ';
			}
		}
		p++;
	}

	if(!strnicmp(text,"AREA:",5)) {	/* Echo area tag */
		area=text;
		while(*text && *text!='\r') {
			text++;
		}
		if(*text) {
			*text=0;					/* area now = area tag line */
			text++;						/* text = true start of msg body if any */
		}
		while(*text=='\r' && *text) text++; /* Skip leading cr's in body */
        area+=5;
		lstrip(area);
		rstrip(area);					/* Points directly to tag */
	}
	else area=NULL;

#ifdef DEBUG
printf("\x1b[KArea: %s\n",area);
printf("\x1b[KText2: %s\n",text);
#endif

    if (area) {             /* Do ECHO specific BS */

		char *tempo=NULL;
		char *origin=NULL;

		pathline=NULL;
		seenby=NULL;
		kludge=NULL;
		tempo=text;		/* They oughta outlaw EID's */
		if(!no_strip) {
			while ((tempo=strstr(tempo,"\01EID:"))) memmove(tempo,strchr(&tempo[1],'\r'),strlen(strchr(&tempo[1],'\r'))+1);
			while(*text=='\r' && *text) text++; /* Skip leading cr's in body */
		}
		if(!strncmp(text," * Origin: ",11)) *text=0;	/* Nothin' but origin */
		origin=strstr(text,"\r * Origin:");		/* Find the origin line */
		if (origin) {		/* Ain't one; oh, well, screw it */
			while(tempo=strstr(&origin[1],"\r * Origin:")) origin=tempo; /* Find last */
            pathline=strstr(origin,"\r\01PATH:");   /* Find the PATH line */
			seenby=strstr(origin,"\rSEEN-BY:");	/* Find start of SEEN-BYs */
            if (!seenby) seenby=strstr(origin,"\r\01SEEN-BY:");
			if(pathline) {
/*              for(x=0;x<(word)noaddress;x++) {
					if(are_we_in_here(pathline,address[x]->net,address[x]->node)) return 1;
				}
*/			}
			else {
				if(!no_strip) {
					if (seenby) {
						*seenby=0;  /* Mercifully kill SEEN-BYs */
						seenby=NULL;
					}
				}
			}
            if ((seenby && pathline) && seenby<pathline) {
				if(!no_strip) {
					memmove (seenby,pathline,strlen(pathline)+1); /* Keep PATH */
					seenby=NULL;
				}
			}
		}
		if (text[strlen(text)-1]!='\r') strcat(text,"\r");	/* Assure trailing cr for appearance */
		xmsg.attr |= MSGORPHAN;		/* Orphan stripped msgs so they never go back out */
	}

	if(!no_fillin) {		/* Fill in header address info from kludges */

		char *tempo;
		char message[MAXKLUDGE];

		if ((p=strstr(text,"\01FMPT "))) {
			strncpy(message,p,MAXKLUDGE);
			message[MAXKLUDGE-1]=0;
			p=message;
			xmsg.o_point=(char)atoi(&p[5]);
		}
		if ((p=strstr(text,"\01INTL "))) {
			strncpy(message,p,MAXKLUDGE);
			message[MAXKLUDGE-1]=0;
			p=message;
			strtok(p," :");
			strtok(0," ");
			tempo=strtok(0,":");
			if(tempo)if ((word)atol(tempo)) xmsg.o_zone=(word)atol(tempo);
		}
		if ((p=strstr(text,"\01MSGID: "))) {

			char *ispoint;
            char *isnumsign;

			strncpy(message,p,MAXKLUDGE);
			message[MAXKLUDGE-1]=0;
			p=message;
            isnumsign=strchr(p,'#');
            ispoint=strchr(p,'.');
            if(isnumsign) {
                if(isnumsign<ispoint || !ispoint) {
                    p=strtok(p,"#");    /* Get past domain */
                    p=strtok(0,"\n");
                }
            }
            strtok(p," :");
			p=strtok(0,":");
			if(p)xmsg.o_zone=(word)atol(p);
			p=strtok(0,"/");
			xmsg.orig_net=(word)atol(p);
			if(ispoint) p=strtok(0,".");
			else p=strtok(0,"@ ");
			if(p)xmsg.orig=(word)atol(p);
			if(ispoint) {
				p=strtok(0,"@ ");
				if(p && (word)atol(p) && atol(p)<65536)
					xmsg.o_point=(word)atol(p);
			}
		}
		if ((p=strstr(text,"\01MSGTO: "))) {

			char *ispoint;
            char *isnumsign;
            char *isdomain;

			strncpy(message,p,MAXKLUDGE);
			message[MAXKLUDGE-1]=0;
			p=message;
            isnumsign=strchr(p,'#');
            ispoint=strchr(p,'.');
            isdomain=strchr(p,'@');
            if(isnumsign) {
                if(isnumsign<isdomain && isdomain) {
					p=strtok(p,"@");
                    strncpy(msg.to,p,36);
                    msg.to[35]=0;
                    p=strtok(0,"\n");
                }
                p=strtok(p,"#");
                p=strtok(0,"\n");
            }
            strtok(p," :");
			p=strtok(0,":");
			if(p)xmsg.d_zone=(word)atol(p);
			p=strtok(0,"/");
			xmsg.dest_net=(word)atol(p);
			if(ispoint) p=strtok(0,".");
			else p=strtok(0,"@ ");
			if(p)xmsg.dest=(word)atol(p);
			if(ispoint) {
				p=strtok(0,"@ ");
				if(p && (word)atol(p) && atol(p)<65536)
					xmsg.d_point=(word)atol(p);
			}
		}
	}

	p=&text[strlen(text)-1];
    while(*p=='\r' && *(p-1)=='\r' && p>text) {
		*p=0;
		p--;
	}

	xmsg.length=strlen(text);
	xmsg.m_attr = 0;
	if(area) xmsg.m_attr |= MSGECHO;     	/* Is echo */
	else xmsg.m_attr |= MSGNET;				/* Is net  */
	xmsg.attr = xmsg.attr & (~MSGLOCAL);	/* Isn't local! */
	return 0;
}



int pascal are_we_in_here (char *buf,word net,word node) {

	/* Check for net/node combination in SEEN-BY/PATH-type string.
	   This could probably stand some speed-up optimization */

	char s[133];
	register char *p;
	register char *pp;
	char *nomore;

	if(!buf) return 0;
	sprintf(s,"%u/%u",net,node);
	pp=buf;
Again:
	if(p=strstr(pp,s)) {
		if(!strchr(" \r",*(p-1)) || !strchr(" \r",*(p+strlen(s)))) {	/* Need whitespace before and after */
			pp=(p+strlen(s));
			goto Again;
		}
		return 1;						/* Full entry is in there */
	}
	sprintf(s,"%u/",net);
	pp=buf;
Again2:
	if(!(p=strstr(pp,s))) return 0;		/* Our net isn't there */
	if(!strchr(" \r",*(p-1)) || !strchr(" \r",*(p+strlen(s)))) {
		pp=(p+strlen(s));
		goto Again2;
	}
	p+=strlen(s);						/* Past the net and slash */
	nomore=strchr(p,'/');	    		/* Find next slash */
	sprintf(s,"%u",node);
Again3:
	if(!(p=strstr(p,s))) return 0;		/* Our node isn't there */
	if(p>=nomore) return 0;				/* Under some other net */
	if(!strchr(" \r",*(p-1)) || !strchr(" \r",*(p+strlen(s)))) {
		pp=(p+strlen(s));
		goto Again3;
	}
	return 1;							/* We're in there */
}
