	title	FREE.ASM
	page,132

;Report drive free space as an ERRORLEVEL (0 if true, 1 if false).
;See usage.
;(This was requested by SEMPER BBS SYSOP who wanted to insure there
;was sufficient free space on a drive before he copied some files.)
;
;v1.2	Signs bit me!  Sigh .. should've looked up long subtraction
;	instead of winging it.  Should be ok now.
;v1.1	ok, 255000 wasn't big enough.  Now he wants BIG values
;	like 3 megabytes.
;	Well, we can do that.  Now accepts up to 0FFFFFFFFH (42Mb),
;	an unsigned long.

;Given to the public domain
;David Kirschbaum
;Toad Hall
;
CR	EQU	0DH
LF	EQU	0AH
DEBUG	EQU	0		;make this 1 for Ascii display

CSEG	SEGMENT PARA 'CODE'
	ASSUME CS:CSEG


	org	100H

ToadFree	PROC	NEAR
	jmp	Over

thou	dw	1000			;constant for multiplying
drive	db	0			;current drive

usage$	db	'TOADFREE disk free space utility',CR,LF
	db	'Usage:  TOADFREE D n',CR,LF
	db	'Where D is a target drive',CR,LF
	db	'and n is a figure from 1 to 4,294,967,295',CR,LF
	db	'Returns ERRORLEVEL 0 if that much free space',CR,LF
	db	'     or ERRORLEVEL 1 if less.$'


Over:
	mov	si,80H			;PSP cmdline
	cld				;insure fwd
	lodsb				;snarf cmdline length byte
	xor	ah,ah			;clear msb
	mov	cx,ax			;into CX
	jcxz	Usage			;dummy

	mov	dx,('9' SHL 8) + '0'	;DL='0', DH='9'
	mov	ah,20H			;handy space/constant

Space1Lup:
	lodsb				;snarf next char
	cmp	al,ah	;' '		;space?
	ja	Parm1			;nope, hit first parm
	loop	Space1Lup		;gobble leading spaces
	jmp	short Usage		;dummy

;First char had better be a drive parm!

Parm1:
	cmp	al,'a'			;maybe lowercase?
	jb	Upper			;nope
	 sub	al,ah	;20H		;uppercase it
Upper:	cmp	al,'A'			;We'll accept A..L
	jb	Usage			;dummy
	cmp	al,'L'
	ja	Usage			;dummy
	sub	al,'A'-1		;deasciify it A = 1, B = 2
	mov	drive,al		;save for later

Parm2:	lodsb				;snarf next char
	cmp	al,dl			;below '0'?
	jb	Relup			;yep, discard (could be whitespace)
	cmp	al,dh			;above '9'?
	jbe	GotNr			;yep, first digit of our parm
Relup:	loop	Parm2			;gobble spaces
					;fall thru to ...

Usage:	mov	dx,offset usage$	;'Free:...'
	mov	ah,9			;display msg
	int	21H
	mov	ax,4CFFH		;ERRORLEVEL -1 for error
	int	21H			;terminate

;Got our first legal digit
GotNr:	dec	si			;back up from that last lodsb
	call	NAtoI			;SI -> first digit
					;returns long int in DX:AX
	push	ax			;save that request.lo
	push	dx			;and req.hi

	mov	dl,drive		;PSP's selected drive
	mov	ah,36h			;get disk free space
	int	21h			;AX = sectors per cluster
					;BX = available cluster count
					;CX = bytes per sector
					;DX = total clusters

	xor	dx,dx			;clear for the mul
	mul	bx			;sectors per cluster * free clusters
	mul	cx			; * bytes per sector
					;DX:AX has total free bytes

	pop	cx			;req.hi
	pop	bx			;req.lo

	mov	si,4C00H		;assume success, enough free
	sub	ax,bx			;free.lo - req.lo
	sbb	dx,cx			;free.hi - req.hi
	adc	si,0			;if insuff, 4C01H

IF	DEBUG
	mov	ax,si			;get the value
	add	al,'0'			;asciify
	mov	dl,al			;errorlevel
	mov	ah,2			;display output
	int	21H
ENDIF
	mov	ax,si			;get back the 4C0xH again
	int	21H			;terminate

ToadFree	ENDP


;from STDLIB.ZIP
; ATOUL-	Just like ATOL but this guy only does unsigned numbers.
; ATOUL- Converts the string pointed at by DS:SI to an unsigned long integer
;	value and returns this integer in the DX:AX registers.
;
;	Returns with the carry flag clear if no error, set if overflow.
;

NAtoI	proc	near
	xor	cx,cx
	xor	dx,dx

lp:	lodsb			;snarf digit
	cmp	al,','		;comma?
	jz	lp		;yep, skip it
	cmp	al,' '		;space?
	jz	lp		;yep, skip it
				;so much for error trapping
	xor	al, '0'		;deasciify
	cmp	al, 10
	ja	NotDigit	;not a number, done
	shl	cx, 1
	rcl	dx, 1
	jc	Error		;overflow
	mov	bx, cx
	mov	DI, dx
	shl	cx, 1
	rcl	dx, 1
	jc	Error		;overflow
	shl	cx, 1
	rcl	dx, 1
	jc	Error		;overflow
	add	cx, bx
	adc	dx, DI
	jc	Error		;overflow
	add	cl, al
	adc	ch, 0
	adc	dx, 0
	jc	Error		;overflow
	jmp	lp		;next digit, please

NotDigit:
	mov	ax,cx		;move long.lo into AX
	clc			;return CF clear for OK
Error:	ret			;jmp here if CF set for error

NAtoI	endp

CSEG	ENDS
	END	ToadFree
