program Ifnumber;

var
rule,strnumber1,strnumber2         : string;
number1,number2                    : real;
error                              : integer;

procedure help;
begin
   writeln;
   writeln ('Syntax:  Ifnumber.exe <number1> <predicate> <number2>');
   writeln ;
   writeln ('Predicate can be:');
   writeln ('equival, unequival, smallerthan, biggerthan,');
   writeln ('smallerequivalthan or biggerequivalthan');
   writeln ;
   writeln ('If the predicate is true.  Ifnumber.exe returns errorlevel 1.');
   writeln ('If the predicate is false. Ifnumber.exe returns errorlevel 0.');
   writeln ('If the syntax is wrong.    Ifnumber.exe returns errorlevel 255.');
   writeln;
   writeln ('Example: Ifnumber.exe 1 biggerequivalthan 0');
   writeln ('         Errorlevel result is 1.');
   halt (255);
end;

procedure unequival;
begin
   if number1 <> number2 then halt(1) else halt (0);
end;

procedure equival;
begin
   if number1 = number2 then halt(1) else halt (0);
end;

procedure biggerthan;
begin
   if number1 > number2 then halt(1) else halt (0);
end;

procedure smallerthan;
begin
   if number1 < number2 then halt(1) else halt (0);
end;

procedure biggerequivalthan;
begin
   if number1 >= number2 then halt(1) else halt (0);
end;

procedure smallerequivalthan;
begin
   if number1 <= number2 then halt(1) else halt (0);
end;
begin
   writeln;
   writeln ('Ifnumber Version 1.00 by Frank Dethlefsen');
   strnumber1 := paramstr (1);
   rule       := paramstr (2);
   strnumber2 := paramstr (3);
   if (strnumber1 = '') or (strnumber2 = '') or (rule ='') then help;
   val (strnumber1,number1,error);
   if error > 0 then help;
   val (strnumber2,number2,error);
   if error > 0 then help;
   if rule = 'unequival'          then unequival;
   if rule = 'biggerthan'         then biggerthan;
   if rule = 'smallerthan'        then smallerthan;
   if rule = 'biggerequivalthan'  then biggerequivalthan;
   if rule = 'smallerequivalthan' then smallerequivalthan;
   if rule = 'equival'            then equival;
   help;
end.