1 GOTO 240             'Line 1 MUST be present for this program to work.
5 ' LISTING 3
10 '
20 '>>>>>>>>>>>>>  This line will be deleted in the demo
30 '>>>>>>>>>>>>>  This line will be deleted in the demo
40 '>>>>>>>>>>>>>  This line will be deleted in the demo
50 '>>>>>>>>>>>>>  This line will be deleted in the demo
60 '>>>>>>>>>>>>>  This line will be deleted in the demo
70 '>>>>>>>>>>>>>  This line will be deleted in the demo
80 '>>>>>>>>>>>>>  This line will be deleted in the demo
90 '
100 '===========  Demo of keyboard buffer loader  =====================
110 '
120 'BUFFDEMO.BAS  Version 2.20, Copyright, 1985
130 '
140 'By:  Jim Pottkotter
150 '     3015 Kirby M'Liss Cove
160 '     Memphis, TN 38115
170 '
200 '==================  Purpose of BUFFDEMO.BAS  ====================
210 '
220 'Demostrates possible uses of BUFFLOAD.SUB
230 '
240 IF X = Y GOTO 300                   'Skip special branches
250 ON X GOTO 1060,1120,1180            'Branch for renumbering test
260 ON Y GOTO 1300,1360,1420            'Branch for delete test
270   BEEP
280   PRINT "Unexpected value for X."                  'Message
290   STOP
300 WHILE NOT HOUSEKEEPING.DONE%                       'First time only
310   WIDTH 80                                         '80 columns
320   SCREEN 0,1,0,0                                   'Select text mode
330   COLOR 10,0,0                                     'Bright green on black
340   CLS                                              'Clear the screen
350   HOUSEKEEPING.DONE% = -1                          'Set switch
360 WEND
370 WHILE INKEY.VALUE% > 0                             'After 1st time
380   PRINT
390   PRINT "Demonstration ";ANY.KEY$;" complete."     'Message
400   PRINT
410   PRINT "Press any key to continue."               'Message
420   ANY.KEY$ = ""                                    'Force 1 loop
430   WHILE ANY.KEY$ = ""                              'Wait for key press
440     ANY.KEY$ = INKEY$                              'Scan keyboard
450   WEND
460   INKEY.VALUE% = 0                                 'Reset switch
470 WEND
480 '-----  Menu routine
490 CLS                                                'Clear the screen
500 PRINT
510 PRINT "      Press a number key to select a demonstration."
520 PRINT
530 PRINT "      1 -- List some lines and return to the menu."
540 PRINT "      2 -- Stop the program and return to the menu."
550 PRINT "      3 -- End the program and return to the menu."
560 PRINT "      4 -- Renumber the program and return to the menu."
570 PRINT "      5 -- Delete some lines and return to the menu."
580 PRINT "      6 -- Exit to DOS and do a DIR *.BAS."
590 PRINT "      7 -- Exit to BASIC."
600 '
610 ANY.KEY$ = ""                                      'Force 1 loop
620 WHILE ANY.KEY$ = ""                                'Wait for key press
630   ANY.KEY$ = INKEY$                                'Scan keyboard
640   IF LEN(ANY.KEY$) > 1 THEN ANY.KEY$ = ""          '1 key only
650   IF ANY.KEY$ < "1" THEN ANY.KEY$ = ""             'Must be > 0
660   IF ANY.KEY$ > "7" THEN ANY.KEY$ = ""             'Must be < 8
670 WEND
680 '
690 BUFF.1$ = "beep:goto 1" + CHR$(13)                 'Load the string
700 GOSUB 5090                                         'Load the buffer
710 CLS                                                'Clear the screen
720 '
730 INKEY.VALUE% = VAL(ANY.KEY$)                       'Get value of inkey$
740 ON INKEY.VALUE% GOTO 810,870,930,990,1230,1500,1600 'Branch on menu option
750 BEEP
760 PRINT "Unexpected value for INKEY.VALUE%."         'Message
770 STOP
780 '
790 '-----  List some lines and return to the menu."
800 '
810 PRINT "Listing some lines."                        'Message
820 PRINT
830 LIST 1-140                                         'List some lines
840 '
850 '-----  Stop the program and return to the menu."
860 '
870 PRINT "Stoping the program."                       'Message
880 PRINT
890 STOP                                               'Exit to command level
900 '
910 '-----  End the program and return to the menu."
920 '
930 PRINT "Ending the program."                        'Message
940 PRINT
950 END                                                'Exit to command level
960 '
970 '-----  Renumber the program and return to the menu."
980 '
990 PRINT "I am going to list some of the program,"    'Message
1000 PRINT "and then renumber it and list again."       'Message
1010 PRINT
1020 FOR LOOP% = 1 TO 3000 : NEXT                       'Wait
1030 BUFF.1$ = "x=1:goto 1" + CHR$(13)                  'Continue this test
1040 GOSUB 5090                                         'Load the buffer
1050 LIST -140                                          'List the program
1060 PRINT
1070 PRINT "Renumbering program by 1's."                'Message
1080 FOR LOOP% = 1 TO 3000 : NEXT                       'Wait
1090 BUFF.1$ = "x=2:goto 1" + CHR$(13)                  'Continue this test
1100 GOSUB 5090                                         'Load the buffer
1110 RENUM 1,,1                                         'Renumber by 1's
1120 PRINT
1130 PRINT "Renumbering complete - wait for list."      'Message
1140 FOR LOOP% = 1 TO 3000 : NEXT                       'Wait
1150 BUFF.1$ = "x=3:goto 1" + CHR$(13)                  'Continue this test
1160 GOSUB 5090                                         'Load the buffer
1170 LIST -140                                          'List some lines
1180 X = 0                                              'Reset switch
1190 GOTO 1
1200 '
1210 '-----  Delete some lines and return to the menu
1220 '
1230 PRINT "I am going to list some of the program,"    'Message
1240 PRINT "and then delete some lines and list again." 'Message
1250 PRINT
1260 FOR LOOP% = 1 TO 3000 : NEXT                       'Wait
1270 BUFF.1$ = "y=1:goto 1" + CHR$(13)                  'Continue this test
1280 GOSUB 5090                                         'Load the buffer
1290 LIST -140                                          'List the program
1300 PRINT
1310 PRINT "Deleting some lines."                       'Message
1320 FOR LOOP% = 1 TO 3000 : NEXT                       'Wait
1330 BUFF.1$ = "y=2:goto 1" + CHR$(13)                  'Continue this test
1340 GOSUB 5090                                         'Load the buffer
1350 DELETE 20-80                                       'Delete some lines
1360 PRINT
1370 PRINT "Delete complete - wait for list."           'Message
1380 FOR LOOP% = 1 TO 3000 : NEXT                       'Wait
1390 BUFF.1$ = "y=3:goto 1" + CHR$(13)                  'Continue this test
1400 GOSUB 5090                                         'Load the buffer
1410 LIST -140                                          'List some lines
1420 Y = 0                                              'Reset switch
1430 INKEY.VALUE% = 5                                   'Lost during delete
1440 ANY.KEY$ = "5"                                     'Lost during delete
1450 HOUSEKEEPING.DONE% = -1                            'Lost during delete
1460 GOTO 1
1470 '
1480 '-----  Exit to DOS
1490 '
1500 CLS                                                'Clear the screen
1510 PRINT
1520 PRINT "You are in DOS"                             'Display a message
1530 PRINT
1540 BUFF.1$ = "DIR *.BAS" + CHR$(13)                   'Do a directory
1550 GOSUB 5090                                         'Load the buffer
1560 SYSTEM                                             'Exit to DOS
1570 '
1580 '-----  Exit this demo
1590 '
1600 CLS                                                'Clear the screen
1610 PRINT
1620 PRINT "You are in BASIC"                           'Display a message
1630 PRINT
1640 POKE 1052, PEEK(1050)                              'Clear keyboard buffer
1650 END                                                'Exit to BASIC
5000 'LISTING 2
5010 '
5020 'BUFFLOAD.SUB clears and optionally loads the keyboard buffer
5030 '
5040 '=====>  Load Keyboard Buffer
5050 '
5060 '----  If BUFF.1$ and BUFF.2$ both contain a string,
5070 '----  BUFF.1$ overrides BUFF.2$.
5080 '
5090 POKE 1050, PEEK(1052)                      'Clear the buffer
5100 DEF SEG = 0                                'Set segment to 0
5110 WHILE BUFF.1$ <> ""                        'Case 1 - normal codes
5120   POKE 1050, 30                            'Address of 1st byte in buffer
5130   BUFF.LEN% = LEN(LEFT$(BUFF.1$,15))       'Get truncated string size
5140   POKE 1052, 30 + 2 * BUFF.LEN%            'Addr of 1st byte after buffer
5150   FOR BUFF.LOOP% = 1 TO BUFF.LEN%          'Loop BUFF.LEN% times
5160     POKE 1052 + 2 * BUFF.LOOP%, ASC(MID$(BUFF.1$,BUFF.LOOP%,1))    'ASCII
5170   NEXT                                     'End loop
5180   BUFF.2$ = ""                             'Prevent case 2
5190   BUFF.1$ = ""                             'Set exit condition
5200 WEND                                       'End case 1
5210 '
5220 WHILE BUFF.2$ <> ""                        'Case 2 - extended codes
5230   POKE 1050, 30                            'Address of 1st byte in buffer
5240   BUFF.LEN% = LEN(LEFT$(BUFF.2$,30))       'Limit is 30 characters
5250   BUFF.LEN% = (BUFF.LEN% \ 2) * 2          'Force even # of bytes
5260   POKE 1052, 30 + BUFF.LEN%                'Addr of 1st byte after buffer
5270   FOR BUFF.LOOP% = 1 TO BUFF.LEN%          'Loop BUFF.LEN% times
5280     POKE 1053 + BUFF.LOOP%, ASC(MID$(BUFF.2$,BUFF.LOOP%,1))        'ASCII
5290   NEXT                                     'End loop
5300   BUFF.2$ = ""                             'Set exit condition
5310 WEND                                       'End case 2
5320 '
5330 RETURN
