/***************************************************************

	sfsx.h          General header file for
			Space Flight Simulator,
			Simulation Module

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

/***    Include Files */

#include "bw.h"         /* header for generic Bywater handlers */
#include "as.h"         /* header for astronomy routines */
#include "gr.h"         /* header for graphics routines */
#include "dr.h"         /* header for directory routines */
#include "ui.h"         /* header for user interface routines */
#include "sfs.h"        /* header for sfs specific information */

/***    Program-specific definitions */

#ifndef SFSX
#define SFSX
#endif

#define sfsx_   X       /* This will allow us to use longer names */

#define	EL_EPOCH	315532800	/* Epoch for calculating elapsed
					   time, = 1980/01/01 00:00:00 	*/
#define FT_POINTS       64              /* Points in forward track buffer */
#define GT_POINTS       512             /* Size of ground track buffer  */
#define PE_POINTS       64              /* Size of Perspective buffer   */
#define EM_TITLES       6               /* Titles in Escape Menu */

/***************************************************************

	language-specific definitions

	English is taken as a default, and if SFSXNAME
	has not been defined, the English definitions will be
	utilized. To translate into other languages, we suggest
	that the following section be copied, a language name
	defined as one, and then each of the definitions rendered
	into the language. Example:

	;#define        LATIN   1
	;
	;
	;#if    LATIN
	;#define        SFSXNAME        " Pars in Astronautica Simulanda "
	;......etc.
	;#endif

	SFSXNAME will then be defined, and the English language
	tags will not be called.

***************************************************************/

#ifndef SFSXNAME
#define SFSXNAME        " Simulation Module "
#define SFSX_TITLE      "SFS ver. %s, Orbital Simulation"
#define SFSX_PROG       "Program: "
#define SFSX_TIME       "Timing: "
#define SFSX_SYS        "System: "
#define ESCTITLE        " Escape Options "
#define EXITTITLE       " Exit to Main SFS Menu"
#define ABORTTITLE      " Leave SFS Completely"
#define ZOOMTITLE       " Set and Activate Zoom Window"
#define UPPERTITLE      " Set and Activate Upper Window"
#define LOWERTITLE      " Set and Activate Lower Window"
#define SYSTITLE        " Set System Parameters"
#define VISSIM          " Visual Simulation Display "
#define GTRACK          " Ground Track Display "
#define DPERSP          " Distant Perspective Display "
#define ERR_GRINIT      "Failed to intialize graphics system\n"
#define MEMERR_ESC      "Cannot allocate memory for ESCAPE Menu "
#define SFSX_PRERR      "Error in interpretation of program file <%s>"
#define SFSX_INIT       "Please Wait: Initializing"
#define SFSX_HELP       "Press ESC or Click Here for Menu"
#define CALCSD          "Calculating surface data points for orbit %d"
#define CALCGR          "Calculating grid data points for orbit %d"
#define CALCORB         "Calculating orb data points for orbit %d"
#define SFSX_WAIT       "Waiting for time lapse"
#define ERR_CHAIN       "Failed to open chain file.\n"
#define SFSX_MM         "Escape Menu:  Select a Menu Item"
#define SFSX_MET        "MET"
#define SFSX_DAYS       "day(s)"
#define ERR_PROMPT      "ERROR:  %s; Do you want to continue? "
#define ERRP_NO         "N - ABORT"
#define ERRP_YES        "Y - Continue"
#define ERR_MATH        "Mathematics error, %s"
#define SSP_TITLE       "Set System Parameters"
#define MEMERR_SSP      "Cannot allocate memory for System Parameters Menu "
#define SSP_TF          " Time Factor [%ld x real time]"
#define SSP_UI          " Screen Update Interval [%ld seconds]"
#define SSP_TPL         " Trig Precision Level [%d]"
#define SSP_EXIT        " Return to Program"
#endif

/***    Declaration of external data and routines */

extern  long sfsx_getmet();

extern struct spj_pt spd_start, spd_end;        /* surface data pointers */
extern struct spj_pt gr_start, gr_end;          /* grid data pointers */
extern struct spj_pt pd_start, pd_end;          /* point data pointers */
extern struct spj_pt or_start, or_end;          /* orb data pointers */

extern struct as_focus sfsx_focus;              /* orbital focus structure */
extern char sfsx_gridfile[ 32 ];                /* grid spd file */
extern long sfsx_epoch;                         /* Orbital epoch in seconds since begining */
extern int sfsx_display;        /* Screen:  0 = visual simulation in top   */
				/*          1 = distant perspective in top */
				/*          2 = zoom (full) visual         */

extern struct sfs_orbit *sfsx_orbits[ ORBITS ];
				/* Structures for orbital data */
extern  char    sfsx_tbuf[ 256 ];

extern	char    fdfile[ 45 ];
extern  int     cell_width, char_width, cell_height, char_height;
extern  int     al_hor, al_vert;
extern  long    sfsx_dp;
extern  long    or_aa, or_ap;

extern  int     gt_color;       /* Color for ground track plot          */

extern  char	pr_name[ 128 ];

extern struct   uiwindow *main_window;          /* structure for main window    */
extern struct   uiwindow *po_window;            /* structure for focus panel    */
extern struct   uiwindow *ti_window;            /* structure for relation window */
extern struct   uiwindow *sy_window;            /* structure for timing window  */
extern struct   uiwindow *cp_window;            /* structure for control panel box */
extern struct   uiwindow *fo_window;            /* structure for focus window   */
extern struct   uiwindow *z_window;             /* structure for zoom window   */
extern  struct  uiwindow *t_window;             /* top window */
extern  struct  uiwindow *b_window;             /* bottom window */

extern int      help_y1;                        /* line for help display      */
extern int      help_y2;                        /* top of help display        */
extern int      help_x1;                        /* column for help display    */
extern int      help_x2;                        /* max col for help display   */

