/****************************************************************

	as_vpt.c        Variable precision trigonometry routines
			for astronomy (as) subsystem

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "math.h"
#include "bw.h"
#include "as.h"

int 	vpt_level;

double 	sin_table[ 91 ];

vpt_init()
	{	
	int i;
	for ( i = 0; i < 91; i++ )
		{
		sin_table[ i ] = sin( (double) DEG_RAD * i );
		}
	}

double 
vpt_sin( i )
	double i;
	{
	int target, work;

	switch( vpt_level )
		{
		case 1:
			work = i;
			work = (work >= 0) ? work % 360 : 359 - (-work % 360);
			target = work % 90;
			if (target != (work % 180) )
				target = 90 - target;
			return (work < 180) ?
					sin_table[ target ] :
					-sin_table[ target ] ;
		default:
			return sin( DEG_RAD * i );
		}
	}

double
vpt_cos( i )
	double i;
	{
	int target, work;
	switch( vpt_level )
		{
		case 1:
			work = i;
			work = (work >= 0) ? work % 360 : 359 - (-work % 360);
			target = work % 90;
			if (target == (work % 180) )
				target = 90 - target;
			return (90 <= work && work < 270) ? 
					-sin_table[ target ] :
					sin_table[ target ] ;
		default: 
			return cos( DEG_RAD * i );
		}
	}

double
vpt_tan( i )
	double i;
	{
	double c;
	switch( vpt_level )
		{
		case 1:
			c = vpt_cos( i );
			if ( c == 0 )
				{
				/* really?  shouldn't it be +/-infinity */
				return 0;	/* or a signalled error? */
				}
			else
				{
				return vpt_sin( i ) / c ;
				}
		default: 
			return tan( DEG_RAD * i );
		}
	}


