/***************************************************************

	as.h		General header file
			for astronomy (as) subsystem

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

#define RAD_DEG         5.729577951e1   /* Convert radians to degrees   */
#define DEG_RAD         1.745329252e-2  /* Convert degrees to radians   */
#define PI              3.141592654     /* Value of PI                  */
#define UGC             (6.6631110e-23) /* Universal Gravitational Constant */
#define ELEPOCH         315532800       /* Epoch for calculating elapsed
					   time, = 1980/01/01 00:00:00    */

#define	SPJ_NEARSIDE	0	/* near side only of spj calculations */
#define	SPJ_FARSIDE	1	/* far side only of spj calculations */
#define SPJ_ALLSIDES	2	/* calculate (show) near and far sides */

/* Minimum and Maximum Values for Orbital Elements */

#define OR_RAD_MIN      0       /* radius cannot be < 0 km */
#define OR_SID_MIN      0       /* sidereal day cannot be < 0 seconds */
#define OR_MAS_MIN      0.0     /* mass cannot be < 0.0 grams */
#define OR_INC_MIN      -180.0  /* inclination cannot be < -180.0 degrees */
#define OR_INC_MAX      180.0   /* inclination cannot be > 180.0 degrees */
#define OR_LAN_MIN      -180.0  /* longitude of asc. node cannot be < -180.0 degrees */
#define OR_LAN_MAX      180.0   /* longitude of asc. node cannot be > 180.0 degrees */
#define OR_ARP_MIN      -180.0  /* argument of perigee cannot be < -180.0 degrees */
#define OR_ARP_MAX      180.0   /* argument of perigee cannot be > 180.0 degrees */
#define OR_PER_MIN      0.0     /* period cannot be < 0.0 seconds */
#define OR_ECC_MIN      0.0     /* eccentricity cannot be < 0.0 */
#define OR_ECC_MAX      1.0     /* eccentricity cannot be > 1.0 */

struct as_focus
   {
   double       radius;         /* radius of orbital focus in kilometers */
   double       sid_day;        /* sidereal period of orbital focus in seconds */
   double       mass;           /* mass of orbital focus in kilograms */
   char         *name;          /* pointer to name of orbital focus */
   char         *adjective;     /* pointer to adjective for orbital focus */
   char         *fdfile;        /* pointer to fd filename */
   };

struct as_orbit
   {
   struct   as_focus   *focus; /* orbital focus */
   double   apoapsis;          /* apoapsis of orbit in kilometers  */
   double   periapsis;         /* periapsis of orbit in kilometers */
   double   semimajor;         /* Semimajor axis in kilometers */
   double   semiminor;         /* Semiminor axis in kilometers */
   double   dist;              /* Focus to orbit distance in kilometers */
   double   inclination;       /* Inclination in degrees */
   double   eccentricity;      /* Eccentricity ( 0 < e <= 1 ) */
   double   arg_per;           /* Argument of the periapsis in degrees */
   double   lon_an;            /* Longitude of Ascending Node in degrees */
   double   lif;               /* Longitude increment factor */
   double   period;            /* Period of orbit in seconds */
   };

struct spj_pt {
   int    code;
   double latitude;
   double longitude;
   double radius;
   double x;
   double y;
   int    side;
   char   *name;
   struct spj_pt *next;
   };

extern double   spj_meridian();
extern double   spj_angrad();
extern double   spj_degfix();

extern  char *as_fgets();

extern  double  as_lfix();
extern	double	vpt_sin();
extern	double	vpt_cos();
extern	double	vpt_tan();
extern  int	vpt_level;
