comment	|

	This program demonstrates one way to read single-letter switches from
	the command line. The command line switches are received by the
	program from the program segment prefix (PSP) beginning at offset 80h.

	The program uses a single memory word (one bit per switch) to store
	information for 16 switches, assumed to be /A through /P. All switches
	are treated as toggles. The code commenting, wording of printing
	messages and some of the code itself have been changed in a number of
	places.

	Written for MASM 5.0 by Hardin Brothers for PCResource. The original
	appeared in the April 1988 issue of their magazine. Entire contents of
	the April 1988 issue (C) Copyright 1988 by
				IDG Communications/Peterborough, Inc.

	Hardin Brothers is a freelance programmer and technical writer. Write
	to him at 280 N. Campus Ave., Upland, CA  91786. Enclose a self-
	addressed, stamped envelope for a reply.

	|

LF	equ	0Ah	; linefeed char
CR	equ	0Dh	; carriage return char
STDOUT	equ	1	; standard output device

EXIT	macro	val
	mov	AH, 4Ch		; INT 21h service 4Ch: exit from program
				; also returns a value. replaces old INT 20h.
	mov	AL, val		; return value byte
	int	21h
	endm

	.MODEL	SMALL
	.STACK

	.DATA

swtch	dw	0		; can, of course, be initialized so some of
				; the switches default ON

error$		db	CR, LF, 'Unknown switch detected', CR, LF
lerror		equ	$-error$

rpt$		db	CR, LF, 'The current switch char is: '
swtchch		db	?	; storage space for the char
		db	CR, LF, CR, LF, 'The following switches are set: '
aswtch		db	'ABCDEFGHIJKLMNOP', CR, LF
lrpt		equ	$-rpt$

	.CODE

start:	mov	AX, @data
	mov	DS, AX		; initialize data seg register
	cld			; reset direction flag
	mov	AX, 3700h	; INT 21h service 37h: reserved for DOS,
				;   undocumented, request current switch char
	int	21h		; call DOS service
	mov	swtchch, DL	; save char
	mov	AL, DL		; copy to AL for searching
	mov	CL, ES:[80h]	; get line length from PSP
	sub	CH, CH		; CX is the command line length
	test	CX, CX		; anything on the cmdline ?
	jz	report		; skip to switch settings report if nothing
	mov	DI, 81h		; start of cmdline area
	mov	BX, swtch	; get word of bit toggles

inloop:	repne	scasb		; search for first cmdline switch
	jcxz	report		; skip to report if no more switches
	push	CX
	push	AX		; save byte count and switch char
	mov	AL, ES:[DI]	; get cmdline switch
	and	AL, 0DFh	; force uppercase
	sub	AL, '@'		; 'A' = '@'+ 1: put AL in range 1 to >= 16
	cmp	AL, 10h		; check out of range ( AL > 16 )
	ja	error		; skip to error if out
	mov	CL, AL		; save switch number
	sub	AX, AX		; just as fast as XOR AX, AX: set AX = 0
	stc			; set carry flag
	rcl	AX, CL		; rotate carry to switch bit position in AX
	xor	BX, AX		; toggle switch bit
	mov	swtch, BX	; save result
	pop	AX
	pop	CX		; restore switch char and byte count
	jmp	inloop		; continue searching

error:	lea	DX, error$	; addr DS:DX points to error message
	mov	CX, lerror	; get message byte count
	jmp	short	endit	; skip to endit

report:	lea	SI, aswtch	; addr DS:SI points to ASCII switch names
	clc			; clear carry flag
	mov	CL, 10h		; get number of switches

outlp:	rcr	BX, 1		; rotate one bit to carry
	jc	out_2		; skip to out_2 if set

	mov	byte ptr [SI], ' '	; replace switch name with blank

out_2:	inc	SI		; point to next name
	loop	outlp		; continue for all switches
	lea	DX, rpt$	; addr DS:DX points to report message
	mov	CX, lrpt	; get message byte count

endit:	mov	BX, STDOUT	; write to standard output device
	mov	AH, 40h		; INT 21h service 40h: write to file/device
	int	21h
	EXIT	0		; terminate program normally using macro

	end	start

