;    GRDB - debugger for dos with 32-bit extensions
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
;
; help.asm
;
; Function: Handle help and most of the status screens
;
;   Handles numbers
;   Handles segments
;   Handles trapping page faults
;   Handles command input
;
	;MASM MODE
	.model small
	.386

include  iversion.inc
include  eprints.inc 
include  emtrap.inc 
include  eenv.inc
include  eloader.inc
include  einput.inc
include edos.inc
include eoptions.inc
include eints.inc

        extrn cpumodel : byte, w_cmdset : proc, optfs: BYTE
        public PrintVersion
	PUBLIC  help

	.data
memx	dw	0	; used to filter non-program stuff in arena dump (?m)
none	db	"none",0
cputypes db	"386",0,"486",0,"Pentium",0
	db	"Pentium Pro",0,"786",0,"886",0,"986",0

	.code
;
PrintVersion PROC
	call	PrintFollowingMessage
        db      13,10,"Get Real Debugger Version "
        db      30h + verid/10,'.',30h + verid MOD 10,9
        db      "Copyright (c) 1997-2003 David Lindauer (LADSoft)",13,10
        db      0
        ret
PrintVersion ENDP
;
; help command entry point
;
Help	PROC
	call	WadeSpace
	jnz	help2
ifndef NOFS
        test    [optfs],255
        jz      nofsx
        mov     al,1
        call    w_cmdset
nofsx:
endif
        call    PrintVersion
	call	PrintFollowingMessage
	db	"a  [address] 			- assemble",13,10
	db	"b  [d][#] 			- Show breakpoint(s)",13,10
	db	"b  [d][-]#,addr[,r/w/x[,len]]	- set or clear a breakpoint",13,10
	db	"d  [start [,end]]		- dump memory",13,10
	db	"e  start [,list]	 	- examine memory",13,10
	db	"g  [=start] [,break]		- run from start (or pos) to break",13,10
	db	"h  val1 [+-*/] val2		- hex arithmetic",13,10
	db	"i[bwd]  port 			- read from port",13,10
	db	"o[bwd]  port,val		- write to port",13,10
        db      "p[r][count]                    - step over [out]",13,10
        db      "q[s]                           - quit [save options]",13,10
	db	"r  [reg[:val]]			- show/modify regs",13,10
        db      "rf [list of flag values]       - show/modify flags",13,10
        db      "rm [#,val]                     - show/modify mmx regs, high byte first",13,10
        db      "rn[s] [#, val]                 - show fp regs or status, or set value for reg",13,10
	db	"t  [count]			- step into",13,10
	db	"u  [start [,end]]		- unassemble",13,10
        db      "y  [pfa [,reg[,val]]]          - read/[write] PCI reg or show devices",13,10
	db	"y? bus, dev, func	        - get PFA from bus:dev:func",13,10
	db	"?				- this help",13,10
        db      "??                             - show extended commands"
	db	0
	clc
	ret	
help2:
	cmp	al,'?'
        jnz     gnu
	inc	si
	call	wadespace
	jnz	herr
ifndef NOFS
        test    [optfs],255
        jz      nofsx1
        mov     al,1
        call    w_cmdset
nofsx1:
endif
        call    PrintVersion
	call	PrintFollowingMessage
	db	13,10
	db	"c  start,end,start2		- compare memory",13,10
	db	"f  start,end [,val]		- fill memory",13,10
        db      "l[@] [-] [name[ command]]      - read from file",13,10
	db	"m  source,end,dest		- move memory",13,10
	db	"s  start,end [,list]		- search for a byte pattern",13,10
	db	"w  [@addr] [name] [,len]	- write to file",13,10
	db	"xr drive: addr,start [,len]	- read logical disk sector",13,10
	db	"xw drive: addr,start [,len]	- write logical disk sector",13,10
        db      "@[a] [logfile]                 - start/stop logging to a file [append]",13,10
        db      "?g[r]                          - gnu information",13,10    
	db	"?i				- view interrupt info",13,10
        db      "?m[x]                          - view arena tags",13,10
        db      "?o [+-option list]             - view/set options",13,10
	db	"?p				- view program status"
	db	0
	clc
	ret	
;
; program & processor info
;
gnu:
        cmp     al,'g'
        jnz     status
        inc     si
        call    wadespace
        jnz     gnuredistribute
ifndef NOFS
        test    [optfs],255
        jz      nofsx2
        mov     al,1
        call    w_cmdset
nofsx2:
endif
        call    PrintVersion
        call    PrintFollowingMessage ; warranty info
        db      13,10
        db      "    This program is distributed in the hope that it will be useful,",13,10
        db      "    but WITHOUT ANY WARRANTY; without even the implied warranty of",13,10
        db      "    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",13,10
        db      "    GNU General Public License for more details.",13,10
        db      0
        jmp     gnujoin
        
gnuredistribute:
ifndef NOFS
        test    [optfs],255
        jz      nofsx3
        mov     al,1
        call    w_cmdset
nofsx3:
endif
        call    PrintVersion
        call    PrintFollowingMessage ; copying info
        db      13,10
        db      "    This program is free software; you can redistribute it and/or modify",13,10
        db      "    it under the terms of the GNU General Public License as published by",13,10
        db      "    the Free Software Foundation; either version 2 of the License, or",13,10
        db      "    (at your option) any later version.",13,10 
        db      0
gnujoin:
        call    PrintFollowingMessage ; copying info
        db      13,10
        db      "    You should have received a copy of the GNU General Public License",13,10
        db      "    along with this program; if not, write to the Free Software",13,10
        db      "    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA",13,10
        db      13,10
        db      "    (See the file 'COPYING' for details)",13,10
        db      0
        clc
        ret
status:
	cmp	al,'p'
	jnz	hmem
	inc	si
	call	WadeSpace
	jnz	herr
ifndef NOFS
        test    [optfs],255
        jz      nofsx4
        mov     al,1
        call    w_cmdset
nofsx4:
endif
	PRINT_MESSAGE	<13,10,"Dos version: ">
	mov	al,byte ptr [dosver + 1]
	call	printbyte
	mov	dl,'.'
	call	putchar
	mov	al,byte ptr [dosver]
	call	printbyte
	PRINT_MESSAGE	<13,10,"CPU type: ">
	mov	di,offset cputypes ; calculate CPU type message pos
	movzx	cx,[cpumodel]		; program needs a 386+ :)
	sub	cx,3
	jcxz	gotcpu
	sub	al,al
cpulp:
	push	cx
	mov 	cx,-1
	repne	scasb
	pop	cx
	loop	cpulp

gotcpu:
	mov	bx,di 		; put out CPU type
	call	dgroupMessage     

	call	crlf

	mov	si,offset loadfile	; calc loadfile and command
	mov	di,offset loadcommand
	test	[filelen],-1
	jnz	okprog
	mov	si,offset none
	mov	di,si
okprog:
	test	byte ptr [di],-1
	jnz	okgotdi
	mov	di,offset none
okgotdi:
	test	byte ptr [si],-1
	jnz	okgotsi
	mov	si,offset none
okgotsi:
	PRINT_MESSAGE	<13,10,"Program:   ">
	mov	bx,si
	call	DgroupMessage
	PRINT_MESSAGE	<13,10,"Arguments: ">
	mov	bx,di
	call	DgroupMessage
	call	ExeStats			; put out EXE file stats
	call	crlf

	PRINT_MESSAGE	<13,10,"Psp at ">
	mov	ax,[userbasepsp]
	call	PrintWord
	mov	ax,[userpsp]
	cmp	ax,[userbasepsp]
	jz	normpsp
	push	ax              		; display if they have changed it
	call	printspace
	mov	dl,'('
	call	PutChar
	pop	ax
	call	PrintWord
	mov	dl,')'
	call	PutChar
	call	printspace
normpsp:
	PRINT_MESSAGE	<" with length ">
	mov	ax,[userbasepsp]
	dec	ax
	mov	fs,ax
	mov	ax,fs:[3]
	call	PrintWord
	PRINT_MESSAGE	<13,10,"Environment at ">
	mov	ax,[TgtPgmEnvSeg]
	call	PrintWord
	PRINT_MESSAGE	<" with ">
	mov	ax,[TgtPgmEnvSpaceUsed]
	call	Printword
	PRINT_MESSAGE	<" bytes used of ">
	mov	ax,[TgtPgmEnvLen]
	call	PrintWord
	
	clc
	ret		
;
; arena stats
;
hmem:	cmp	al,'m'
	jnz	hopt
ifndef NOFS
        test    [optfs],255
        jz      nofsx5
        mov     al,1
        call    w_cmdset
nofsx5:
endif
	mov	ax,[userbasepsp]		; calc PSP match
	mov	[memx],ax
	inc	si
	call	WadeSpace
	jz	memok
	cmp	al,'x'
	jnz	herr
	inc	si
	call	WadeSpace
	jnz	herr
	mov	[memx],0
memok:
	PRINT_MESSAGE	<13,10,13,10,"Top of memory: ">
	mov	fs,[userbasepsp]
	mov	ax,fs:[2]
	call	PrintWord
	call	crlf
	push	es 				; get root of chain      			
	mov	ah,52h	
	int	21h
	mov	bx,es:[bx-2]
	pop	es
meml:
	mov	fs,bx
	test	[memx],0ffffh			; check match and jump around if not
	jz	memd
	mov	ax,fs:[1]
	cmp	ax,[memx]
	jnz	memnd
memd:
	PRINT_MESSAGE	<13,10,"Address: ">
	mov	ax,fs
	call	PrintWord
	PRINT_MESSAGE	<"  Owner: ">
	test	word ptr fs:[1],-1
	jz	memu
	cmp	word ptr fs:[1],100h
	jc	memdos
	cmp	word ptr fs:[1],0f000h
	jnc	membios
	push	fs    				; not special
	mov	bx,fs:[1]			; display prog name owner
	dec	bx
	mov	fs,bx
	mov	si,8
	mov	cx,8
memns:
	lods	byte ptr fs:[si]
	or	al,al
	jz	memnsx
	mov	dl,al
	call	PutChar
	loop	memns
memnsx:
	pop	fs
	inc	cx
	push	cx
	mov	dl,'('
	call	PutChar
	mov	ax,fs:[1]
	call	PrintWord
	mov	dl,')'
	call	PutChar
	jmp	memsz
memdos:                                         ; dos special case
	push	12
	PRINT_MESSAGE	"DOS"
	jmp	memmsg
membios:					; bios special case
	push	11
	PRINT_MESSAGE	"BIOS"
	jmp	memmsg

memu:						; free special case
	push	11
	PRINT_MESSAGE	"FREE"
memmsg:
memsz:
	pop	cx
memspl:
	mov	dl,' '				; field pad
	push	cx
	call	PutChar
	pop	cx
	loop	memspl
	PRINT_MESSAGE	"  Size: "
	mov	ax,fs:[3]
	call	PrintWord
	mov	bx,fs
memnd:
	add	bx,fs:[3]			; index to next entry
	inc	bx
	cmp	byte ptr fs:[0],'Z'		; quit if this entry was EOM
	jnz	meml
	clc
	ret
;
; option status, jump to option routine
;
hopt:
	cmp	al,'o'
	jnz	hchain
	inc	si
	jmp	doopt
;
; chain status
;
hchain:
	cmp	al,'i'
	jnz	herr
	inc	si
	call	wadespace
	jnz	herr
ifndef NOFS
        test    [optfs],255
        jz      nofsx6
        mov     al,1
        call    w_cmdset
nofsx6:
endif
	inc	si
	call	crlf
	push	es
	mov	es,[intpage]
	sub	ax,ax
	mov	gs,ax
	mov	cx,256
	sub	si,si
	sub	di,di
chl:
	lods	dword ptr gs:[si]	; compare currint int page entry
	scasd
	jz	noch
	push	si
	push	di
	push	eax			; mismatch, print int #
	mov	al,cl
	neg	al
	push	ax
	call	printbyte
	pop	ax
	cmp	al,21h			; int 21h is modifiable
	jz	nostar
	or	al,al 			; so are all ints > 7FH
	js	nostar
	push	es
	push	ds
	pop	es
	mov	di,offset veclist
chlx:
	scasb
	jz	dostar
	inc	di
	inc	di
	cmp	byte ptr [di],0ffh
	jnz	chlx
	pop	es
nostar:
	call	printspace		; not overridden
	jmp	chj
dostar:
	pop	es
	mov	dl,'*'
	call	putchar
chj:                                    ; print int vect address
	mov	dl,':'
	call	putchar
	call	printspace
	pop	bx
	pop	ax
	call	printword
	mov	dl,':'
	call	putchar
	mov	ax,bx
	call	printword
	call	crlf
	pop	di
	pop	si
noch:
	loop	chl
	pop	es
	PRINT_MESSAGE	<13,10,"PIC 0 mask: ">
	mov	dx,21h
	mov	ah,byte ptr [orgpic+1]
	call	picval
	PRINT_MESSAGE	<13,10,"PIC 1 mask: ">
	mov	dx,0a1h
	mov	ah,byte ptr [orgpic]
	call	picval
	clc
	ret
picval:
	push	ax
	in	al,dx
	push	dx
	call	printbyte
	call	printspace
	mov	dl,'(' 
	call	putchar
	pop	dx
	pop	ax
	push	dx
	mov	al,ah
	call	printbyte
	mov	dl,',' 
	call	putchar
	pop	dx
	dec	dx
	mov	al,0bh
	out	dx,al
	in	al,dx
	call	printbyte
	mov	dl,')' 
	call	putchar
	ret
herr:
	stc
	ret
Help	ENDP
END