;    GRDB - debugger for dos with 32-bit extensions
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
;
; Dump.asm
;
; Function: Handle the Dump command
;
	
	;MASM MODE
	.model small
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 
include  eoptions.inc
include  iwindow.inc

DUMPLEN = 80h
        PUBLIC  dump, redump
	PUBLIC  index,indexseg
        extrn w_setwind : PROC, optfs : BYTE
        extrn wnd_dump : windstr
	.data
index	dd	0		; Default for next dump
indexseg dw	0		;
charcount db    16
dcr     db      13
;Debug reads each memory paragraph twice, once for the hex values and a
;second time for the ASCII values. This screws up at least two types of
;memory: memory-mapped IO when reads change the state of the device, and
;and FIFO devices with internal counters. So we read each location only once
;into this buffer, and then read the buffer to create the ASCII.

linedata db	16 DUP (?)	;holds line so we read it only once

	.code
;
; Dump one line
;
dumpline	PROC
	push	esi
	push	dx
	push	ebx        		; EBX MUST be on second of stack
	push	ecx			; ECX MUST be on top of stack
	sub	ax,ax
	mov	al,bl  		; AL = lower byte of address
        mov     ah,[charcount]
        dec     ah
        and     al,ah           ; AL = lower nibble
        movzx   ecx,[charcount] ; Total bytes to dump
	jz	short doline	; Go do hexdump if start of line = 0
	neg	al		; Else calculate number of bytes in line
        add     al,[charcount]  ;
        movzx   Ecx,al          ; To ECX

doline:
	sub	[esp],ecx	; Decrement count which is on stack
	add	[esp+4],ecx	; Increment address which is on stack
        mov     al,[charcount]  ; Get count of amount to space over
	sub	al,cl		;
	jz	short puthex	; Don't space over any, just put out hex
        sub     ah,ah
	push	cx		; Else ecx = spacecount * 3
	mov	cx,ax		;
	add	cx,cx		;
	add	cx,ax		;
blanklp1:
	call	PrintSpace      ; Dump spaces
	loop	blanklp1	;
	pop	cx

puthex:
	push	cx
	mov	di,offset linedata	; Now get the bytes to our buffer
	movzx	edi,di
	push	ds
	push	fs 			; fs:si was source
	pop	ds
	movzx	ecx,cx
	db	67h		; addrsize
	rep	movsb
	pop	ds
	pop	cx
	mov	si,offset linedata	
	push	cx		;
hexlp:
        test    cx,3
        jnz     hsp
        cmp     cl,[charcount]
        jae     hsp
        mov     dl,'-'
        call    putchar
        jmp     hjn
hsp:
	call	PrintSpace	; Print a space
hjn:
	lodsb
	call	PrintByte	; Print byte in hex
	loop	hexlp		; Loop till done
	pop	cx		;

	call	printSpace	; Print two spaces to seperate ASCII dump
	call	PrintSpace	;

	mov	si,offset linedata	
	sub	ax,ax		; Calculate amoun to space over
        mov     al,[charcount]           ;
	sub	al,cl		;
	jz	short putascii	; None to space over, put ascii
	push	cx		; ECX = space value
	mov	cx,ax
blanklp2:
	call	PrintSpace	; Space over
	loop	blanklp2	;
	pop	cx		;
	mov	si,offset linedata	

putascii:
	mov	dl,[si]		; Get char
	inc	si		; Increment buffer
	call	PureChar
	loop	putascii
	pop	ecx		; Get count from stack
	pop	ebx		; Get address from stack
	pop	dx
	pop	esi
	ret
dumpline	ENDP	
;
; Main DUMP routine
;
redump  PROC
        mov     si,offset dcr
redump  ENDP
dump	PROC	
	mov	ecx,DUMPLEN	; Default amount to dump
        mov     [charcount],16
ifndef NOFS
        test    [optfs],255
        jz      ndump
        mov     bx,offset wnd_dump
        call    w_setwind
        push    ax
        mov     [charcount],8
        mov     ecx, 6 * 8
        
ndump:
endif
	call	WadeSpace	; Wade to end of spaces
	jz	short atindex	;
	call	ReadAddress	; Else read start address
	jc	dudone		; Quit on error
	call	WadeSpace	; Wade through spaces
	jz	short dodump	;
	call	ReadNumber	; Else read end offset
        jc      dudone    ;
	sub	eax,ebx		; Calculate length of dump
	mov	ecx,eax		;
	jmp	short dodump	; Go do dump
atIndex:
	mov	ebx,[index]	; Assume we want to dump from last index
	mov	dx,[indexseg]	;
dodump:
ifndef NOFS
        mov     [index],ebx
        mov     [indexseg],dx
endif                
	call	defDS		; get DS
	mov	fs,dx
	test	[optdwordcommand],-1
        jnz     dumpj
	movzx	ebx,bx
	mov	eax,10000h
	sub	eax,ebx
	cmp	eax,ecx
        jnc     dumpj
	mov	ecx,eax
dumpj:
        movzx   eax,[charcount]
        dec     al
        test    bl,al
        jz      dumplp
        inc     al
        sub     ecx,eax
dumplp:
	call	scankey
	jnz	dusetadr
	push	ebx		;
	call	crlf
	pop	ebx		;
	mov	ax,dx		; Print the selector
	call	PrintWord	;
	push	dx		;
	mov	dl,':'		; Print a ':'
	call	PutChar
	pop	dx		;
	mov	esi,ebx
        movzx   eax,[charcount]
        neg     eax
        and     eax,ebx
	test	[optdwordcommand],0ffh
	jz	adrword
	call	PrintdWord	; Print address
	jmp	adrcmb
adrword:
	call	PrintWord
adrcmb:
	call	dumpline	; Dump a line
	or	ecx,ecx		; Continue while count > 0
	jg	dumplp
dusetadr:		;
ifndef NOFS
        test    [optfs],255
        jnz     dudone
endif
	mov	[index],ebx	; Save new index value
	mov	[indexseg],dx	;
	clc			; No errors
dudone:
ifndef NOFS
        test    [optfs],255
        jz      dux
        pop     bx
        call    w_setwind
dux:
endif
	ret
dump	ENDP	
END