;---------------
; wphd.asm - Write protect your hard drive.
; disassembled by James Vahn from an original program by 'JKW'

cseg segment
assume cs:cseg,ds:cseg
org 100h              ;COM format.

Begin:
    JMP     Init

Old_Vec dd 0          ;Storage for old vector.

New_ISR:
     CMP     DL,03h   ;Test for floppy.
     JBE     SkipIt
     CMP     AH,03h
     JZ      Write
     CMP     AH,0Bh
     JZ      Write
     CMP     AH,05h
     JZ      Write
     CMP     AH,06h
     JZ      Write
     CMP     AH,07h
     JNZ     SkipIt

Write:
     MOV     AX,0300h ;Return code for write protected disk.
     STC              ;Set carry flag to indicate error.
     RETF    0002h    ;Do not call INT 13h.
                              
SkipIt:
     JMP     cs:[Old_Vec]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Init:
     MOV     AX,3513h
     INT     21h

;Are we installed? Compare code at int 13 to cs:0106 to see.
     MOV     DI,BX
     MOV     DX,BX
     MOV     SI,offset New_ISR
     MOV     CX,0008h
     REPZ CMPSB
     JE      WPoff

;Are we disabled?  If so, enable.
     MOV     DI,BX
     MOV     SI,offset SkipIt
     MOV     CX,0005h
     REPZ CMPSB
     JNE     GoTSR
                         
;Code to enable write protection.
;
WPon:
     SUB     DX,(SkipIt - New_ISR)
     PUSH    DS
     PUSH    ES       ;Point ISR to New_ISR.
     POP     DS
     MOV     AX,2513h
     INT     21h

     POP     DS
     MOV     DX,offset msg1
     MOV     AH,09h
     INT     21h

     MOV     AX,4C00h
     INT     21h

;Code to disable write protection.
;
WPoff:
     ADD     DX,(SkipIt - New_ISR)
     PUSH    DS
     PUSH    ES
     POP     DS       ;Point ISR to JMP Old_Vec
     MOV     AX,2513h
     INT     21h

     POP     DS
     MOV     DX,offset msg2
     MOV     AH,09h
     INT     21h

     MOV     AX,4C00h
     INT     21h

GoTSR:
     MOV     DX,offset msg1
     MOV     AH,09h
     INT     21h

     mov     dx,offset msg3     ;v1.1  Show the 'Note'
     mov     ah,09h
     int     21h

     MOV     word ptr [Old_Vec],bx     ;save old vector
     MOV     word ptr [Old_Vec+2],es
     MOV     DX,offset New_ISR
     MOV     AX,2513h
     INT     21h

     MOV     DX,offset Init       ;Go TSR
     MOV     CL,04h
     SHR     DX,CL
     INC     DX
     MOV     AH,31h
     INT     21h

msg1 db 'Your hard drive is now Write & Format protected.',13,10
     db 'Run WPHD again to turn it OFF.',13,10,36

msg2 db 'WPHD is now OFF (no hard disk protection).',13,10
     db 'Run it again to turn it ON.',13,10,36

msg3 db 13,10,'Note: WPHD will not work if you install another prog',13,10
     db 'that grabs INT 13 after you install WPHD. 10/19/85  JKW',13,10,36

cseg ends
end Begin
