;"Raw" Keyboard handling functions
;
; When in "raw" mode you can detect multiple KEY PRESS/RELEASE
;
extrn _KeybInst:dword
        ; installs RAW keyboard handler and sets Keyboard RAW INPUT mode
        ; so multiple keys press/release can be detected scanning
        ; the keyboard tables returned by _WaitKey and _ScanKeyb

extrn _KeybAsciiMode:dword
        ; call this to set the keyboard handling routines back to
        ; ms-dos "tty like" input mode
        
extrn _ReadAscii:dword ; out: al == ascii char read
        ; Waits and reads a single ASCII character
        ; polling the keyboard like in "standard" consolle mode
        ; BE CAREFUL, "extended" codes are automatically discarded!!!!
        ; THIS ROUTINES EXPECTS THE KEYBOARD IN "ASCII MODE"

extrn _KeybRawMode:dword
        ; call this to enable "raw" mode
        ; after "ascii" mode input

        
extrn _WaitKey:dword  ; out: eax= pointer to keyboard table
        ; waits until a key is pressed/release
        ; and then returns a POINTER to the current keyboard table
        ; n.b. keyboard must be in "raw" mode
       
        ; the keyboard table is a table of 128 bytes, where the n-th byte
        ; contains the status of the n-th keyboard key
        ; bit 0 = 1 == key IS pressed
        ;         0 == key IS NOT pressed
        ; bit 1 = 1 == key HAS BEEN pressed since last time you reset
        ;              this bit
        ; bit 2..7 = always set to zero.
        ; An irq handler sets/resets bit0 for every key pressed/released
        ; but ONLY set bit 1 if a key has been pressed
        ; (you must reset bit1 on your own).
        ; thus....
        ;   0 == not pressed
        ;   3 == currently pressed
        ;   2 == has been pressed AT LEAST one time, currently is released


KPRESS   = 3
KPRESSED = 2      
        ;   I don't provide routines or macros to read the keyboard table
        ;   but i provide keyboard scancodes for a US keyboards.
        ;   In some countries some alphabetic keys gets placed differently
        ;   but you can trust on the position of cursor,keypad & fn-keys 
        ;   and on the various ESC,ALT,CTRL,SHIFT,BACKSPACE & RETURN keys
        ;   plus "the first row" on the alphanumeric portion
        ;   (that is: the 1,2,...9,0 keys above the alphabetic keys)
        ;   
        ;   HOW TO "READ" A KEY: 
        ;   if for example you want to read status of the ESC key
        ;   and the EDI register contains the offset of _RKB...
        ;
        ;   instruction:                     IF ZERO FLAG is SET after
        ;                                    executing the istruction THEN ...
        ;
        ;   test edi,[edi + _ESC],KPRESSED   This key has been pressed
        ;                                    and maybe is still pressed
        ;                                  
        ;   cmp  edi,[edi + _ESC],KPRESSED   This key has been pressed
        ;                                    AND NOW is NOT pressed
        ;                                    (key pressed, then released)
        ;
        ;   cmp  edi,[edi + _ESC],KPRESS    This key is CURRENTLY pressed

extrn _NotAKey:dword
        ; this dword contains a pointer to the current "key not known"
        ; string
        ; if you perform a "raw" read and check the strings pointed by
        ; the _KeyNames table of pointers, every pointer to the same string
        ; pointed by [_NotAKey] is an unknown key.
        ; You should avoid to use unknown keys because they could be
        ; "new" keys or "metakeys" produced by spurious key presses
        ; (see the key read routine ksel contained into 386menu.asm)

extrn _KeyNames:dword
        ; _KeyNames IS a pointer TO an array of 128 pointers TO strings
        ; describing the keyboard keys
        ;  i.e. mov ebx,_KeyNames
        ;       mov ecx,key_index
        ;       mov eax,[ebx+ecx*4]
        ;       ; now eax points to a string describing
        ;       ; the key with index ecx
        ;

extrn _ScanKeyb:dword ; out: eax= pointer to keyboard table
        ; executes a keyboard scan and updates the keyboard table
        ; returning a pointer to the CURRENT status of the keyboard keys
        ; n.b. keuboard must be in "raw" mode

; N.B. YOU CAN modify the values contained into the table returned by
;      _WaitKey and _ScanKeyb
;      (one of the most common things is clearing the HAS_BEEN_PRESSED bit
;       of a key entry to detect successive presses/releases)
;      But every time you call _WaitKey and _ScanKeyb you must use the
;      new pointer returned (in the current implementation it does not change
;      but it may change in future)( this is a needed feature to support
;      non-pc keyboards or different keyboard-like input devices)
       
; RAW KEYBOARD (_RKB) INDEXES of keys that are always expected to be the same
; on every keyboard

_ESC = 1
_1 = 2
_2 = 3
_3 = 4
_4 = 5
_5 = 6
_6 = 7
_7 = 8
_8 = 9
_9 = 0Ah
_0 = 0Bh

_F1  = 3Bh
_F2  = 3Ch
_F3  = 3Dh
_F4  = 3Eh
_F5  = 3Fh
_F6  = 40h
_F7  = 41h
_F8  = 42h
_F9  = 43h
_F10 = 44h
_F11 = 57h
_F12 = 58h

_ALT       = 38h
_CTRL      = 1Dh
_LSHIFT    = 2Ah
_RSHIFT    = 36h
_CAPSLOCK  = 3Ah
_TAB       = 0Fh
_BACKSPACE = 0Eh
_ENTER     = 1Ch

_HOME   = 47h
_UP     = 48h
_PGUP   = 49h
_LEFT   = 4Bh

; this is "5" on the keypad
_CENTER = 4Ch

_RIGHT  = 4Dh
_END    = 4Fh
_DOWN   = 50h
_PGDN   = 51h

_INS    = 52h
_DEL    = 53h

_KMINUS = 4Ah
_KPLUS  = 4Eh

_SPACEBAR = 39h


