
/***********************************************************
 *        Name: Alden Dima
 *      E*mail: dimaaa@seas.gwu.edu
 *      School: The George Washington University
 *              School of Engineering and Applied Science
 *              Washington, D.C.
 *       Class: CSci 298 - Independent Study
 *     Project: Ada Curses Binding and Textual User Interface
 *        File: macros.c
 *        Date: 5/31/96
 * Description: Expands some of the curses functions defined
 *              or renamed by C preprocessor macros so that 
 *              Ada programs can bind to so them. Part of the
 *              revised Ada-Curses binding.
 **********************************************************/

#include <curses.h>

/************************************************************
 *
 * Most of these functions are not curses pseudofunctions,
 * but the 'wrapper' functions should ensure that they are
 * always available, just in case.
 *
 ************************************************************/

int CB_beep(void)
   {
   return beep();
   }

int CB_curs_set(int set)
   {
   return curs_set(set);
   }

int CB_delwin(WINDOW* w)
   {
   return delwin(w);
   }

int CB_endwin(void)
   {
   return endwin();
   }

WINDOW* CB_initscr(void)
   {
   return initscr();
   }

int CB_init_pair(short p1, short p2, short p3)
   {
   return init_pair(p1, p2, p3);
   }

int CB_mvprintw(int y, int x, char* s,...)
   {
   return mvprintw(y, x, s);
   }

WINDOW* CB_newwin(int lines, int cols, int y, int x)
   {
   return newwin(lines, cols, y, x);
   }

int CB_start_color(void)
   {
   return start_color();
   }

WINDOW* CB_subwin(WINDOW* w, int lines, int cols, int y, int x)
   {
   return subwin(w, lines, cols, y, x);
   }

int CB_touchwin(WINDOW* w)
   {
   return touchwin(w);
   }

int CB_waddstr(WINDOW* w, char* s)
   {
   return waddstr(w, s);
   }

int CB_wattrset(WINDOW* w, attr_t a)
   {
   return wattrset(w, a);
   }

int CB_wbkgd(WINDOW* w, chtype ch)
   {
   return wbkgd(w, ch);
   }

void CB_wbkgdset(WINDOW* w, chtype ch)
   {
   wbkgdset(w, ch);
   }

int CB_werase(WINDOW* w)
   {
   return werase(w);
   }

int CB_wmove(WINDOW* w, int y, int x)
   {
   return wmove(w, y, x);
   }

int CB_mvwprintw(WINDOW* w, int y, int x, char* s,...)
   {
   return mvwprintw(w, y, x, s);
   }

int CB_wprintw(WINDOW* w, char* s,...)
   {
   return wprintw(w, s);
   }

int CB_wrefresh(WINDOW* w)
   {
   return wrefresh(w);
   }

/************************************************************
 *
 * Most of the following functions are curses pseudofunctions, 
 * the 'wrapper' functions make then available. 
 *
 ************************************************************/

int CB_addch(chtype ch)
   {
   return addch(ch);
   }

int CB_addstr(char *s)
   {
   return addstr(s);
   }

int CB_attrset(attr_t a)
   {
   return attrset(a);
   }

int CB_bkgd(chtype ch)
   {
   return bkgd(ch);
   }

void CB_bkgdset(chtype ch)
   {
   bkgdset(ch);
   }

int CB_border(chtype ls, chtype rs, chtype ts, chtype bs, chtype tl, chtype tr, chtype bl, chtype br)
   {
   return border(ls, rs, ts, bs, tl, tr, bl, br);
   }

int CB_box(WINDOW *w, chtype v, chtype h)
   {
   return box(w, v, h);
   }

void CB_cbreak(void)
   {
   cbreak();
   }

int CB_clear(void)
   {
   return clear();
   }

int CB_clrtobot(void)
   {
   return clrtobot();
   }

int CB_clrtoeol(void)
   {
   return clrtoeol();
   }

/* warning - this pseudofunction doesn't appear in PDCurses 2.3 */
chtype CB_color_pair(chtype n)
   {
   return ((chtype)(n) << 24);
   }

void CB_crmode(void)
   {
   crmode();
   }

int CB_delch(void)
   {
   return delch();
   }

int CB_deleteln(void)
   {
   return deleteln();
   }

void CB_echo(void)
   {
   echo();
   }

int CB_echochar(chtype ch)
   {
   return echochar(ch);
   }

int CB_erase(void)
   {
   return erase();
   }

int CB_getbegx(WINDOW *w)
   {
   return getbegx(w); 
   }

void CB_getbegyx(WINDOW *w, int *y, int *x)
   /* faking out mode parameters */
   {
   getbegyx(w, *y, *x);
   }

int CB_getbegy(WINDOW *w)
   {
   return getbegy(w);
   }

int CB_getch(void)
   {
   return getch();
   }

int CB_getmaxx(WINDOW *w)
   {
   return getmaxx(w);
   }

int CB_getmaxy(WINDOW *w)
   {
   return getmaxy(w);
   }

void CB_getmaxyx(WINDOW *w, int *y, int *x)
   /* faking out mode parameters */
   {
   getmaxyx(w, *y, *x);
   }

int CB_getparx(WINDOW *w)
   {
   return getparx(w);
   }

int CB_getpary(WINDOW *w)
   {
   return getpary(w);
   }

void CB_getparyx(WINDOW *w, int *y, int *x)
   /* faking out mode parameters */
   {
   getparyx(w, *y, *x);
   }

int CB_getstr(char* str)
   {
   return getstr(str);
   }

void CB_getyx(WINDOW *w, int *y, int *x)
   /* faking out mode parameters */
   {
   getyx(w, *y, *x);
   }

void CB_inch(void)
   {
   inch();
   }

int CB_inchstr(chtype *ch)
   {
   return inchstr(ch);
   }

int CB_insch(chtype ch)
   {
   return insch(ch);
   }

int CB_insertln(void)
   {
   return insertln();
   }

void CB_keypad(WINDOW *w, bool flag)
   {
   keypad(w, flag);
   }

void CB_leaveok(WINDOW *w, bool flag)
   {
   leaveok(w, flag);
   }

int CB_move(int y, int x)
   {
   return move(y, x);
   }

int CB_mvaddch(int y, int x, chtype ch)
   {
   return mvaddch(y, x, ch);
   }

int CB_mvaddstr(int y, int x, char *s)
   {
   return mvaddstr(y, x, s);
   }

int CB_mvdelch(int y, int x)
   {
   return mvdelch(y, x);
   }

int CB_mvgetch(int y, int x)
   {
   return mvgetch(y, x);
   }

int CB_mvgetstr(int y, int x, char* str)
   {
   return mvgetstr(y, x, str);
   }

int CB_mvinch(int y, int x)
   {
   return mvinch(y, x);
   }

int CB_mvinsch(int y, int x, chtype ch)
   {
   return mvinsch(y, x, ch);
   }

int CB_mvwaddch(WINDOW *w, int y, int x, chtype ch)
   {
   return mvwaddch(w, y, x, ch);
   }

int CB_mvwaddstr(WINDOW *w, int y, int x, char* str)
   {
   return mvwaddstr(w, y, x, str);
   }

int CB_mvwdelch(WINDOW *w, int y, int x)
   {
   return mvwdelch(w, y, x);
   }

int CB_mvwgetch(WINDOW *w, int y, int x)
   {
   return mvwgetch(w, y, x);
   }

int CB_mvwgetstr(WINDOW *w, int y, int x, char* str)
   {
   return mvwgetstr(w, y, x, str);
   }

int CB_mvwinch(WINDOW *w, int y, int x)
   {
   return mvwinch(w, y, x);
   }

int CB_mvwinsch(WINDOW *w, int y, int x, chtype ch)
   {
   return mvwinsch(w, y, x, ch);
   }

void CB_nocbreak(void)
   {
   nocbreak();
   }

void CB_nocrmode(void)
   {
   nocrmode();
   }

void CB_nodelay(WINDOW *w, bool flag)
   {
   nodelay(w, flag);
   }

void CB_noecho(void)
   {
   noecho();
   }

void CB_nl(void)
   {
   nl();
   }

void CB_nonl(void)
   {
   nonl();
   }

int CB_scroll(WINDOW *w)
   {
   return scroll(w);
   }

int CB_standend(void)
   {
   return standend();
   }

int CB_standout(void)
   {
   return standout();
   }

void CB_scrollok(WINDOW *w, bool flag)
   {
   scrollok(w, flag);
   }

int CB_refresh(void)
   {
   return refresh();
   }

int CB_waddch(WINDOW *w, chtype ch)
   {
   return waddch(w, ch);
   }

int CB_wclear(WINDOW *w)
   {
   return wclear(w);
   }

void CB_winch(WINDOW *w)
   {
   winch(w);
   }

int CB_winstr(WINDOW *w, char *s)
   {
   return winstr(w, s);
   }

int CB_wstandend(WINDOW *w)
   {
   return wstandend(w);
   }

int CB_wstandout(WINDOW *w)
   {
   return wstandout(w);
   }

int CB_wechochar(WINDOW *w, chtype ch)
   {
   return wechochar(w, ch);
   }

/************************************************************
 *
 * Functions created for convenience and to properly enforce
 * data abstraction.
 *
 ************************************************************/

attr_t CB_wgetattr(WINDOW *w, attr_t a)
   {
   return w->_attrs;
   }
