
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adtitmes.adb "adatui-title_message.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure title_message ( msg : string ) is
   void       : c.signed_int;
   temp_str   : bstrings.bounded_string;
   temp_charv : aliased c.charv(1..80); 
   temp_charp : c.charp;

begin
   temp_str := pad_string (
      str    => msg, 
      length => bw-3 );

   make_charv (
      source => temp_str,
      target => temp_charv );
--
-- using unchecked access because type c.charp is defined at a higher
-- level than temp_charv - creates a potential for dangling pointers
--
   temp_charp := temp_charv'unchecked_access;

   void := pdcurses.mvwaddstr ( title_window, 0, 2, temp_charp );
   void := pdcurses.wrefresh ( title_window );
end title_message;
