
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adprestr.adb "adatui-prepad_string.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
function prepad_string (
   str    : string;
   length : natural      )
   return   bstrings.bounded_string is

   function "*" (
      left : in natural;
      right : in character)
      return string 
      renames ada.strings.fixed."*"; 

   result : bstrings.bounded_string;

begin
   result := bstrings.to_bounded_string ( (length * ' ') & str );
   return result;
end prepad_string;
