#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#undef lines
#endif

#ifdef PDCDEBUG
char *rcsid__scropen = "$Header: C:\CURSES\private\RCS\_scropen.c 2.1 1993/06/18 20:22:59 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_scr_open()	- Internal low-level binding to open the physical screen

  PDCurses Description:
 	This function provides a low-level binding for the Flexos
 	platform which must open the screen before writing to it.

 	This function is provided in order to access the FlexOS 16 bit
 	character set for input rather than the limited input
 	character set associated with the VT52.

  PDCurses Return Value:
 	This function returns OK on success, otherwise an ERR is returned.

  PDCurses Errors:
 	The DOS platform will never fail.  The Flexos platform may fail
 	depending on the ability to open the current virtual console in
 	8 (as opposed to 16) bit mode.

  Portability:
 	PDCurses	int	PDC_scr_open( SCREEN* internal, bool echo );

**man-end**********************************************************************/

int	PDC_scr_open(SCREEN *internal, bool echo)
{

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_scr_open() - called\n");
#endif

#ifdef	FLEXOS
	retcode = s_get(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	if (retcode < 0L)
		return( ERR );

	kbmode = vir.vc_kbmode;
	cmode = vir.vc_mode;
	vir.vc_mode = 0;

	if (!echo)	vir.vc_kbmode |= VCKM_NECHO;
	else		vir.vc_kbmode &= ~VCKM_NECHO;

	smode = vir.vc_smode;
	retcode = s_set(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	if  (retcode < 0L)
		return( ERR );

	if (vir.vc_type & 0x03)	internal->mono = TRUE;
	else			internal->mono = FALSE;

	internal->orig_attr = vir.vc_flcolor | vir.vc_blcolor;
	_flexos_16bitmode();
#endif

#ifdef	DOS
	internal->orig_attr	 = 0;
	internal->orig_emulation = getdosmembyte (0x487);
#endif

#ifdef	OS2
	internal->orig_attr	 = 0;
	internal->orig_emulation = 0;
#endif

#ifdef UNIX
	PDC_get_cursor_pos(&internal->cursrow, &internal->curscol);
	internal->autocr	= FALSE;		/* lf -> crlf by default      */
	internal->raw_out	= FALSE;	/* tty I/O modes	      */
	internal->raw_inp	= FALSE;	/* tty I/O modes	      */
	internal->cbreak	= FALSE;
	internal->echo		= echo;
	internal->refrbrk	= FALSE;	/* no premature end of refresh*/
	internal->visible_cursor= TRUE;		/* Assume that it is visible  */
	internal->cursor	= 0;
	internal->font		= 0;
	internal->lines		= PDC_get_rows();
	internal->cols		= PDC_get_columns();
	internal->audible	= TRUE;
	internal->direct_video	= FALSE;		/* Assume that we can	      */
	internal->adapter	= PDC_query_adapter_type();
	_CUR_TERM.prog_mode.c_iflag &= ~(ICRNL);
	_CUR_TERM.prog_mode.c_oflag &= ~(ONLCR|OPOST);
	_CUR_TERM.prog_mode.c_lflag &= ~(ICANON|ECHO);
	_CUR_TERM.prog_mode.c_cc[VMIN] = 1;
	ioctl(_CUR_TERM.fd, TCSETA, &_CUR_TERM.prog_mode);
#else
	PDC_get_cursor_pos(&internal->cursrow, &internal->curscol);
	internal->autocr	= TRUE;		/* lf -> crlf by default      */
	internal->raw_out	= FALSE;	/* tty I/O modes	      */
	internal->raw_inp	= FALSE;	/* tty I/O modes	      */
	internal->cbreak	= FALSE;
	internal->echo		= echo;
	internal->refrbrk	= FALSE;	/* no premature end of refresh*/
#if !defined OS2
	internal->video_seg	= 0xb000;	/* Base screen segment addr   */
	internal->video_ofs	= 0x0;		/* Base screen segment ofs    */
#endif
	internal->video_page	= 0;		/* Current Video Page	      */
	internal->direct_video	= TRUE;		/* Assume that we can	      */
	internal->visible_cursor= TRUE;		/* Assume that it is visible  */
	internal->cursor	= PDC_get_cursor_mode();
	internal->adapter	= PDC_query_adapter_type();
	internal->font		= PDC_get_font();
	internal->scrnmode	= PDC_get_scrn_mode();
	internal->lines		= PDC_get_rows();
	internal->cols		= PDC_get_columns();
	internal->audible	= TRUE;
#endif
	return( OK );
}
