#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__clrupda = "$Header: C:\CURSES\private\RCS\_clrupda.c 2.1 1993/06/18 20:22:48 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_clr_update()	- Updates the screen with a full redraw.

  PDCurses Description:
 	Updates the screen by clearing it and then redraw it in its
 	entirety. If _cursvar.refrbrk is TRUE, and there is pending
 	input characters, the update will be prematurely terminated.

  PDCurses Return Value:
 	This routine returns ERR if it is unable to accomplish it's task.
 	This return value is ONLY under FLEXOS.

 	The return value OK is returned if there were no errors.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_clr_update( WINDOW* s );

**man-end**********************************************************************/

int	PDC_clr_update(WINDOW *s)
{
register int	i;
register int	j;
	WINDOW*	w;
	chtype*	ch;
	bool rc;

#if defined(DOS)
#  if SMALL || MEDIUM
struct SREGS segregs;
int ds;
#  endif
#endif

#ifdef	FLEXOS
	char	line[80];
	char	attr[80];
	FFRAME	sframe;
	RECT	drect,
		srect;
#endif

	extern unsigned	char atrtab[MAX_ATRTAB];
	chtype temp_line[256]; /* this should be enough for the maximum width of a screen. MH-920715 */
	chtype chr;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_clr_update() - called\n");
#endif

	w = curscr;
	if (w == (WINDOW *)NULL)
		return( ERR );
	if (_cursvar.full_redraw)
		PDC_clr_scrn(s); /* clear physical screen */

	s->_clear = FALSE;
	for (i = 0; i < LINES; i++)	/* update physical screen */
	{
		if (s != w)	/* copy s to curscr */

			memcpy(w->_y[i], s->_y[i], COLS * sizeof(chtype));

	ch = temp_line; /* now have ch pointing to area to contain real attributes. MH-920715 */

		memcpy(ch,s->_y[i],COLS*sizeof(chtype)); /* copy current line to temp_line. MH-920715 */

#ifndef UNIX
		for (j=0;j<COLS;j++)          /* for each chtype in the line... */
		   {
		    chr = temp_line[j] & A_CHARTEXT;
		    temp_line[j] = chtype_attr(temp_line[j]) | chr;
		   }
#endif

		if (_cursvar.direct_video)
		{
#ifdef	FLEXOS
			PDC_split_plane(w, &line[0], &attr[0], i, 0, i, COLS);
/* need to translate attr[] array to real attributes before displaying it. MH-920715 */
			drect.r_row = i;
			drect.r_col = 0;
			drect.r_nrow = 1;
			drect.r_ncol = COLS;

			sframe.fr_pl[0] = (UBYTE *) line;
			sframe.fr_pl[1] = (UBYTE *) attr;
			sframe.fr_nrow = 1;
			sframe.fr_ncol = COLS;
			sframe.fr_use = 0x03;

			srect.r_col = 0;
			srect.r_row = 0;
			srect.r_nrow = 1;
			srect.r_ncol = COLS;

			s_copy(0x03, 0x01L, 0L, (far unsigned short *) &drect,
				(far unsigned short *) &sframe,
				(far unsigned short *) &srect);
#endif

#ifdef	DOS
#  ifdef GO32
			dosmemput (ch, COLS * sizeof(chtype),
				(void *)_FAR_POINTER(_cursvar.video_seg,
				_cursvar.video_ofs + (i * COLS * sizeof(chtype))));
#  else
#    if	(SMALL || MEDIUM)
		segread(&segregs);
		ds = segregs.ds;
		movedata(ds, (int)ch,
				_cursvar.video_seg,
				_cursvar.video_ofs + (i*COLS*sizeof(chtype)),
			        (COLS * sizeof(chtype)));
#    else
			memcpy((void *)_FAR_POINTER(_cursvar.video_seg,
			  _cursvar.video_ofs + (i * COLS * sizeof(chtype))),
			       ch, (COLS * sizeof(chtype)));
#    endif
#  endif
#endif

#ifdef	OS2
				VioWrtCellStr ((PCH)ch, (USHORT)(COLS * sizeof(chtype)), (USHORT)i, 0, 0);
#endif
		}
		else
		{

#ifdef UNIX
			PDC_gotoxy(i, 0);
			for (j = 0; j < COLS; j++)
			{
				PDC_putc( (*ch & A_CHARTEXT), (*ch & A_ATTRIBUTES) );
				ch++;
			}
#else
			for (j = 0; j < COLS; j++)
			{
				PDC_gotoxy(i, j);
				PDC_putc( (*ch & A_CHARTEXT), (*ch & A_ATTRIBUTES) >> 8 );
				ch++;
			}
#endif
		}

	if (_cursvar.refrbrk && PDC_check_bios_key())
		return(OK);

	}
	return( OK );
}
