#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wgetch

#ifdef PDCDEBUG
char *rcsid_wgetch = "$Header: C:\CURSES\portable\RCS\wgetch.c 2.1 1993/06/18 20:19:01 MH Rel MH $";
#endif

static WINDOW *w;			/* to reduce stack usage   */







/*man-start*********************************************************************

  wgetch()	- read character

  X/Open Description:
 	A character is read from the terminal associated with the
 	window.  In nodelay mode, if there is no input waiting,
 	the value ERR is returned.  In delay mode, the program will
 	hang until the system passes text through to the program.
 	Depending on the setting of cbreak(), this will be after one
 	character or after the first newline.  Unless noecho() has
 	been set, the character will also be echoed into the designated
 	window.

 	If keypad() is TRUE, and a function key is pressed, the token for
 	that function key will be returned instead of the raw characters.
 	Possible function keys are defined in <curses.h> with integers
 	beginning with 0401, whose names begin with KEY_.  If a character
 	is received that could be the beginning of a function key (such as
 	escape), curses will set a timer.  If the remainder of the sequence
 	does not come in within the designated time, the character will be
 	passed through, otherwise the function key value will be returned.
 	For this reason, on many terminals, there will be a delay after a
 	user presses the escape key before the escape is returned to the
 	program.  (Use by a programmer of the escape key for a single
 	character function is discouraged.)

 	If nodelay(win,TRUE) has been called on the window and no input is
 	waiting, the value ERR is returned.

 	NOTE: getch(), mvgetch() and mvwgetch() are macros.

  PDCurses Description:
 	Given the nature of the PC, there is no such timer set for an
 	incoming ESCAPE value, because function keys generate unique
 	scan codes that are not prefixed with the ESCAPE character.

 	Also, note that the getch() definition will conflict  with
 	many DOS compiler's runtime libraries.

  X/Open Return Value:
 	This functions return ERR or the value of the character, meta 
 	character or function key token.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wgetch( WINDOW* win );
 	X/Open Dec '88	int wgetch( WINDOW* win );
 	BSD Curses	int wgetch( WINDOW* win );
 	SYS V Curses	int wgetch( WINDOW* win );

**man-end**********************************************************************/

int	wgetch(WINDOW *win)
{
extern	short	c_pindex;		/* putter index		   */
extern	short	c_gindex;		/* getter index		   */
extern	short	c_ungind;		/* wungetch() push index   */
extern	chtype	c_ungch[NUNGETCH];	/* array of ungotten chars */
extern  WINDOW*	_getch_win_;

	signed	key;
	bool	cbr;
	static	chtype	buffer[_INBUFSIZ];	/* character buffer */
#ifdef UNIX
	short display_key = 0400;
	bool cbreak_set = FALSE;
#else
	short display_key = 0x100;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wgetch() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	if (c_ungind)				/* if ungotten char exists */
		return( c_ungch[--c_ungind] );	/* remove and return it */

	if (win->_nodelay
	&& !PDC_check_bios_key())
		return(ERR);

	_getch_win_ = win;

	if ((!_cursvar.raw_inp) &&
	    (!_cursvar.cbreak))
	{
		/*
		 * if normal
		 */
		if (c_gindex < c_pindex)
		{
			/*
			 * and data in buffer
			 */
			return( buffer[c_gindex++] );
		}
	}

	w = win;		/* static for speed & stack */
	c_pindex = 0;		/* prepare to buffer data */
	c_gindex = 0;
	for(;;)			/* loop for any buffering */
	{
#ifdef UNIX
		if (!(_cursvar.raw_inp || _cursvar.cbreak))
			{
			cbreak();
			cbreak_set = TRUE;
			}
		if (w->_use_keypad)
			key = PDC_sysgetch();
		else
			key = PDC_rawgetch();
		if (cbreak_set)
			nocbreak();
#else
		if (_cursvar.raw_inp)
		{
			/*
			 * get a raw character
			 */
			key = PDC_rawgetch();
		}
		else
		{
			/*
			 * get a system character
			 * if break return proper
			 */
			cbr = PDC_get_ctrl_break();
			PDC_set_ctrl_break(_cursvar.orgcbr);
			key = PDC_sysgetch();
			PDC_set_ctrl_break(cbr);	/* restore as it was */
		}
#endif
		if (w->_nodelay && (key == -1))
		{
			/*
			 * if nodelay and no char
			 */
			return( ERR );
		}
		if ((key == '\r') &&
		    (_cursvar.autocr) &&
		    (!_cursvar.raw_inp))
		{
			/*
			 * translate CR
			 */
			key = '\n';
		}
		if (_cursvar.echo && (key < display_key))
		{
			/*
			 * if echo is enabled
			 */
			waddch(w, key);
			wrefresh(w);
		}
		if (_cursvar.raw_inp || _cursvar.cbreak)
		{
			/*
			 * if no buffering
			 */
			return( key );
		}

		if (c_pindex < _INBUFSIZ - 2)
		{
			/*
			 * if no overflow, put data in buffer
			 */
			buffer[c_pindex++] = key;
		}
		if ((key == '\n') || (key == '\r'))
		{
			/*
			 * if we got a line
			 */
			return( buffer[c_gindex++] );
		}
	}
}
