% mousex.sl
%
% Mouse routines for use inside an XTerm.
%
% It's reputed to work with the Linux Console (running selection -- gpm)
% but it doesn't on my machine.
%
%
%
% Mouse actions:	New rules (more XTerm-like)
%
% LEFT button:
%	If a region is marked, unmark it.
%	Move the point to this new location.
%
% MIDDLE button:
%	If a region is marked, copy it to the pastebuffer.
%	Otherwise, paste contents of the pastebuffer at the current point.
%
% RIGHT button:
%	Extend the region to this point.
%
% Special actions for the status line:
% 	LEFT:	switch window to a different buffer
%	MIDDLE:	split the window
%	RIGHT:	delete the window.
%
%
% Cut/Paste Tips:
%
%  To mark and manipulate a region:
%
%   1.	Click the LEFT mouse button at the beginning of the region.
%   2.	Move the mouse to the end of the region and click the RIGHT
%	mouse button.  The region should now be marked.
%
%	Repeat step 2 to extend the marked region, as required.
%	Repeat step 1 to start again.
%
%   3.	Click the MIDDLE button to copy the marked region to the pastebuffer.
%
%   4.	Clicking the MIDDLE button will paste the contents of the pastebuffer
%	at the current point (use Step 1 to set the current point).
%
% Notes:
%	To delete the marked region, use the normal keystrokes, it's not
%	so convenient, but it does save making mistakes and is consistent
%	with the XTerm convention.  If this restriction is too annoying,
%	then it's probably worth using an ESC prefixed sequence.
%
%
%	If you use the specially patched rxvt, holding down Alt (Mod1) while
%	using the mouse will permit the normal XTerm selection and pasting
%	to work.
%
% mj olesen

% enable mouse
tt_send ("\e[?9h");

% hooks to properly restore selection state (See $JED_ROOT/doc/mouse.txt)
define exit_hook ()
{
   tt_send ("\e[?9l");
   exit_jed ();
}

define suspend_hook ()
{
   tt_send ("\e[?9l");
}

define resume_hook ()
{
   tt_send ("\e[?9h");
}

% define keys
setkey ("mouse_button1", "\e[M\040");
setkey ("mouse_button2", "\e[M\041");
setkey ("mouse_button3", "\e[M\042");

% for the future?
% setkey ("esc_mouse_button1", "\e\e[M\040");
% setkey ("esc_mouse_button2", "\e\e[M\041");
% setkey ("esc_mouse_button3", "\e\e[M\042");

% misc service functions
define pop_n ()			       %  argument on stack
{
   loop () pop ();
}

define otherwindow_n ()		       %  argument on stack
{
   loop () otherwindow ();
}

% returns  values:  line/column of mouse point, number of windows away, and
% flag indicating whether or not the point in on the status line.
% usage:
%   (is_status, nwins, row, column) = mouse_whereis ();
define mouse_whereis ()
{
   variable is_status = 0, n, y, x, top, bot;

   n = nwindows ();
   x = getkey () - ' ';
   y = getkey () - ' ';

   % error (Sprintf ("x: %d, y: %d", x, y, 2));

   while (n)
     {
        top = window_info('t');
	bot = window_info('r') + top;

	if ((y >= top) and (y < bot))
       	  {
	     y += 1 + what_line () - (top + window_line());
	     break;
	  }

      	if (y == bot)
	  {
	     is_status = 1;
	     break;
	  }

	otherwindow();
	n--;
     }

   !if (n) error ("Mouse not in a window.");
   otherwindow_n (n);
   x += window_info('c') - 1;

   return (is_status, nwindows () - n, x, y);
}

define mouse_next_buffer ()
{
   variable n, buf, cbuf = whatbuf ();

   n = buffer_list ();		       % buffers on stack
   loop (n)
     {
	buf = ();
	n--;
	if (buf[0] == ' ') continue;
	if (buffer_visible (buf)) continue;
	sw2buf (buf);
	pop_n (n);
	return;
     }
   error ("All buffers are visible.");
}

% Left mouse button
define mouse_button1 ()
{
   variable is_status, n, x, y;

   (is_status, n, x, y) = mouse_whereis ();

   otherwindow_n (n);
   if (is_status)
     {
	mouse_next_buffer ();
	return;
     }
   if (markp()) pop_mark (0);

   goto_line (y);
   () = goto_column_best_try (x);
}

% Middle mouse button
define mouse_button2 ()
{
   variable is_status, n;

   (is_status, n,,) = mouse_whereis ();

   if (is_status)
     {
	otherwindow_n (n);
	splitwindow ();
	return;
     }

   if (markp ())
     {
	otherwindow_n (n);
	call ("copy_region");
	message ("Region copied.");
	return;
     }
   call ("yank");
}

% Right mouse button
define mouse_button3 ()
{
   variable is_status, n, x, y;

   (is_status, n, x, y) = mouse_whereis ();

   otherwindow_n (n);
   if (is_status)
     {
	call ("delete_window");
	return;
     }

   !if (markp ())
     call ("set_mark_cmd");

   goto_line (y);
   () = goto_column_best_try (x);
}
%%%%%%%%%%%%%%%%%%%%%%%%%% end-of-file (SLang) %%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% for historic purposes, here are the old rules
%
% LEFT button:
%	Move the point to this new location.
%
% MIDDLE button:
%	If a region is marked, copy it to the pastebuffer.
%	Otherwise, paste contents of the pastebuffer at the current point.
%
% RIGHT button:
%	If a region is marked, kill it to the pastebuffer.
%	Otherwise, set the mark to define a region.
%
% Special actions for the status line:
% 	LEFT:	switch window to a different buffer
%	MIDDLE:	split the window
%	RIGHT:	delete the window.
%
% Cut/Paste Tips:
%
%  To mark and manipulate a region do:
%
%   1. Click the LEFT mouse button at the beginning of the region.
%   2. Move the mouse to the end of the region and click the RIGHT
%      mouse button.  The region should now be marked.
%   3. To delete it and copy it to the paste buffer,  press the RIGHT button
%      again.  To simply copy it without deleting it, press the MIDDLE button.
%
%   4. To paste from the pastebuffer, move the mouse to where you want to
%      paste and press the MIDDLE button.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
