/* DO NOT MODIFY THIS FILE!  It was generated by "charset.pl".  */

/* Conversion of files between different charsets and usages.
   Copyright (C) 1990, 1993 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1993.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "recode.h"

/* IBM038
   EBCDIC-INT
   cp038
*/

static DOUBLE_TABLE table_80 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  <(. < ( + ! &                   )>DO* ) ; '>",
    "- /                 BB, % _ > ?                   '!: NbAt' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  '?s t u v w x y z                                             ",
    "(!A B C D E F G H I             !)J K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* IBM273
   CP273
*/

static DOUBLE_TABLE table_81 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>(!a!a'a?aac,n?A:. < ( + ! & e'e>e:e!i'i>i:i!'?U:DO* ) ; '>",
    "- / A><(A!A'A?AAC,N?o:, % _ > ? o/E'E>E:E!I'I>I:I!'!: NbSE' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-DGj k l m n o p q r -a-oae',AECu",
    "Mysss t u v w x y z !I?ID-Y'THRgCtPdYe.MCoAtPI141234NO!!'-':''*X",
    "a:A B C D E F G H I --o>BBo!o'o?u:J K L M N O P Q R 1Su>!)u!u'y:",
    "O:-:S T U V W X Y Z 2SO>//O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>)>U!U'DT",
  };

/* IBM274
   EBCDIC-BE
   CP274
*/

static DOUBLE_TABLE table_82 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  <(. < ( + ! &                   )>DO* ) ; '>",
    "- /                 u!, % _ > ?                   '!: Nba!' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  ':s t u v w x y z                                             ",
    "e'A B C D E F G H I             e!J K L M N O P Q R             ",
    "c,  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* IBM275
   EBCDIC-BR
   cp275
*/

static DOUBLE_TABLE table_83 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  E'. < ( + ! &                   DOC,* ) ; '>",
    "- /                 c,, % _ > ?                   a?: O?A?' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  '?s t u v w x y z                                             ",
    "o?A B C D E F G H I             e'J K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* IBM277
   EBCDIC-CP-DK
   EBCDIC-CP-NO
*/

static DOUBLE_TABLE table_84 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:a!a'a?!)c,n?Nb. < ( + ! & e'e>e:e!i'i>i:i!ssCuAA* ) ; '>",
    "- / A>A:A!A'A?DOC,N?o/, % _ > ? BBE'E>E:E!I'I>I:I!'!: AEO/' = \" ",
    "Ata b c d e f g h i <<>>d-y'th+-DGj k l m n o p q r -a-o(!',<()>",
    "Myu:s t u v w x y z !I?ID-Y'THRgCtPdYe.MCoSEPI141234NO!!'-':''*X",
    "aeA B C D E F G H I --o>o:o!o'o?aaJ K L M N O P Q R 1Su>'?u!u'y:",
    "//-:S T U V W X Y Z 2SO>O:O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM278
   CP278
   ebcdic-cp-fi
   ebcdic-cp-se
*/

static DOUBLE_TABLE table_85 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>(!a!a'a?!)c,n?SE. < ( + ! & '!e>e:e!i'i>i:i!ssCuAA* ) ; '>",
    "- / A>NbA!A'A?DOC,N?o:, % _ > ? o/E'E>E:E!I'I>I:I!e': A:O:' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-DGj k l m n o p q r -a-oae',AE)>",
    "Myu:s t u v w x y z !I?ID-Y'THRgCtPdYe.MCo<(PI141234NO!!'-':''*X",
    "a:A B C D E F G H I --o>BBo!o'o?aaJ K L M N O P Q R 1Su>'?u!u'y:",
    "//-:S T U V W X Y Z 2SO>AtO!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM280
   CP280
   ebcdic-cp-it
*/

static DOUBLE_TABLE table_86 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:(!a'a?aa//n?DG. < ( + ! & )>e>e:!)i'i>i:'?sse'DO* ) ; '>",
    "- / A>A:A!A'A?AAC,N?o!, % _ > ? o/E'E>E:E!I'I>I:I!u!: PdSE' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-<(j k l m n o p q r -a-oae',AECu",
    "Myi!s t u v w x y z !I?ID-Y'THRgCtNbYe.MCoAtPI141234NO!!'-':''*X",
    "a!A B C D E F G H I --o>o:BBo'o?e!J K L M N O P Q R 1Su>u:'!u'y:",
    "c,-:S T U V W X Y Z 2SO>O:O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM281
   EBCDIC-JP-E
   cp281
*/

static DOUBLE_TABLE table_87 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  Pd. < ( + !!&                   ! Ye* ) ; NO",
    "- /                 BB, % _ > ?                   '!: NbAt' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  '-s t u v w x y z                                             ",
    "(!A B C D E F G H I             !)J K L M N O P Q R             ",
    "DO  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* IBM284
   CP284
   ebcdic-cp-es
*/

static DOUBLE_TABLE table_88 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:a!a'a?aac,BB<(. < ( + !!& e'e>e:e!i'i>i:i!ss)>DO* ) ; NO",
    "- / A>A:A!A'A?AAC,Nbn?, % _ > ? o/E'E>E:E!I'I>I:I!'!: N?At' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-DGj k l m n o p q r -a-oae',AECu",
    "My':s t u v w x y z !I?ID-Y'THRgCtPdYe.MCoSEPI141234'>! '-'?''*X",
    "(!A B C D E F G H I --o>o:o!o'o?!)J K L M N O P Q R 1Su>u:u!u'y:",
    "//-:S T U V W X Y Z 2SO>O:O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM285
   CP285
   ebcdic-cp-gb
*/

static DOUBLE_TABLE table_89 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:a!a'a?aac,n?DO. < ( + !!& e'e>e:e!i'i>i:i!ss! Pd* ) ; NO",
    "- / A>A:A!A'A?AAC,N?BB, % _ > ? o/E'E>E:E!I'I>I:I!'!: NbAt' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-DGj k l m n o p q r -a-oae',AECu",
    "My'?s t u v w x y z !I?ID-Y'THRgCt<(Ye.MCoSEPI141234'>)>'-':''*X",
    "(!A B C D E F G H I --o>o:o!o'o?!)J K L M N O P Q R 1Su>u:u!u'y:",
    "//-:S T U V W X Y Z 2SO>O:O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM290
   cp290
   EBCDIC-JP-kana
*/

static DOUBLE_TABLE table_90 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP._<'>',_.6Woa6i6u6Pd. < ( + !!& e6o6YAYUYOTU  -6  ! Ye* ) ; NO",
    "- /                 BB, % _ > ?                   '!: NbAt' = \" ",
    "  A6I6U6E6O6KaKiKuKeKo  SaSiSuSeSoTaTiTuTeToNaNiNuNeNo    HaHiHu",
    "  '-HeHoMaMiMuMeMoYaYu  YoRaRiRu                    ReRoWaN6\"505",
    "  A B C D E F G H I               J K L M N O P Q R             ",
    "DO  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* IBM297
   cp297
   ebcdic-cp-fr
*/

static DOUBLE_TABLE table_91 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:Ata'a?aa//n?DG. < ( + ! & (!e>e:!)i'i>i:i!ssSEDO* ) ; '>",
    "- / A>A:A!A'A?AAC,N?u!, % _ > ? o/E'E>E:E!I'I>I:I!My: Pda!' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-<(j k l m n o p q r -a-oae',AECu",
    "'!':s t u v w x y z !I?ID-Y'THRgCtNbYe.MCo)>PI141234NO!!'-'?''*X",
    "e'A B C D E F G H I --o>o:o!o'o?e!J K L M N O P Q R 1Su>u:BBu'y:",
    "c,-:S T U V W X Y Z 2SO>O:O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM420
   cp420
   ebcdic-cp-ar1
*/

static DOUBLE_TABLE table_92 = 
  {
    "NU SH SX EX ET EQ AK BL BS HT LF VT FF CR SO SI DL D1 D2 D3 D4 NK SY EB CN EM SB EC FS GS RS US ",
    NULL,
    "SP NS 3+ 3+;++    H' aM aM.aH Ct .  <  (  +  !! &  aH.wH       yH a+ a+.b+ b+,!  DO *  )  ;  NO ",
    "-  /  tm t+ t+,tk tk,g+ g+,hk BB ,  %  _  >  ?  hk,x+ x+,d+ dk r+ z+ s+ s+,,+ :  Nb At '  =  \"  ",
    "sn a  b  c  d  e  f  g  h  i  sn,c+ c+,dd dd,tj zH j  k  l  m  n  o  p  q  r  e+ e+.e+,e+;i+ i+.",
    "i+,-: s  t  u  v  w  x  y  z  i+;f+ f+,q+ q+,k+ k+,l+ lM-lM.lH-lH.      la-la.l+,m+ m+,n+ n+,h+ ",
    ";+ A  B  C  D  E  F  G  H  I  -- h+,   h+;   w+ ?+ J  K  L  M  N  O  P  Q  R  j+ j+.y+ y+.y+,0a ",
    "*X    S  T  U  V  W  X  Y  Z  1a 2a    3a 4a 5a 0  1  2  3  4  5  6  7  8  9     6a 7a 8a 9a DT ",
  };

/* IBM423
   cp423
   ebcdic-cp-gr
*/

static DOUBLE_TABLE table_93 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPA*B*G*D*E*Z*Y*H*I*<(. < ( + ! & K*L*M*N*C*O*P*R*S*)>DO* ) ; '>",
    "- / T*U*F*X*Q*W*      , % _ > ?   A%E%Y%  I%O%U%W%'!: PdSE' = \" ",
    "A:a b c d e f g h i a*b*g*d*e*z*O:j k l m n o p q r y*h*i*k*l*m*",
    "U:':s t u v w x y z n*c*o*p*r**s  a%e%y%j*i%o%u%v*w%s*t*u*f*x*q*",
    "%'y=z=s%jescc%='JUA=B=C=D=E=F=G=',A B C D E F G H I   w*A>a!a:e>",
    "''J K L M N O P Q R +-e'e!e:i>i:DG  S T U V W X Y Z 12o:o>u>u!u:",
  };

/* IBM424
   cp424
   ebcdic-cp-he
*/

static DOUBLE_TABLE table_94 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPA+B+G+D+H+W+Z+X+TjCt. < ( + !!& J+K%K+L+M%M+N%N+S+! DO* ) ; NO",
    "- / E+P%P+ZjZJQ+R+ShBB, % _ > ?   T+    NS      =='!: NbAt' = \" ",
    "  a b c d e f g h i <<>>        DGj k l m n o p q r       ',  Cu",
    "My'?s t u v w x y z           Rg'>PdYe.MCoSEPI141234<()>'-':''*X",
    "(!A B C D E F G H I --          !)J K L M N O P Q R 1S          ",
    "//-:S T U V W X Y Z 2S          0 1 2 3 4 5 6 7 8 9 3S        DT",
  };

/* IBM437
   cp437
   437
*/

static DOUBLE_TABLE table_95 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:a!aac,e>e:e!i:i>i!A:AAE'aeAEo>o:o!u>u!y:O:U:CtPdYePtFl",
    "a'i'o'u'n?N?-a-o?ININO1214!I<<>>.S:S?SvvvlvLVlDldLVLVVLDULUluLdl",
    "uruhdhvrhhvhvRVrURDRUHDHVRHHVHuHUhdHDhUruRdRDrVhvHuldrFBLBlBRBTB",
    "a*b*G*p*S*s*m*t*F*H*W*d*00/0e*(U=3+->==<IuIl-:?2Ob.MSbRTnS2SfSNS",
  };

/* IBM500
   CP500
   ebcdic-cp-be
   ebcdic-cp-ch
*/

static DOUBLE_TABLE table_96 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:a!a'a?aac,n?<(. < ( + ! & e'e>e:e!i'i>i:i!ss)>DO* ) ; '>",
    "- / A>A:A!A'A?AAC,N?BB, % _ > ? o/E'E>E:E!I'I>I:I!'!: NbAt' = \" ",
    "O/a b c d e f g h i <<>>d-y'th+-DGj k l m n o p q r -a-oae',AECu",
    "My'?s t u v w x y z !I?ID-Y'THRgCtPdYe.MCoSEPI141234NO!!'-':''*X",
    "(!A B C D E F G H I --o>o:o!o'o?!)J K L M N O P Q R 1Su>u:u!u'y:",
    "//-:S T U V W X Y Z 2SO>O:O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM850
   cp850
   850
*/

static DOUBLE_TABLE table_97 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:a!aac,e>e:e!i:i>i!A:AAE'aeAEo>o:o!u>u!y:O:U:o/PdO/*XFl",
    "a'i'o'u'n?N?-a-o?IRgNO1214!I<<>>.S:S?SvvvlA'A>A!CoVLVVLDULCtYedl",
    "uruhdhvrhhvha?A?URDRUHDHVRHHVHCud-D-E>E:E!i.I'I>I:uldrFBLBBBI!TB",
    "O'ssO>O!o?O?m*THthU'U>U!y'Y'-M''--+-==34PISE-:';DG':'.1S3S2SfSNS",
  };

/* IBM851
   cp851
   851
*/

static DOUBLE_TABLE table_98 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:a!A%c,e>e:e!i:i>E%A:Y%I%  O%o>o:U%u>u!W%O:U:a%Pde%y%i%",
    "j*i3o%u%A*B*G*D*E*Z*Y*12H*I*<<>>.S:S?SvvvlK*L*N*M*VLVVLDULC*O*dl",
    "uruhdhvrhhvhP*R*URDRUHDHVRHHVHS*T*U*F*X*Q*W*a*b*g*uldrFBLBd*e*TB",
    "z*y*h*i*k*l*m*n*c*o*p*r*s**st*''--+-u*f*x*SEq*';DG':w*v*u3w%fSNS",
  };

/* IBM852
   cp852
   852
*/

static DOUBLE_TABLE table_99 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:u0c'c,l/e:O\"o\"i>Z'A:C'E'L'l'o>o:L<l<S's'O:U:T<t<L/*Xc<",
    "a'i'o'u'A;a;Z<z<E;e;  z'C<s,<<>>.S:S?SvvvlA'A>E<S,VLVVLDULZ.z.dl",
    "uruhdhvrhhvhA(a(URDRUHDHVRHHVHCud/D/D<E:d<N<I'U>e<uldrFBLBT,U0TB",
    "O'ssO>N'n'n<S<s<R'U'r'U\"y'Y't,''--'\"','<'(SE-:';DG':'.u\"R<r<fSNS",
  };

/* IBM855
   cp855
   855
*/

static DOUBLE_TABLE table_100 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "d%D%g%G%ioIOieIEdsDSiiIIyiYIj%J%ljLJnjNJtsTSkjKJv%V%dzDZjuJU='=\"",
    "a=A=b=B=c=C=d=D=e=E=f=F=g=G=<<>>.S:S?Svvvlh=H=i=I=VLVVLDULj=J=dl",
    "uruhdhvrhhvhk=K=URDRUHDHVRHHVHCul=L=m=M=n=N=o=O=p=uldrFBLBP=jaTB",
    "JAr=R=s=S=t=T=u=U=z%Z%v=V=%'%\"''--y=Y=z=Z=s%S%jeJEscScc%C%  fSNS",
  };

/* IBM857
   cp857
   857
*/

static DOUBLE_TABLE table_101 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:a!aac,e>e:e!i:i>i.A:AAE'aeAEo>o:o!u>u!I.O:U:o/PdO/S,s,",
    "a'i'o'u'n?N?G(g(?IRgNO1214!I<<>>.S:S?SvvvlA'A>A!CoVLVVLDULCtYedl",
    "uruhdhvrhhvha?A?URDRUHDHVRHHVHCu-o-aE>E:E!  I'I>I:uldrFBLBBBI!TB",
    "O'ssO>O!o?O?m*  *XU'U>U!i!y:-M''--+-  34PISE-:';DG':'.1S3S2SfSNS",
  };

/* IBM860
   cp860
   860
*/

static DOUBLE_TABLE table_102 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a?a!A'c,e>E>e!I>O>i!A?A>E'A!E!o>o?o!U'u!I!O?U:CtPdU!PtO!",
    "a'i'o'u'n?N?-a-o?IO'NO1214!I<<>>.S:S?SvvvlvLVlDldLVLVVLDULUluLdl",
    "uruhdhvrhhvhvRVrURDRUHDHVRHHVHuHUhdHDhUruRdRDrVhvHuldrFBLBlBRBTB",
    "a*b*G*p*S*s*m*t*F*H*W*d*00/0e*(U=3+->==<IuIl-:?2Ob.MSbRTnS2SfSNS",
  };

/* IBM861
   cp861
   861
   cp-is
*/

static DOUBLE_TABLE table_103 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:a!aac,e>e:e!D-d-THA:AAE'aeAEo>o:thu>Y'y'O:U:o/PdO/PtO!",
    "a'i'o'u'A'I'O'U'?I  NO1214!I<<>>.S:S?SvvvlvLVlDldLVLVVLDULUluLdl",
    "uruhdhvrhhvhvRVrURDRUHDHVRHHVHuHUhdHDhUruRdRDrVhvHuldrFBLBlBRBTB",
    "a*b*G*p*S*s*m*t*F*H*W*d*00/0e*(U=3+->==<IuIl-:?2Ob.MSbRTnS2SfSNS",
  };

/* IBM862
   cp862
   862
*/

static DOUBLE_TABLE table_104 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "A+B+G+D+H+W+Z+X+TjJ+K%K+L+M%M+N%N+S+E+P%P+ZjZJQ+R+ShT+CtPdU!PtO!",
    "a'i'o'u'n?N?-a-o?I  NO1214!I<<>>.S:S?SvvvlvLVlDldLVLVVLDULUluLdl",
    "uruhdhvrhhvhvRVrURDRUHDHVRHHVHuHUhdHDhUruRdRDrVhvHuldrFBLBlBRBTB",
    "a*b*G*p*S*s*m*t*F*H*W*d*00/0e*(U=3+->==<IuIl-:?2Ob.MSbRTnS2SfSNS",
  };

/* IBM863
   cp863
   863
*/

static DOUBLE_TABLE table_105 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>A>a!PIc,e>e:e!i:i>i!A!SEE'E!E>o>E:I:u>u!CuO>U:CtPdU!U>Fl",
    "BB''o'u'':',3S'-I>NINO121434<<>>.S:S?SvvvlvLVlDldLVLVVLDULUluLdl",
    "uruhdhvrhhvhvRVrURDRUHDHVRHHVHuHUhdHDhUruRdRDrVhvHuldrFBLBlBRBTB",
    "a*b*G*p*S*s*m*t*F*H*W*d*00/0e*(U=3+->==<IuIl-:?2Ob.MSbRTnS2SfSNS",
  };

/* IBM864
   cp864
*/

static DOUBLE_TABLE table_106 = 
  {
    "NU SH SX EX ET EQ AK BL BS HT LF VT FF CR SO SI DL D1 D2 D3 D4 NK SY EB CN EM SB EC FS GS RS US ",
    "SP !  \"  Nb DO %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  ",
    "At A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  <( // )> '> _  ",
    "'! a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  (! !! !) '? DT ",
    "DG .M Ob RT :S hh vv vh vl dh vr uh dl dr ur ul ss 00 o/ +- 12 14 ?2 << >> lH-lH.      la-la.a+:",
    "   -- aM.Pd Cu aH.      a+.b+ t+ tk ,+ g+ hk x+ 0a 1a 2a 3a 4a 5a 6a 7a 8a 9a v+ ;+ s+ sn c+ ?+ ",
    "Ct H' aM aH wH e+.yH a+ b+,tm t+,tk,g+,hk,x+,d+ dk r+ z+ s+,sn,c+,dd,tj zH e+,i+,BB NO -: *X e+ ",
    "++ f+.q+.k+,l+.m+,n+.h+,w+ j+ y+,dd m+.i+.i+ m+ 3+;3+ n+ h+ h+;j+.y+.f+ q+ lM-lM.l+ k+ y+ fS NS ",
  };

/* IBM865
   cp865
   865
*/

static DOUBLE_TABLE table_107 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "C,u:e'a>a:a!aac,e>e:e!i:i>i!A:AAE'aeAEo>o:o!u>u!y:O:U:o/PdO/PtFl",
    "a'i'o'u'n?N?-a-o?ININO1214!I<<>>.S:S?SvvvlvLVlDldLVLVVLDULUluLdl",
    "uruhdhvrhhvhvRVrURDRUHDHVRHHVHuHUhdHDhUruRdRDrVhvHuldrFBLBlBRBTB",
    "a*b*G*p*S*s*m*t*F*H*W*d*00/0e*(U=3+->==<IuIl-:?2Ob.MSbRTnS2SfSNS",
  };

/* IBM868
   CP868
   cp-ar
*/

static DOUBLE_TABLE table_108 = 
  {
    "NU SH SX EX ET EQ AK BL BS HT LF VT FF CR SO SI DL D1 D2 D3 D4 NK SY EB CN EM SB EC FS GS RS US ",
    "SP !  \"  Nb DO %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  ",
    "At A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  <( // )> '> _  ",
    "'! a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  (! !! !) '? DT ",
    "0a 1a 2a 3a 4a 5a 6a 7a 8a 9a ,+ ;+ ?+ aM a+ a+.a+:b+ b+,p+    tm t+ t+,      tk tk,g+ g+,      ",
    "hk hk,x+ x+,d+    dk r+    z+    s+ s+,sn << >> sn,c+ .S :S ?S vv vl c+,dd dd,tj VL VV LD UL zH ",
    "e+ dl ur uh dh vr hh vh e+.e+,UR DR UH DH VR HH VH e+;i+ i+.i+,i+;f+ f+,q+ q+,k+.ul dr FB TB k+,",
    "   LB    l+ l+.l+;m+ m+,   n+ n+,   w+             H' --                         3+ 3+;   fS NS ",
  };

/* IBM869
   cp869
   869
   cp-gr
*/

static DOUBLE_TABLE table_109 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "            A%  .MNOBB9''9E%-MY%I%J*O%    U%V*CoW%2S3Sa%Pde%y%i%",
    "j*i3o%u%A*B*G*D*E*Z*Y*12H*I*<<>>.S:S?SvvvlK*L*M*N*VLVVLDULC*O*dl",
    "uruhdhvrhhvhP*R*URDRUHDHVRHHVHS*T*U*F*X*Q*W*a*b*g*uldrFBLBd*e*TB",
    "z*y*h*i*k*l*m*n*c*o*p*r*s**st*''--+-u*f*x*SEq*'%DG':w*v*u3w%fSNS",
  };

/* IBM870
   CP870
   ebcdic-cp-roece
   ebcdic-cp-yu
*/

static DOUBLE_TABLE table_110 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNS  a:  a'a(c<c,c'<(. < ( + ! & e'  e:u0i'  l<l'ss)>DO* ) ; '>",
    "- /   A:'\"A'  C<C,C'!!, % _ > ? '<E'  E:U0I'  L<L''!: NbAt' = \" ",
    "'(a b c d e f g h i s'n<d/y'r<  DGj k l m n o p q r l/n's<',';Cu",
    "a;'?s t u v w x y z S'N<D/Y'R<  .MA;z.  Z.SEPIz<z'Z<Z'N'S<':''*X",
    "(!A B C D E F G H I --o>o:r'o'o\"!)J K L M N O P Q R E<u\"u:t<u'e<",
    "//-:S T U V W X Y Z d<O>O:R'O'O\"0 1 2 3 4 5 6 7 8 9 D<U\"U:T<U'DT",
  };

/* IBM871
   CP871
   ebcdic-cp-is
*/

static DOUBLE_TABLE table_111 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:a!a'a?aac,n?th. < ( + ! & e'e>e:e!i'i>i:i!ssAEDO* ) ; O:",
    "- / A>A:A!A'A?AAC,N?BB, % _ > ? o/E'E>E:E!I'I>I:I!d-: NbD-' = \" ",
    "O/a b c d e f g h i <<>>'!y'(!+-DGj k l m n o p q r -a-o!)',)>Cu",
    "Myo:s t u v w x y z !I?IAtY'<(RgCtPdYe.MCoSEPI141234NO!!'-'://*X",
    "THA B C D E F G H I --o>'?o!o'o?aeJ K L M N O P Q R 1Su>u:u!u'y:",
    "''-:S T U V W X Y Z 2SO>'>O!O'O?0 1 2 3 4 5 6 7 8 9 3SU>U:U!U'DT",
  };

/* IBM880
   cp880
   EBCDIC-Cyrillic
*/

static DOUBLE_TABLE table_112 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP  d%g%io  dsiiyij%<(. < ( + ! & ljnjtskj  dz=\"N0D%)>DO* ) ; '>",
    "- / G%IO  DSIIYIJ%LJBB, % _ > ? NJTsKJ    DZjua=b=  : NbAt' = \" ",
    "c=a b c d e f g h i d=e=f=g=h=i=j=j k l m n o p q r k=l=m=n=o=p=",
    "ja  s t u v w x y z r=s=t=u=z%v=%'y=z=s%jescc%='JUA=B=C=D=E=F=G=",
    "  A B C D E F G H I H=I=J=K=L=M=  J K L M N O P Q R N=O=P=JAR=S=",
    "//CuS T U V W X Y Z T=U=Z%V=%\"Y=0 1 2 3 4 5 6 7 8 9 Z=S%JEScC%DT",
  };

/* IBM891
   cp891
*/

static DOUBLE_TABLE table_113 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    NULL,
    NULL,
    NULL,
    NULL,
  };

/* IBM903
   cp903
*/

static DOUBLE_TABLE table_114 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    NULL,
    NULL,
    NULL,
    NULL,
  };

/* IBM904
   cp904
   904
*/

static DOUBLE_TABLE table_115 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "Ct                                                              ",
    NULL,
    NULL,
    "                                                          NOBB  ",
  };

/* IBM905
   CP905
   ebcdic-cp-tr
*/

static DOUBLE_TABLE table_116 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP  a>a:a!a'  c.(!n?C,. < ( + ! & e'e>e:e!i'i>i:i!ssG(I.* ) ; '>",
    "- / A>A:A!A'  C.<(N?s,, % _ > ?   E'E>E:E!I'I>I:I!i.: O:S,' = U:",
    "'(a b c d e f g h i h/c>s>u(  !!DGj k l m n o p q r h>g>j>';  Cu",
    "Myo:s t u v w x y z H/C>S>U(  At.MPdz.!)Z.SE)>  12DOH>G>J>':''*X",
    "c,A B C D E F G H I --o>'?o!o'g.g(J K L M N O P Q R '!u>//u!u'  ",
    "u:-:S T U V W X Y Z 2SO>NbO!O'G.0 1 2 3 4 5 6 7 8 9 3SU>\" U!U'DT",
  };

/* IBM918
   CP918
   ebcdic-cp-ar2
*/

static DOUBLE_TABLE table_117 = 
  {
    "NU SH SX EX ET EQ AK BL BS HT LF VT FF CR SO SI DL D1 D2 D3 D4 NK SY EB CN EM SB EC FS GS RS US ",
    NULL,
    "SP NS ,+ ;+ ?+ aH a+ a+.   b+ <( .  <  (  +  !  &  b+,p+    tm t+ t+,      tk )> DO *  )  ;  '> ",
    "-  /  tk,g+ g+,      hk hk,x+ '! ,  %  _  >  ?  0a 1a 2a 3a 4a 5a 6a 7a 8a 9a :  Nb At '  =  \"  ",
    "x+,a  b  c  d  e  f  g  h  i  d+    dk r+    z+    j  k  l  m  n  o  p  q  r  s+ s+,sn sn,c+ c+,",
    "dd '? s  t  u  v  w  x  y  z  dd,tj zH e+ e+.e+,e+;i+ i+.i+,i+;f+ f+,q+ q+,k+ k+,!!       l+ l+.",
    "(! A  B  C  D  E  F  G  H  I  --    m+ m+,   n+ !) J  K  L  M  N  O  P  Q  R  n+,   w+          ",
    "//    S  T  U  V  W  X  Y  Z  H'                0  1  2  3  4  5  6  7  8  9           3+ 3+;DT ",
  };

/* IBM1026
   CP1026
*/

static DOUBLE_TABLE table_118 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SPNSa>a:a!a'a?aa(!n?C,. < ( + ! & e'e>e:e!i'i>i:i!ssG(I.* ) ; '>",
    "- / A>A:A!A'A?AA<(N?s,, % _ > ? o/E'E>E:E!I'I>I:I!i.: O:S,' = U:",
    "O/a b c d e f g h i <<>>!)'!BB+-DGj k l m n o p q r -a-oae';AECu",
    "Myo:s t u v w x y z !I?I)>DOAtRgCtPdYe.MCoSEPI141234NO!!-M':''*X",
    "c,A B C D E F G H I --o>'?o!o'o?g(J K L M N O P Q R 1Su>//u!u'y:",
    "u:-:S T U V W X Y Z 2SO>NbO!O'O?0 1 2 3 4 5 6 7 8 9 3SU>\" U!U'DT",
  };

/* EBCDIC-AT-DE
*/

static DOUBLE_TABLE table_119 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  A:. < ( + ! &                   U:DO* ) ; '>",
    "- /                 o:, % _ > ?                   '!: NbSE' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  sss t u v w x y z                                             ",
    "a:A B C D E F G H I             u:J K L M N O P Q R             ",
    "O:  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-AT-DE-A
*/

static DOUBLE_TABLE table_120 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  o:. < ( + !!&                   u:U:* ) ; NO",
    "- /                 ss, % _ > ?                     : A:O:' = a:",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "    s t u v w x y z                                             ",
    "  A B C D E F G H I               J K L M N O P Q R             ",
    "    S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-CA-FR
*/

static DOUBLE_TABLE table_121 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP  a>          c,  a!. < ( + ! &   e>e:    i>i:    ''DO* ) ; '>",
    "- / A>  A!      C,  u!, % _ > ?   E'E>E:  I>I:    '!: NbAt' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  ':s t u v w x y z                                             ",
    "e'A B C D E F G H I   o>        e!J K L M N O P Q R   u>u:      ",
    "',  S T U V W X Y Z   O>        0 1 2 3 4 5 6 7 8 9   U>U:U!  DT",
  };

/* EBCDIC-DK-NO
*/

static DOUBLE_TABLE table_122 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  Nb. < ( + ! &                   CuAA* ) ; '>",
    "- /                 o/, % _ > ?                   '!: AEO/' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  u:s t u v w x y z                                             ",
    "aeA B C D E F G H I             aaJ K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-DK-NO-A
*/

static DOUBLE_TABLE table_123 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  o/. < ( + !!&                   aaAA* ) ; NO",
    "- /                 BB, % _ > ?                     : AEO/' = ae",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "    s t u v w x y z                                             ",
    "  A B C D E F G H I               J K L M N O P Q R             ",
    "    S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-FI-SE
*/

static DOUBLE_TABLE table_124 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  SE. < ( + ! &                   CuAA* ) ; '>",
    "- /                 o:, % _ > ?                   e': A:O:' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  u:s t u v w x y z                                             ",
    "a:A B C D E F G H I             aaJ K L M N O P Q R             ",
    "E'  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-FI-SE-A
*/

static DOUBLE_TABLE table_125 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  o:. < ( + !!&                   aaAA* ) ; NO",
    "- /                 BB, % _ > ?                     : A:O:' = a:",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "    s t u v w x y z                                             ",
    "  A B C D E F G H I               J K L M N O P Q R             ",
    "    S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-FR
*/

static DOUBLE_TABLE table_126 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  DG. < ( + ! &                   SEDO* ) ; '>",
    "- /                 u!, % _ > ?                   '!: Pda!' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  ':s t u v w x y z                                             ",
    "e'A B C D E F G H I             e!J K L M N O P Q R             ",
    "c,  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-IT
*/

static DOUBLE_TABLE table_127 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  DG. < ( + ! &                   e'DO* ) ; '>",
    "- /                 o!, % _ > ?                   u!: PdSE' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  i!s t u v w x y z                                             ",
    "a!A B C D E F G H I             e!J K L M N O P Q R             ",
    "c,  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-PT
*/

static DOUBLE_TABLE table_128 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  <(. < ( + ! &                   )>DO* ) ; '>",
    "- /                 o?, % _ > ?                   '!: A?O?' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  c,s t u v w x y z                                             ",
    "a?A B C D E F G H I             ''J K L M N O P Q R             ",
    "C,  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-ES
*/

static DOUBLE_TABLE table_129 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  Ct. < ( + !!&                   ! Pt* ) ; NO",
    "- /                 n?, % _ > ?                   '!: N?At' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  ':s t u v w x y z                                             ",
    "(!A B C D E F G H I             !)J K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-ES-A
*/

static DOUBLE_TABLE table_130 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  Ct. < ( + !!&                   ! Pt* ) ; NO",
    "- /                 BB, % _ > ?                     : N?At' = n?",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "    s t u v w x y z                                             ",
    "  A B C D E F G H I               J K L M N O P Q R             ",
    "    S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-ES-S
*/

static DOUBLE_TABLE table_131 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  Ct. < ( + !!&                   ! DO* ) ; NO",
    "- /                 n?, % _ > ?                   '!: N?At' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  ':s t u v w x y z                                             ",
    "(!A B C D E F G H I             !)J K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-UK
*/

static DOUBLE_TABLE table_132 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  DO. < ( + !!&                   ! Pd* ) ; NO",
    "- /                 BB, % _ > ?                   '!: NbAt' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  '-s t u v w x y z                                             ",
    "(!A B C D E F G H I             !)J K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

/* EBCDIC-US
*/

static DOUBLE_TABLE table_133 = 
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    NULL,
    "SP                  Ct. < ( + !!&                   ! DO* ) ; NO",
    "- /                 BB, % _ > ?                   '!: NbAt' = \" ",
    "  a b c d e f g h i               j k l m n o p q r             ",
    "  '?s t u v w x y z                                             ",
    "(!A B C D E F G H I             !)J K L M N O P Q R             ",
    "//  S T U V W X Y Z             0 1 2 3 4 5 6 7 8 9           DT",
  };

void
module_charset2 (void)
{
  declare_double_step (&table_80, "IBM038", 2);
  declare_double_step (&table_81, "IBM273", 2);
  declare_double_step (&table_82, "IBM274", 2);
  declare_double_step (&table_83, "IBM275", 2);
  declare_double_step (&table_84, "IBM277", 2);
  declare_double_step (&table_85, "IBM278", 2);
  declare_double_step (&table_86, "IBM280", 2);
  declare_double_step (&table_87, "IBM281", 2);
  declare_double_step (&table_88, "IBM284", 2);
  declare_double_step (&table_89, "IBM285", 2);
  declare_double_step (&table_90, "IBM290", 2);
  declare_double_step (&table_91, "IBM297", 2);
  declare_double_step (&table_92, "IBM420", 3);
  declare_double_step (&table_93, "IBM423", 2);
  declare_double_step (&table_94, "IBM424", 2);
  declare_double_step (&table_95, "IBM437", 2);
  declare_double_step (&table_96, "IBM500", 2);
  declare_double_step (&table_97, "IBM850", 2);
  declare_double_step (&table_98, "IBM851", 2);
  declare_double_step (&table_99, "IBM852", 2);
  declare_double_step (&table_100, "IBM855", 2);
  declare_double_step (&table_101, "IBM857", 2);
  declare_double_step (&table_102, "IBM860", 2);
  declare_double_step (&table_103, "IBM861", 2);
  declare_double_step (&table_104, "IBM862", 2);
  declare_double_step (&table_105, "IBM863", 2);
  declare_double_step (&table_106, "IBM864", 3);
  declare_double_step (&table_107, "IBM865", 2);
  declare_double_step (&table_108, "IBM868", 3);
  declare_double_step (&table_109, "IBM869", 2);
  declare_double_step (&table_110, "IBM870", 2);
  declare_double_step (&table_111, "IBM871", 2);
  declare_double_step (&table_112, "IBM880", 2);
  declare_double_step (&table_113, "IBM891", 2);
  declare_double_step (&table_114, "IBM903", 2);
  declare_double_step (&table_115, "IBM904", 2);
  declare_double_step (&table_116, "IBM905", 2);
  declare_double_step (&table_117, "IBM918", 3);
  declare_double_step (&table_118, "IBM1026", 2);
  declare_double_step (&table_119, "EBCDIC-AT-DE", 2);
  declare_double_step (&table_120, "EBCDIC-AT-DE-A", 2);
  declare_double_step (&table_121, "EBCDIC-CA-FR", 2);
  declare_double_step (&table_122, "EBCDIC-DK-NO", 2);
  declare_double_step (&table_123, "EBCDIC-DK-NO-A", 2);
  declare_double_step (&table_124, "EBCDIC-FI-SE", 2);
  declare_double_step (&table_125, "EBCDIC-FI-SE-A", 2);
  declare_double_step (&table_126, "EBCDIC-FR", 2);
  declare_double_step (&table_127, "EBCDIC-IT", 2);
  declare_double_step (&table_128, "EBCDIC-PT", 2);
  declare_double_step (&table_129, "EBCDIC-ES", 2);
  declare_double_step (&table_130, "EBCDIC-ES-A", 2);
  declare_double_step (&table_131, "EBCDIC-ES-S", 2);
  declare_double_step (&table_132, "EBCDIC-UK", 2);
  declare_double_step (&table_133, "EBCDIC-US", 2);

  declare_alias ("CP273", "IBM273");
  declare_alias ("EBCDIC-BE", "IBM274");
  declare_alias ("CP274", "IBM274");
  declare_alias ("EBCDIC-BR", "IBM275");
  declare_alias ("cp275", "IBM275");
  declare_alias ("EBCDIC-CP-DK", "IBM277");
  declare_alias ("EBCDIC-CP-NO", "IBM277");
  declare_alias ("CP278", "IBM278");
  declare_alias ("ebcdic-cp-fi", "IBM278");
  declare_alias ("ebcdic-cp-se", "IBM278");
  declare_alias ("CP280", "IBM280");
  declare_alias ("ebcdic-cp-it", "IBM280");
  declare_alias ("EBCDIC-JP-E", "IBM281");
  declare_alias ("cp281", "IBM281");
  declare_alias ("CP284", "IBM284");
  declare_alias ("ebcdic-cp-es", "IBM284");
  declare_alias ("CP285", "IBM285");
  declare_alias ("ebcdic-cp-gb", "IBM285");
  declare_alias ("cp290", "IBM290");
  declare_alias ("EBCDIC-JP-kana", "IBM290");
  declare_alias ("cp297", "IBM297");
  declare_alias ("ebcdic-cp-fr", "IBM297");
  declare_alias ("cp420", "IBM420");
  declare_alias ("ebcdic-cp-ar1", "IBM420");
  declare_alias ("cp423", "IBM423");
  declare_alias ("ebcdic-cp-gr", "IBM423");
  declare_alias ("cp424", "IBM424");
  declare_alias ("ebcdic-cp-he", "IBM424");
  declare_alias ("cp437", "IBM437");
  declare_alias ("437", "IBM437");
  declare_alias ("CP500", "IBM500");
  declare_alias ("ebcdic-cp-be", "IBM500");
  declare_alias ("ebcdic-cp-ch", "IBM500");
  declare_alias ("cp850", "IBM850");
  declare_alias ("850", "IBM850");
  declare_alias ("cp851", "IBM851");
  declare_alias ("851", "IBM851");
  declare_alias ("cp852", "IBM852");
  declare_alias ("852", "IBM852");
  declare_alias ("cp855", "IBM855");
  declare_alias ("855", "IBM855");
  declare_alias ("cp857", "IBM857");
  declare_alias ("857", "IBM857");
  declare_alias ("cp860", "IBM860");
  declare_alias ("860", "IBM860");
  declare_alias ("cp861", "IBM861");
  declare_alias ("861", "IBM861");
  declare_alias ("cp-is", "IBM861");
  declare_alias ("cp862", "IBM862");
  declare_alias ("862", "IBM862");
  declare_alias ("cp863", "IBM863");
  declare_alias ("863", "IBM863");
  declare_alias ("cp864", "IBM864");
  declare_alias ("cp865", "IBM865");
  declare_alias ("865", "IBM865");
  declare_alias ("CP868", "IBM868");
  declare_alias ("cp-ar", "IBM868");
  declare_alias ("cp869", "IBM869");
  declare_alias ("869", "IBM869");
  declare_alias ("cp-gr", "IBM869");
  declare_alias ("CP870", "IBM870");
  declare_alias ("ebcdic-cp-roece", "IBM870");
  declare_alias ("ebcdic-cp-yu", "IBM870");
  declare_alias ("CP871", "IBM871");
  declare_alias ("ebcdic-cp-is", "IBM871");
  declare_alias ("cp880", "IBM880");
  declare_alias ("EBCDIC-Cyrillic", "IBM880");
  declare_alias ("cp891", "IBM891");
  declare_alias ("cp903", "IBM903");
  declare_alias ("cp904", "IBM904");
  declare_alias ("904", "IBM904");
  declare_alias ("CP905", "IBM905");
  declare_alias ("ebcdic-cp-tr", "IBM905");
  declare_alias ("CP918", "IBM918");
  declare_alias ("ebcdic-cp-ar2", "IBM918");
  declare_alias ("CP1026", "IBM1026");
}
