/* Copyright (C) 1990, 1993 Free Software Foundation, Inc.

   This file is part of GNU ISPELL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* compute the frequencies of character pairs in a file
   then write a list of characters used, plus a sorted list
   of frequencies
 
   this program needs to run on 80286's, so it doesn't use
   any individual data structure larger than 64k. */


#ifdef __MSDOS__
#undef __STDC__          /* I need not ANSI function to emulate pipes */
#include <stdlib.h>
#include <stdio.h>
#include <io.h>                       /* access () */
#include <process.h>                  /* spawnl () */
/* #include "msdos.h" */
#define __STDC__ 1
#endif

#include <stdio.h>
#include <ctype.h>
#include "charset.h"

#include "ispell.h"                    /* xcalloc () */


#include "tailor.h"
#ifdef __MSDOS__
#include <stdlib.h>
#endif

/* this array contains letters to use when generating near misses */
char near_miss_letters[256];
int nnear_miss_letters;

/* this array has 1 for any character that is in near_miss_letters */
char near_map[256];

long *table[256];
char used[256];

int
main ()
{
  int c1, c2;
  long count;
  int i, j;
  FILE *out;

#ifdef NO_PIPE
  char * tempfile = mktemp ( "frXXXXXX" ) ;
  if ( ( out = fopen ( tempfile , "w" ) ) == NULL )
    {
      fprintf (stderr, "can't make temporary file to sort\n");
      exit (1);
    }
#else
  if ((out = popen ("sort -nr", "w")) == NULL)
    {
      fprintf (stderr, "can't make pipe to sort\n");
      exit (1);
    }
#endif

  for (i = 0; i < 256; i++)
    table[i] = (long *) xcalloc (256, sizeof (long));

  c1 = 0;
  while (c1 == 0)
    {
      c1 = getchar ();
      if (c1 == EOF)
	{
	  fprintf (stderr, "no input\n");
	  exit (1);
	}
      c1 = charset[c1].lowercase;
    }
  used[c1] = 1;

  while ((c2 = getchar ()) != EOF)
    {
      c2 = charset[c2].lowercase;
      if (c2 == 0)
	continue;
      used[c2] = 1;
      table[c1][c2]++;
      c1 = c2;
    }

  /* a big "count" so this line will be at the top of the
	 * sorted output
	 */
  fprintf (out, "30000 ");
  for (c1 = 0; c1 < 256; c1++)
    if (used[c1])
      putc (c1, out);
  putc ('\n', out);

  for (i = 0; i < 256; i++)
    {
      if (used[i] == 0)
	continue;
      for (j = 0; j < 256; j++)
	{
	  if (used[j] == 0)
	    continue;
	  count = table[i][j];
	  if (count)
#ifdef __MSDOS__        /*  no UNIX sort -n */
	    fprintf (out, "%5ld %c%c\n", count, i, j);
#else
	    fprintf (out, "%ld %c%c\n", count, i, j);
#endif /* __MSDOS__ */
	}
    }

#ifdef NO_PIPE
  if ( fclose ( out ) )
    {
      (void) fprintf (stderr, "can't exec 'sort' program. tempfile failed \n");
      exit (1);
    }
  out = fopen ( tempfile , "rt" ) ;
  close ( 0 ) ;  /* 0 = STD_IN */ ;
  dup ( fileno ( out ) ) ;
  if ( spawnlp ( P_WAIT ,    "sort.exe"  , "sort.exe", "/R" , NULL ) )
          perror ( "freq" ) ;
  fclose ( out ) ;
  unlink ( tempfile ) ;
#else /* YES PIPE */
  pclose (out);
#endif /* PIPE */

  return 0;
}
