/* swing.h - main header to the Swing library
//  project  LSW
//  version  V1.12F
//  design   24 nov 1999
//  doc      libswing.doc
//  history  24 nov 1999 thru march 2000
//                       Designed on the 24th of nov, the engine model was
//                       written on and after jan 31st 2000. The library was
//                       in continuous progress as of that point, and in use
//                       since december 1999, as a number of beta versions.
//                       Since, it has been revised, based on the engine
//                       model, when the engine model was completed.
//           24 mar 2000 First freeware release of the first revision of
//                       this library: version 1.1.0 freeware. The revision
//                       includes support for some of my other libraries,
//                       coded into this one, but those libraries are not
//                       required for the operation of this one.
//           12 jun 2000 Added duelprinterror() and had the housekeeping
//                       methods report errors and warnings to stderr in
//                       stead of stdout.
//           07 aug 2000 minor changes in documentation and support for VPL3
//  author   Dlanor Blytkerchan <dlanor@dds.nl>
//  comments If you use this library, ALWAYS initialise it with the
//           initSwing() method!
//           Designed mainly for use with DJGPP - will be ported to Linux
//  function This library is intended to assist any programmer by providing
//           common methods in an easy-to-use fashion.
*/
#ifndef LSW1_SWING_H
#define LSW1_SWING_H
#ifdef __cplusplus
extern "C" {
#endif
/*****************************************************************Includes*/
#include <unistd.h>
/******************************************************************Defines*/
#ifndef dword
  #define dword unsigned long
#endif // word
#ifndef word
  #define word unsigned short
#endif // word
#ifndef byte
  #define byte unsigned char
#endif // byte
#ifndef bool
  #define bool byte
#endif // bool
#ifndef false
  #define false 0
#endif // false
#ifndef true
  #define true !false
#endif

#define swing_name       "RLSystems Swing Library"
#define swing_shortName  "Swing"
#define swing_version    "V1.12F"
#define swing_hexVersion 0x0100
#define swing_author     "Dlanor Blytkerchan <dlanor@dds.nl>"
/*****************************************************Library-only methods*/
bool initSwing(void);
/**************************************************************************/
#ifdef __cplusplus
}
#endif
#endif // LSW1_SWING_H
/*******************Rest of Includes (for application including this file)*/
#if (defined LSW1_dateAndTime) || (defined LSW1_All)
  #include <swing/dateAndTime.h>
#endif // LSW1_dateAndTime
#if (defined LSW1_fileIO) || (defined LSW1_All)
  #include <swing/fileIO.h>
#endif // LSW1_fileIO
#if (defined LSW1_houseKeeping) || (defined LSW1_All)
  #include <swing/houseKeeping.h>
#endif // LSW1_houseKeeping
#if (defined LSW1_strings) || (defined LSW1_All)
  #include <swing/strings.h>
#endif // LSW1_strings
#if (defined LSW1_userIO) || (defined LSW1_All)
  #include <swing/userIO.h>
#endif // LSW1_userIO
#if (defined LSW1_memIO) || (defined LSW1_All)
  #include <swing/memIO.h>
#endif // LSW1_memIO
/**************************************************************************/

