/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Mathematical toolbox
   ErrorNos  : 4100..4199
   File      : Include/ToolBox/Math/Matrix.H
   Author    : Eric NICOLAS
   Overview  : Variable size matrix arithmetics
   UpDate    : Mar 03, 1996

** Copyright (C) 1993-1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLBOX_MATH_MATRIX_H_
#define _TOOLBOX_MATH_MATRIX_H_

class TMatrix;

//

#define erMatrix_OutOfSize     4100
#define erMatrix_MixingSizes   4101
#define erMatrix_VectorSize    4102
#define erMatrix_Rectangular   4103
#define erMatrix_Singularity   4104

extern int MatrixDefaultSizeI;
extern int MatrixDefaultSizeJ;

// --- Object TMatrix

// Rem : Rows    are defined by the first index (I)
//       Columns are defined by the second index (J)

class TMatrix
{ // --- Datas
  protected:
    int       SizeI,SizeJ;
    complex  *Tabl;
  // --- Functions
  public:
    // Constructors / Destructor
    TMatrix(int eSizeI=MatrixDefaultSizeI, int eSizeJ=MatrixDefaultSizeJ);
    TMatrix(TMatrix& M);
    virtual ~TMatrix();
             void Reset(void);
  // Using vectors
    TMatrix  operator=(TMatrix& M);
    complex& operator()(int I, int J);
  // Operations on matrixes
    TMatrix  operator+(TMatrix& M);
    TMatrix  operator+=(TMatrix& M);
    TMatrix  operator-(TMatrix& M);
    TMatrix  operator-=(TMatrix& M);
    TMatrix  operator*(TMatrix& M);
    TMatrix  operator*=(TMatrix& M);
    friend   TMatrix  T(TMatrix& M);
    friend   complex  Det(TMatrix& M);
    friend   TMatrix  Inv(TMatrix& M);
/*  TMatrix  operator/(TMatrix& V);
  TMatrix  operator/=(TMatrix& V);*/
  // Operations between matrixes and complexes
    friend   TMatrix  operator*(TMatrix& M, complex  C);
    friend   TMatrix  operator*(complex  C, TMatrix& M);
             TMatrix  operator*=(complex C);
    friend   TMatrix  operator/(TMatrix& M, complex  C);
    friend   TMatrix  operator/(complex  C, TMatrix& M);
             TMatrix  operator/=(complex C);
  // Operation between matrix and vector
             TVector  operator*(TVector& V);
             TVector  SolveSystem(TVector& Constant);
  // Acces to Matrix values with vectors
    void SetColumn(int J, TVector& V);
    void SetRow(int I, TVector& V);
    TVector Column(int J);
    TVector Row(int I);
  // Operations on Rows and Columns
    void ExchangeRows(int I1, int I2);              // Row(I1) <-> Row(I2)
    void ExchangeColumns(int J1, int J2);           // Column(I1) <-> Column(I2)
    void MultAddRow(int I1, int I2, complex C);     // Row(I2)=Row(I2)+C*Row(I1)
    void MultAddColumn(int J1, int J2, complex C);  // Column(J2=Column(J2)+C*Column(J1)
    void DivideRow(int I, complex C);               // Row(I)=Row(I)/C
    void DivideColumn(int J, complex C);            // Column(I)=Column(I)/C
  private:
    friend boolean Pivot(TMatrix& M, TMatrix *I, TVector *V, int ReferenceRow);
};

// Inline functions

inline complex &TMatrix::operator()(int I, int J)
{ if (I<0)      { Error=erMatrix_OutOfSize; I=0;       }
  if (I>=SizeI) { Error=erMatrix_OutOfSize; I=SizeI-1; }
  if (J<0)      { Error=erMatrix_OutOfSize; J=0;       }
  if (J>=SizeJ) { Error=erMatrix_OutOfSize; J=SizeJ-1; }
  return Tabl[J+I*SizeJ];
}

#endif // _TOOLBOX_MATH_MATRIX_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   03/03/96 :EN: First History remark. Copying code V2.00->V2.10
** ------------------------------------------------------------------------*/
