/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> WINDOW.H
 -> Window class for the base window type and functionality.
*/

#ifndef _window_h
#define _window_h

#include <graphics.h>
#include <tws/events.h>
#include <tws/accel.h>
#include <tws/system.h>

#define FWIDTH 2
#define CORNER 22       // The width of the frame and length of the corner.
#define BORDER_WIDTH          (FWIDTH)
#define CAPTION_HEIGHT        (FWIDTH*3+SysFont->height)
#define SIZING_BORDER_WIDTH   (FWIDTH*2+3)
								// Helpful constants giving width and height of
								// standard parts of a window. Useful for positioning
								// objects in constructors when the client area
								// is yet to be defined.

#define WA_SAVEAREA     0x01              // Saves the area behind.
#define WA_VISABLE      0x02              // Is visible.
#define WA_BORDER       0x04              // Has a border.
#define WA_SIZEABLE     0x08              // Sizeable borders.
#define WA_CAPTION      0x10              // Has a caption in a title bar.
#define WA_MAXBOX       0x20              // A maximize window box.
#define WA_SYSBOX       0x40              // A system menu box.
#define WA_TABSTOP      0x80              // Allows tab key to change focus to.
#define WA_CLIENT       0x100             // Client window, clipped by client area.
#define WA_DEPENDANT    0x200             // A window with buffer dependant on parent.
#define WA_TOP_WINDOW   0x400             // The window is the top window.

#define ID_CANCEL    0
#define ID_OK        1
#define ID_HELP      3
#define ID_MAXBOX    99998
#define ID_SYSBOX    99999


#define DOUBLE_CLICK_SPEED    450

typedef int ControlID;

class IconButton;

class Window {
		friend class TabWin;
	public:
		Window(Window *Parent,const char *Title,int X1,int Y1,int X2,int Y2,int style=WA_CLIENT | WA_VISABLE | WA_BORDER);
		virtual ~Window();

		inline void RefreshWindow(Window *exclude=NULL)// Refreshes the onscreen window.
			{ RefreshWindow(absx,absy,absx+w-1,absy+h-1,exclude); }
		void Paint();                                // Paints the window and all children.
		virtual BOOL ProcessEvent(const event *ev);  // Returns TRUE if event has been processed.
		inline ViewBuffer *GetBuffer() 
			{ return wnd; }                           // Returns the graphics buffer.
		inline ViewBuffer *GetClientBuffer()
			{ return SubBuffer(wnd,cx1,cy1,cx2,cy2); }// Returns the buffer to the client area. 
		inline ViewBuffer *GetSubBuffer(int x1,int y1,int x2,int y2)
			{ return SubBuffer(wnd,x1,y1,x2,y2); }
		void SetTitle(const char *NewTitle);
		virtual void Select();
		void AddAccelerator(BYTE c,Window *wnd);// Adds an accelerator entry for wnd.
		void AddAccelerator(BYTE k,BYTE s,Window *wnd);
		void RemoveAccelerators(Window *wnd);  // Removes all accelerator entries for wnd.
		inline int GetHeight()
			{ return h; }
		inline int GetWidth()
			{ return w; }
		inline Window *GetNext()
			{ return next; }
		inline void SetNext(Window *wnd)
			{ next=wnd; }
		virtual void SetFocus(Window *wnd);
		inline void SetTabStop()
			{ isTabStop=TRUE; }
		inline int isFocus()
			{ return parent?(parent->focus==this):FALSE;}
		inline int isDocument()
			{ return isDoc; }
		inline void ShiftX(int d)
			{ absx+=d;x1+=d;x2+=d; }
		inline void ShiftY(int d)
			{ absy+=d;y1+=d;y2+=d; }
		inline void SetBackgroundColour(int c)
			{ bcol=c; }
		inline int GetBackgroundColour()
			{ return bcol; }
		
	protected:
		virtual void PaintWindow(int x1,int y1,int x2,int y2);
		void RefreshWindow(int x1,int y1,int x2,int y2,Window *exclude=NULL);    
																	// Refreshes the onscreen window.
		void RefreshWindowIntoBuffer(ViewBuffer *buf,int x,int y,Window *exclude=NULL);    
												// Refreshes the onscreen window into a buffer.
		virtual BOOL DoEvents(const event *ev);
		inline BOOL isIn(const event *ev) 
			{ return (BOOL)(ev->p1>=absx && ev->p1<absx+w && ev->p2>=absy && ev->p2<absy+h); }
		void SaveArea();
		void RestoreArea();
		virtual void Move(int dx,int dy);
		virtual void Resize(int x1,int y1,int x2,int y2);
		void SetClientArea(int x1,int y1,int x2,int y2);
		inline void CatchMouse()
		{
			ws.CatchMouseFocus(this);
			MouseFocus=TRUE;
		}
		inline void CatchAllMouseEvents()
		{
			ws.CatchMouseFocus(this);
			isCatchAllMouse=TRUE;
			MouseFocus=TRUE;
		}
		inline void ReleaseMouse()
		{
			ws.ReleaseMouseFocus();
			isCatchAllMouse=FALSE;
			MouseFocus=FALSE;
		}
		inline void CatchKeys()
			{ ws.CatchKeyFocus(this); }
		inline void ReleaseKeys()
			{ ws.ReleaseKeyFocus(); }
		inline Window *GetParent()
			{ return parent; }
		virtual void AddChild(Window *wnd);
		virtual void DeleteChild(Window *wnd);
		virtual void Focus();
		virtual void UnFocus();
		void AddABSCorner(int x,int y);

		int x1,y1,x2,y2;           // The position in the parent window.
		int w,h;                   // The width and height.
		int cx1,cy1,cx2,cy2;       // The client area of the window.
		int absx,absy;             // Actual screen coords of top-left.
		int minw,minh;             // Minimum width and height of the window.
		ViewBuffer *wnd,*und;      // The window and the area under.
		DWORD style;               // The style of the window.
		Window *parent,*next,*children;     
		Window *focus;             // The child window with focus.
		int bcol;                  // The background colour.
		BOOL isMoving,isMaximized,isSetup,isTabStop,isCatchAllMouse,isAlreadyMouseFocus;
		BOOL MouseFocus,CanHaveFocus,wasInside,isDoc;
		int isSizing,sx1,sy1,sx2,sy2,dx,dy; // Sizing data.
		char *Title;
		Accelerator *AccelTable;   // Table of accelerator keys.
		IconButton *MaxBox,*SysBox;
};

#endif
