/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> EVENTQUE.H
 -> Mouse and keyboard eventqueue functions.
*/

#ifndef _eventque_h
#define _eventque_h

#include <types.h>

#define EVT_MOVE           0x01
#define EVT_LEFT_DOWN      0x02
#define EVT_LEFT_UP        0x04
#define EVT_RIGHT_DOWN     0x08
#define EVT_RIGHT_UP       0x10
#define EVT_MIDDLE_DOWN    0x20
#define EVT_MIDDLE_UP      0x40
#define EVT_KEYPRESS       0x80

#define KBS_RIGHT_SHIFT    0x1001
#define KBS_LEFT_SHIFT     0x2002
#define KBS_SHIFT          (KBS_RIGHT_SHIFT | KBS_LEFT_SHIFT)
#define KBS_CTRL           0x04
#define KBS_ALT            0x08
#define KBS_SCROLL_LOCKED  0x10
#define KBS_NUM_LOCKED     0x20
#define KBS_CAPS_LOCKED    0x40
#define KBS_INSERT_LOCKED  0x80
#define KBS_LEFT_CTRL      0x100
#define KBS_LEFT_ALT       0x200
#define KBS_RIGHT_CTRL     0x400
#define KBS_RIGHT_ALT      0x800
#define KBS_CAPS_DOWN      0x4000
#define KBS_SYS_RQ_DOWN    0x8000

#define MBS_LEFT_BUTTON    1
#define MBS_RIGHT_BUTTON   2
#define MBS_MIDDLE_BUTTON  4


typedef struct sys_evt {
   BYTE type;
   WORD kbstat;
   BYTE buttons;
   DWORD time;
   WORD xpos;
   WORD ypos;
   BYTE scancode;
   BYTE keycode;
   struct sys_evt *next;
} SYSTEM_EVENT;

typedef struct {
   WORD limx,limy;             /* Mouse screen position limits */
   SWORD mousex,mousey;        /* Mouse position */
   BYTE speedx,speedy;         /* Speed in mickeys/pixel */
   SYSTEM_EVENT *start;
   SYSTEM_EVENT *end;
} SYSTEM_QUEUE;

#ifdef __cplusplus
extern "C" {
#endif

DWORD GetTicks();
void InitSystemEventQueue(int limx,int limy);
void DeInitSystemEventQueue();
void SetMouseSpeed(int x,int y);
void SetMousePosition(int x,int y);
SYSTEM_EVENT *GetNextSystemEvent();

#ifdef __cplusplus
}
#endif


#endif

