/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcsncmp.c,v 1.1 1996/07/09 10:05:37 jack Exp $ */

#include <wchar.h>

int
wcsncmp (const wchar_t *ws1, const wchar_t *ws2, size_t n)
{
  int c1, c2;

  while (n > 0)
    {
      if (*ws1 != *ws2++)
	{
	  c1 = (int) ws1[0];
	  c2 = (int) ws2[-1];
	  return c1 - c2;
	}
      else if (*ws1++ == 0)
	break;
      n--;
    }

  return 0;
}
