// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/WorldBuilder.H>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <Lib3d/Light.H>
#include <iostream.h>


WorldBuilder::WorldBuilder()
{
}

WorldBuilder::~WorldBuilder()
{
}


World *
WorldBuilder::readNff(istream &in)
{
    World *world = new World;
    Camera *camera = new Camera( *world );	

    Light *light;
    ModelBuilder ob;
    float near, far, angle;
    Vector3 from, at, up;
    Vector3 colour;
    float Kd, Ka, c1, c2;
    bool receivedMaterial = false;
    
    char keyword[80];

    char c;

    ob.startModel();
    ob.calculatePolygonNormals();
    // ob.setColourfulMode(); receivedMaterial = true;

    while (in.get(c)) {
	// debug() << "Key char: <" << c << ">" << endlog;
	switch (c) {
	case 'v':
	    in.ignore(1000, '\n');
	    while (keyword[0] != 'r' &&
		   in.getline(keyword, sizeof(keyword), ' ')) {

		// debug() << "View Keyword: <" << keyword << ">" << endlog;
		switch(keyword[0]) {
		case 'f':   
		    in >> from.v[0] >> from.v[1] >> from.v[2];
		    break;

		case 'a':
		    if (keyword[1] == 't') {
			in >> at.v[0] >> at.v[1] >> at.v[2];
		    } else if (keyword[1] == 'n') {
			in >> angle;
		    }
		    break;

		case 'u': 
		    in >> up.v[0] >> up.v[1] >> up.v[2];
		    break;

		case 'h': 
		    in >> near;
		    break;

		case 'y': 
		    in >> far;
		    break;
		    
		case 'r': 
		    break;

		default:
		    debug() << "Unrecognized view field: " << keyword << endlog;
		    delete world;
		    return 0;
		}
		in.ignore(1000, '\n');
	    }
	    camera->setLookAt(from, at, up);
	    camera->setParameters(near, far, angle, 1.0);
	    break;

	case 'f':
	    in >> colour.v[R] >> colour.v[G] >> colour.v[B]
	       >> Kd >> Ka >> c1 >> c2;
	    if (!receivedMaterial) {
		ob.addMaterial( colour, Kd, Ka, c1, c2, 0 );
	    }
	    receivedMaterial = true;
	    break;

	case 'p':
	    in.ignore(1000, '\n');
	    uint vnum[3];
	    for (int i = 0 ; i < 3 && in ; i++) {
		Vector3 v, n;
		in >> v.v[X] >> v.v[Y] >> v.v[Z] 
		   >> n.v[X] >> n.v[Y] >> n.v[Z];

		vnum[i] = ob.addVertex(v);

	    }
	    ob.addPolygon(3, vnum);
	    break;

	case 'l':
	    // Treat lights as directional, directed from the specified
	    // position towards the origin.

	    in >> at.v[X] >> at.v[Y] >> at.v[Z] 
	       >> colour.v[R] >> colour.v[G] >> colour.v[B];
	    at.scale(-1);

	    light = new Light( *world );
	    light->setParameters( colour, colour, at );
	    world->registerLight( *light );
	    break;

	case 'b':
	    debug() << "Ignoring background colour" << endlog;
	    break;

	default:
	    debug() << "Unrecognized nff field: " << c << endlog;
	    delete world;
	    return 0;
	}
	in.ignore(1000, '\n');
    }


    world->setActiveCamera( *camera );
    Model *model = ob.endModel();
    world->adopt( model );
    debug() << "Created object: " << *model << endlog;

    return world;
}










