// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/Light.H>
#include <Lib3d/Matrix.H>
#include <Lib3d/Vector.H>

Light::Light( Node &parent )
    : Node( parent ),
      nextLight( 0 )
{
}

Light::~Light()
{
}

// inefficient when we have a moving camera.  fix by meeting in world
// space rather than the cvv.  
void
Light::recalculateTransforms( const Matrix34 &parentToCvv )
{
    Node::recalculateTransforms( parentToCvv );

    Matrix34 t1;
    Matrix34 t2;
    t1.invert(objectToCvv);	// expensive
    t2.transpose(t1);
    cvvPov.mul( t2, pov );
}

void 
Light::setParameters(Vector3 amb,
		     Vector3 dif,
		     Vector3 direction)
{
    ambient.assign(amb);
    diffuse.assign(dif);
    pov.assign(direction);
}









