/**
 * $Id: cube.cc,v 1.2 1996/08/31 07:04:00 keithw Exp $
 * 
 * (c)1996 Hermetica. Written by Alligator Descartes <descarte@hermetica.com>
 *
 * Produces a triangulated-tesselated cube of size width x height x depth
 *
 */
/*
 * Distributed under the Artistic Licence.  This file is not a part of lib3d.
 * See the file LICENCE in this directory.
 */

#ifdef PTHREADS
#include <pthread.h>
#endif

#include <stdio.h>
#include <math.h>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/Model.H>
#include <Primitive/Primitive.H>

// static const char *rcsId = "$Id: cube.cc,v 1.2 1996/08/31 07:04:00 keithw Exp $";

extern Model *_createCubeTriangular( primitive_orient_t, float, float, float );
extern Model *_createCubePolygonal( primitive_orient_t, float, float, float );

Model *
createCube( tesselate_type_t ttype, primitive_orient_t type, 
            float width, float height, float depth ) {

    if ( ttype == TRIANGULAR )
        return _createCubeTriangular( type, width, height, depth );

    if ( ttype == POLYGONAL )
        return _createCubePolygonal( type, width, height, depth );

    return NULL;
  }

Model *
_createCubeTriangular( primitive_orient_t type, 
                       float width, float height, float depth ) {
     
    printf( "createCube ( triangular ): %f x %f x %f\n", width, height, depth );

    ModelBuilder mb;

    mb.startModel();
    mb.calculatePolygonNormals();
    mb.calculateVertexNormals();
    mb.setPolygonMaterial( 0 );

    uint *modelVertices = new uint[8];

    /** Add the vertices in */
    modelVertices[0] =
        mb.addVertex( 0, 0, 0 );
    modelVertices[1] = 
        mb.addVertex( width, 0, 0 );
    modelVertices[2] =
        mb.addVertex( 0, height, 0 );
    modelVertices[3] =
        mb.addVertex( width, height, 0 );
    modelVertices[4] =
        mb.addVertex( 0, height, depth );
    modelVertices[5] =
        mb.addVertex( width, height, depth );
    modelVertices[6] =
        mb.addVertex( width, 0, depth );
    modelVertices[7] =
        mb.addVertex( 0, 0, depth );

    /** Add the polygons */
    if ( type == FACE_BOTH || type & FACE_OUTSIDE ) {
        uint *polyVertices;
        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[1];
        polyVertices[2] = modelVertices[0];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[3];
        polyVertices[2] = modelVertices[1];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[3];
        polyVertices[1] = modelVertices[6];
        polyVertices[2] = modelVertices[1];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[3];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[6];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[5];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[3];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[0];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[0];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[2];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[4];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[7];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[0];
        polyVertices[2] = modelVertices[1];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[1];
        polyVertices[2] = modelVertices[6];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;
      }

    /** Do the inside polygons */
    if ( type == FACE_BOTH || type & FACE_INSIDE ) {
        uint *polyVertices;
        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[0];
        polyVertices[2] = modelVertices[1];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[1];
        polyVertices[2] = modelVertices[3];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[3];
        polyVertices[1] = modelVertices[1];
        polyVertices[2] = modelVertices[6];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[3];
        polyVertices[1] = modelVertices[6];
        polyVertices[2] = modelVertices[5];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[4];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[3];
        polyVertices[2] = modelVertices[5];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[0];
        polyVertices[2] = modelVertices[4];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[0];
        polyVertices[1] = modelVertices[2];
        polyVertices[2] = modelVertices[4];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[5];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[7];
        polyVertices[2] = modelVertices[4];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[1];
        polyVertices[2] = modelVertices[0];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;

        polyVertices = new uint[3];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[6];
        polyVertices[2] = modelVertices[1];
        mb.addPolygon( 3, polyVertices );
        delete polyVertices;
      }
    return mb.endModel();
  }

Model *
_createCubePolygonal( primitive_orient_t type,
                      float width, float height, float depth ) {
     
    printf( "createCube ( polygonal ): %f x %f x %f\n", width, height, depth );

    ModelBuilder mb;

    mb.startModel();
    mb.calculatePolygonNormals();
    mb.calculateVertexNormals();
    mb.setPolygonMaterial( 0 );

    uint *modelVertices = new uint[8];

    /** Add the vertices in */
    modelVertices[0] =
        mb.addVertex( 0, 0, 0 );
    modelVertices[1] = 
        mb.addVertex( width, 0, 0 );
    modelVertices[2] =
        mb.addVertex( 0, height, 0 );
    modelVertices[3] =
        mb.addVertex( width, height, 0 );
    modelVertices[4] =
        mb.addVertex( 0, height, depth );
    modelVertices[5] =
        mb.addVertex( width, height, depth );
    modelVertices[6] =
        mb.addVertex( width, 0, depth );
    modelVertices[7] =
        mb.addVertex( 0, 0, depth );

    /** Add the polygons */
    if ( type == FACE_BOTH || type & FACE_OUTSIDE ) {
        uint *polyVertices;
        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[0];
        polyVertices[1] = modelVertices[2];
        polyVertices[2] = modelVertices[3];
        polyVertices[3] = modelVertices[1];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[1];
        polyVertices[1] = modelVertices[3];
        polyVertices[2] = modelVertices[5];
        polyVertices[3] = modelVertices[6];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[4];
        polyVertices[3] = modelVertices[7];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[2];
        polyVertices[3] = modelVertices[0];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[2];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[5];
        polyVertices[3] = modelVertices[3];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[0];
        polyVertices[2] = modelVertices[1];
        polyVertices[3] = modelVertices[6];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;
      }

    /** Do the inside polygons */
    if ( type == FACE_BOTH || type & FACE_INSIDE ) {
        uint *polyVertices;
        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[1];
        polyVertices[1] = modelVertices[3];
        polyVertices[2] = modelVertices[2];
        polyVertices[3] = modelVertices[0];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[3];
        polyVertices[3] = modelVertices[1];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[7];
        polyVertices[1] = modelVertices[4];
        polyVertices[2] = modelVertices[5];
        polyVertices[3] = modelVertices[6];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[0];
        polyVertices[1] = modelVertices[2];
        polyVertices[2] = modelVertices[4];
        polyVertices[3] = modelVertices[7];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[3];
        polyVertices[1] = modelVertices[5];
        polyVertices[2] = modelVertices[4];
        polyVertices[3] = modelVertices[2];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;

        polyVertices = new uint[4];
        polyVertices[0] = modelVertices[6];
        polyVertices[1] = modelVertices[1];
        polyVertices[2] = modelVertices[0];
        polyVertices[3] = modelVertices[7];
        mb.addPolygon( 4, polyVertices );
        delete polyVertices;
      }
    return mb.endModel();
  }
