// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef PolygonClass
#define PolygonClass

#include <Lib3d/Vector.H>
#include <Lib3d/Matrix.H>
#include <iostream.h>

// kludge to simplify some stuff in Model.C - fix me
//
#define MAX_CLIPPED_VERTICES 36 

struct Vertex 
{
    Vector3  model;
    uint     normal;
    float    u, v;

    friend ostream& operator<<( ostream &out, const Vertex &v ) {
        return out << v.model;
    }
};

struct Normal 
{
    Vector3 model;
};

struct Polygon
{
    uint vertex0;
    uint vertex1;
    uint vertex2;
    uint normal;
    uint material;

    friend ostream& operator<<( ostream &out, const Polygon &p ) {
	out << "{" << p.vertex0 
	    << " " << p.vertex1 
	    << " " << p.vertex2 << "}" << endl; 
	return out << "} Material: " << p.material;
    }
};    


#endif








