#ifndef SceneClass
#define SceneClass

#include <Lib3d/internals/Debuggable.H>
#include <Lib3d/Viewport.H>
#include <Lib3d/Device.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>

class Scene : public Debuggable
{
public:
    Scene(Device &, Viewport &, World &, Camera &);
    ~Scene();

    void render();
    void notifyResize();
    void notifyExpose(uint, uint, uint, uint);

protected:
    Device &device;
    Viewport &viewport;
    World &world;
    Camera &camera;
};

#endif
