#include <Lib3d/Device.H>
#include <iostream.h>

main()
{
   Device *dev = Device::create( 320, 200, 8 );
   if (!dev) {
       cout << "Failed to create device" << endl;
       exit(1);
   }

   cout << "Dev: " << dev << " - " << dev->getName() << endl;
   cout << " res: " << dev->getWidth() << "x" << dev->getHeight() << endl;
   cout << " pixels are " << dev->getPixelSize() << " bytes" << endl;

   uint *fb = (uint *)dev->getBuffer();

   cout << "Framebuffer starts at " << (void *)fb << endl;

   cout << "Swapping buffers..." << endl;
   dev->swapBuffers();
   fb = (uint *)dev->getBuffer();
   cout << "Alternate framebuffer starts at " << (void *)fb << endl;

   int size = dev->getRowWidth() * dev->getHeight();
   int inc = dev->getPixelSize();

   uint colourTable[256];

   // Set the device up with a broad range of colours which we will use
   // for dithering.

   int r,g,b;
   int index = 0;
   for (r = 0; r < 6; r++) {
      int red = r * 65535 / 5;
      for (g = 0; g < 6; g++) {
	 int green = g * 65535 / 5;
	 for (b = 0; b < 6; b++) {
	    int blue = b * 65535 / 5;
	    colourTable[index] = dev->allocateColour(red, green, blue);

	    // build a full word of pixels.  Will fail for odd pixel sizes,
	    // such as unpadded 24 bit.

	    if (inc == 1) {
		colourTable[index] |= colourTable[index] << 8;
	    }
	    if (inc != 4) {
		colourTable[index] |= colourTable[index] << 16;
	    }
	    index++;
	 }
      }
   }

   for (uchar i = 0; i != 255; i++) {
       uint c = colourTable[i];
       if_debug debug() << "Frame " << int(i) << " colour " << int(c) << endlog;
       for (int j = 0; j < size/4; j++) {
	   fb[j] = c;
       }
       dev->swapBuffers();
       fb = (uint *)dev->getBuffer();
   }


   cout << "Done" << endl;

   delete dev;
}







