/****************************************************************************/
/* THELPWND.H                                                               */
/*--------------------------------------------------------------------------*/
/* THelpWindow class                                                        */
/****************************************************************************/

#ifndef _THELPWND_H_
#define _THELPWND_H_

#include "Types.h"

#include "TWindow.h"


/*ͻ*/
/*                             CLASS DEFINITION                           */
/*ͼ*/

class THelpWindow : public TWindow, public jptui::Callback
{
  /*----------------*/
  /* Friend classes */
  /*----------------*/

  friend class THelpTextZone;

  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Push-Buttons

    PPushButton
	    f_contents_button,
	    f_index_button,
	    f_back_button,
	    f_previous_button,
	    f_next_button;

    // Help text

    PHelpTextZone
	    f_help_text_zone;


  /*----------------*/
  /* Public methods */
  /*----------------*/

  public:

    // Constructor / Destructor


		     THelpWindow(int x ,int y,
			     int width, int height,
			     const char *caption= "",
			     bool modal=true,
			     bool movable=true);

    virtual  	     ~THelpWindow();

    // Access methods

	    bool m_load_help_file(const char *file_name);
	    void    m_unload_help_file();
	    bool m_display_topic(const char *topic, bool push_current_topic=true);

	    void    m_select_contents_topic();
	    void    m_select_index_topic();
	    void    m_select_back_topic();
	    void    m_select_previous_topic();
	    void    m_select_next_topic();

private:
	void	operator()(TObject* who, what_type what, item_type item);
};

#endif
