/****************************************************************************/
/* TCHKBOX                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TCheckBox (Case  cocher)                                          */
/****************************************************************************/

#ifndef _TCHKBOX_H_
#define _TCHKBOX_H_

#include "Types.h"

#include "TObject.h"

class TCheckBox:public TObject
{
  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // CheckBox coche ou non

    bool f_checked;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TCheckBox(PObject parent,
			      int rel_x,int rel_y,
			      int width, const char *caption,
			      bool checked=false,
                              bool enabled=true);

    virtual         ~TCheckBox();

    // Mthodes d'accs

	    bool m_is_checked() { return(f_checked); };
    virtual void    m_check();
    virtual void    m_uncheck();

    // Callback : Fonction appele si on coche la checkbox
	//            et son argument
	jptui::CallbackHolder	checkedAction_;

    // Callback : Fonction appele si on dcoche la checkbox
    //            et son argument
	jptui::CallbackHolder	uncheckedAction_;

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

    // La case  cocher est coche/dcoche

	    void    m_take_check();
	    void    m_lose_check();

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();

    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);
};

#endif
