/****************************************************************************/
/* TCHKBOX                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TCheckBox (Case  cocher)                                          */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdlib.h>

#include "Const.h"

#include "JPAppli.h"

#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"
#include "Strings.h"

#include "TWindow.h"
#include "TChkBox.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y  : Coordonnes de la case  cocher p/r au groupe            */
/* width         : Largeur de la case  cocher                              */
/* caption       : Lgende de la case  cocher (hot-key prcde de ~)      */
/* enabled       : ENABLED si la case est activable (DISABLED sinon)        */
/* checked       : CHECKED si la case est coche (NOT_CHECKED sinon)        */
/****************************************************************************/

TCheckBox::TCheckBox(PObject parent,
		     int rel_x,int rel_y,
		     int width, const char *caption,
		     bool checked,
                     bool enabled)
	  :TObject(parent,
		   OBJ_CHECK_BOX,
		   rel_x,rel_y,
		   width,1,
		   (parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
		   caption,
		   enabled,
		   true,  // FOCUS_DEPENDING_ASPECT
		   true,  // CAN_BE_ENABLED
		   true),  // SIMPLE
		checkedAction_(this),
		uncheckedAction_(this)
{
  // CheckBox coche ou non

  f_checked=checked;
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TCheckBox::~TCheckBox()
{
}

/****************************************/
/* m_check/m_uncheck : Coche ou dcoche */
/* -----------------   la case  cocher */
/****************************************/

void TCheckBox::m_check()
{
  m_take_check();
}

void TCheckBox::m_uncheck()
{
  m_lose_check();
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/****************************************/
/* m_take_check : Appele quand la case */
/* ------------   devient coche        */
/****************************************/

void TCheckBox::m_take_check()
{
  if (!f_checked)
    {
      f_checked=true;
      m_display();
		checkedAction_();
    }
}

/****************************************/
/* m_lose_check : Appele quand la case */
/* ------------   perd sa coche         */
/****************************************/

void TCheckBox::m_lose_check()
{
  if (f_checked)
    {
      f_checked=false;
      m_display();
		uncheckedAction_();
    }
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TCheckBox::m_display_focus_depending_part()
{
  m_display_caption();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TCheckBox::m_display_caption()
{
  int x,y;

  // Si l'objet n'est pas ouvert, rien  faire

  if (!f_open)
    return;

  // Rcupration des coordonnes de l'objet dans sa fentre

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  // Affichage de la case  cocher

  f_window->m_gotoxy(x,y);

  if (!f_enabled)
    f_window->m_set_inactive_attr(f_background);
  else
    {
      if ((f_focused) && (f_window->m_is_active()))
	f_window->m_set_bright_attr(f_background);
      else
	f_window->m_set_normal_attr(f_background);
    }

  if (f_checked)
    f_window->m_puts(SPECIAL_STRING(SST_CHECKBOX_CHECKED));
  else
    f_window->m_puts(SPECIAL_STRING(SST_CHECKBOX_UNCHECKED));

  f_window->m_put_caption(f_caption,
			 f_enabled,
			 f_width-3,  // -3 pour la taille de la case
			 JUSTIFIED_LEFT);


}

/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   (l'objet tant activable).          */
/*                               Retourne true si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

bool TCheckBox::m_left_button_pressed_event(int /*x*/,int /*y*/)
{
  if (!f_focused)
    {
      if (!m_set_focus())
        return false;
    }

  if (f_checked)
    m_lose_check();
  else
    m_take_check();

  JPRefresh();

  WaitMouseLeftButtonRelease();
  return true;
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne true si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/


bool TCheckBox::m_key_pressed_event(TKey key)
{
  if ( (!f_focused) || (key.character!=SPACE))
    if (key.hot_character!=f_hot_key)
      return false;

  if (!f_focused)
    {
      if (!m_set_focus())
        return false;
    }

  if (f_checked)
    m_lose_check();
  else
    m_take_check();

  JPRefresh();

  return true;
}

