#ifndef MNF_JPTUI_CALLBACK_HPP
#define MNF_JPTUI_CALLBACK_HPP

class TObject;

namespace jptui {

class Callback
{
public:
	typedef int	what_type;
	typedef int	item_type;
	virtual void	operator()(TObject* who, what_type what, item_type item) = 0;
	virtual ~Callback();
};

class CallbackHolder
{
public:
	CallbackHolder(TObject* who);
	void	set(Callback& callback, Callback::what_type what = 0);
	void	unset();
	bool	valid() const;
	void	operator()(Callback::item_type item = 0);
private:
	TObject*			who_;
	Callback*			callback_;
	Callback::what_type what_;
};

} // namespace jptui

#endif//MNF_JPTUI_CALLBACK_HPP
