/****************************************************************************/
/* TWINDOW                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TWindow (fentre)                                                  */
/****************************************************************************/

#ifndef _TWINDOW_H_
#define _TWINDOW_H_

#include <conio.h>

#include "Types.h"

#include "Keyboard.h"

#include "TGroup.h"


/*ͻ*/
/*                                CONSTANTES                              */
/*ͼ*/

// Position d'une chaine dans sa zone d'affichage

#define CENTERED        0
#define JUSTIFIED_LEFT  1
#define JUSTIFIED_RIGHT 2

#define CENTERED_LEFT   4
#define CENTERED_RIGHT  5

// Types des flches

#define ARROW_UP    0
#define ARROW_DOWN  1
#define ARROW_LEFT  2
#define ARROW_RIGHT 3

// Styles des fenetres

#define DIALOG1 (LIGHTBLUE)
#define DIALOG2 (LIGHTCYAN)
#define DIALOG3 (CYAN)

#define ALERT   (RED)
#define HELP    (GREEN)

// Fix: adding user defined colors
#define TWINDOW_COLOR_MASK	   0xF
#define TWINDOW_BRIGHT_ATTR_SHIFT  8
#define TWINDOW_NORMAL_ATTR_SHIFT  16

/*ͻ*/
/*                         DEFINITION DE L'OBJET                          */
/*ͼ*/

class TWindow:public TGroup
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend TApplication;  // Pour que l'application facilement manipuler ses
			// fentres
  friend TObject;       
  friend TPushButton;   // Pour grer les boutons spciaux

  /*------------------*/
  /* Protected fields */
  /*------------------*/

  protected:

    // Position de la fentre dans l'cran (1...)

    int         f_x,
		f_y;

    // There is an information bar

    boolean     f_info_bar;

    // Couleur d'affichage du titre quand il a le focus

    unsigned    f_title_attribute;

    // Couleur d'affichage de la bordure

    unsigned    f_border_attribute;

    // Fix: to redefine shadows type
protected: TShadowChoice shadows; 
public:    void 	 set_shadows(TShadowChoice a_shadows)
	   { shadows = a_shadows; };

  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Numro de la fentre dans l'application

    int         f_window_number;

    // If the information bar exits, message it displays

    char        *f_info_message;

    // La fentre est modale

    boolean     f_modal;

    // La fentre est dplaable

    boolean     f_movable;

    // La fentre est active

    boolean     f_active;

    // Objet qui gre les acclrateurs de la fentre

    PObject     f_short_cut_handler;

    // Boutons spciaux de la fentre

    PPushButton f_default_button;  // Bouton par dfaut
    PPushButton f_ok_button;       // Bouton actuellement activable par RETURN
    PPushButton f_cancel_button;   // Bouton actuellement activable par ESC

    // Pour l'affichage dans la fentre
    // (n'apparat  l'cran qu'aprs un rafrachissement)

    word        *f_window_content; // Contenu de la fentre

    boolean     f_content_changed; // Le contenu de la fentre a chang depuis
				   // le dernier rafrachissement

    TIntZone    f_changed_zone;    // si f_content_changed est TRUE,
				   // zone de la fentre dont le contenu
				   // a t modifi depuis le dernier rafrachissement

    TIntZone    f_clip_window;     // Limites d'affichage du texte

    int         f_x_cursor;        // Coordonnes du curseur de la fentre
    int         f_y_cursor;        // (position d'affichage, pas curseur cran)
    word        *f_cursor_ptr;     // Pointeur sur le caractre courant

    int         f_text_attribute;  // Attribut d'affichage

    // Objet de la fentre qui avait le focus avant que le focus ne change
    // d'objet dans la fentre

    PObject     f_previous_focused_object;

    // Callback : Fonction appele lorsque l'on clique sur l'icone de
    //            fermeture de la fentre
    //            et son argument

    void (*f_close_button_pressed_action)(PObject, const char *);
    const char *f_close_button_pressed_argument;


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		     TWindow(unsigned style,
			     int x, int y,
			     int width, int height,
			     const char *caption = "",
			     boolean info_bar=FALSE,
			     boolean modal=TRUE,
			     boolean movable=TRUE);

    virtual  	     ~TWindow();

    // Mthodes d'accs

    virtual int      m_get_x()  { return (f_x); };
    virtual int      m_get_y()  { return (f_y); };

	    void     m_set_pos(int x,int y);

	    void     m_set_title_attr(unsigned attribute) {f_title_attribute=attribute;};
	    void     m_set_border_attr(unsigned attribute) {f_border_attribute=attribute;};

	    void     m_set_short_cut_handler(PObject handler) {f_short_cut_handler=handler;};
	    void     m_set_default_button(PPushButton button);
	    void     m_set_cancel_button(PPushButton button);

    // Donne le focus  la fentre (au 1er/dernier de ses objets qui le veut)
    // Sinon, la fentre seul (aucun objet) prend le focus

    virtual boolean  m_set_focus();
    virtual boolean  m_set_focus_to_last_element();

    // Retourne l'objet de la fentre qui avait le focus
    // avant que celui ne change d'objet

	    PObject  m_get_previous_focused_object() {return(f_previous_focused_object);};

    // Rend la fentre active

	    boolean  m_activate();
	    boolean  m_is_active() {return(f_active);};

    // Ouverture/Fermeture de la fentre
    // Si on appelle m_open sur une fentre dj ouverte,
    // la fentre passe au premier plan

	    void     m_open();
	    void     m_close();

	    // ATTENTION : Ne pas utiliser en dehors du code des objets !
	    void     m_open_as_object_element(PObject object);


    // Modification du message d'information

	    void     m_set_info_message(const char *message);
	    const char *m_get_info_message();

    // Mthodes d'affichage dans la fentre

	    void     m_gotoxy(int x,int y);

	    unsigned m_get_normal_attr(unsigned background);
	    unsigned m_get_inverse_attr(unsigned background);
	    unsigned m_get_bright_attr(unsigned background);
	    unsigned m_get_inverse_bright_attr(unsigned background);
	    unsigned m_get_inactive_attr(unsigned background);
	    unsigned m_get_inverse_inactive_attr(unsigned background);

	    void     m_textattr(unsigned attribute);
	    void     m_set_normal_attr(unsigned background)           { m_textattr(m_get_normal_attr(background));};
	    void     m_set_inverse_attr(unsigned background)          { m_textattr(m_get_inverse_attr(background));};
	    void     m_set_bright_attr(unsigned background)           { m_textattr(m_get_bright_attr(background));};
	    void     m_set_inverse_bright_attr(unsigned background)   { m_textattr(m_get_inverse_bright_attr(background));};
	    void     m_set_inactive_attr(unsigned background)         { m_textattr(m_get_inactive_attr(background));};
	    void     m_set_inverse_inactive_attr(unsigned background) { m_textattr(m_get_inverse_inactive_attr(background));};

	    void     m_set_clip_window(int x,int y,int width,int height);
	    void     m_reset_clip_window();

	    void     m_cls(unsigned background);

	    void     m_putch(u_char character);
	    void     m_putnch(int nb_chars,u_char character);
	    void     m_puts(const char *string);

	    void     m_put_caption(const char *main_string, boolean show_hot_key, int length, int position);
	    void     m_put_text(const char *text);
	    void     m_draw_frame(int x1,int y1,int x2,int y2,unsigned background, const char *caption, boolean enabled);
	    void     m_display_arrow(int arrow_type);

    // Dfinition des callbacks

	    void     m_set_close_button_pressed_callback(void (*close_button_pressed_action)(PObject, const char *),
							 const char *close_button_argument);

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Affichage

    virtual void     m_display();
    virtual void     m_display_focus_depending_part();
    virtual void     m_display_caption();
    virtual void     m_display_close_button(boolean pressed);
    virtual void     m_display_info_bar();

    // Evnements

    virtual boolean  m_left_button_pressed_event(int x,int y);
    virtual boolean  m_key_pressed_event(TKey key);

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Manipulation des boutons spciaux

	    void     m_set_ok_button(PPushButton button);
	    void     m_set_ok_button_to_default();
	    void     m_unset_ok_button();
	    void     m_button_destructed(PPushButton button);

    // Effacement de la fentre

    virtual void     m_clear();

    // Ajoute la fentre dans la zone d'cran  rafrachir

	    void     m_add_to_refresh_zone();

    // Ecriture directe  l'cran

	    void     m_part_to_screen(int x1,int y1,int x2,int y2);
	    void     m_shadows_to_screen(int x1,int y1,int x2,int y2);

    // Ouverture/Fermeture de l'objet

    virtual void     m_set_open(boolean open);

    // L'objet devient actif/inactif

    virtual void    m_set_active(boolean active);

    // Evnements

	    boolean  m_close_button_pressed_event();

};

#endif