/****************************************************************************/
/* JPAPPLI                                                                  */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation de l'application ralise avec la librairie    */
/* JPTUI                                                                    */
/****************************************************************************/

#ifndef JP_APPLICATION
#define JP_APPLICATION


#include "TApplica.h"

/******************************************/
/* Fonctions pour contrler l'application */
/******************************************/

// Application

#define JPApplication        (TApplication::f_current_application)

// Arrt sur manque de mmoire

#define JPOutOfMemoryExit()  (TApplication::m_new_handler())

// Dmarrage/arrt

#define JPInit()             ((TApplication::m_get_current_application())->m_init())
#define JPRun()              ((TApplication::m_get_current_application())->m_run())
#define JPRunDialog()        ((TApplication::m_get_current_application())->m_run_dialog())
#define JPProcessEvents()    ((TApplication::m_get_current_application())->m_process_events())
#define JPStop()             ((TApplication::m_get_current_application())->m_stop())

// Refreshes the display/the whole screen

#define JPRefresh()          ((TApplication::m_get_current_application())->m_refresh())
#define JPRefreshAll()       ((TApplication::m_get_current_application())->m_refresh_all())

// Redraws the contents of windows

#define JPRedrawWindows()    ((TApplication::m_get_current_application())->m_redraw_windows())

// Rend la fentre suivante active (retourne FALSE si impossible)

#define JPMakeNextWindowActive() \
			     ((TApplication::m_get_current_application())->m_make_next_window_active())

// Returns a pointer to the active window

#define JPGetActiveWindow()  ((TApplication::m_get_current_application())->m_get_active_window())
// Clipboard

#define JPGetClipboard()     ((TApplication::m_get_current_application())->m_get_clipboard())
#define JPSetClipboard(text) ((TApplication::m_get_current_application())->m_set_clipboard(text))


// Autorisation/Interdiction des callbacks

#define JPEnableCallbacks()  ((TApplication::m_get_current_application())->m_enable_callbacks())
#define JPDisableCallbacks() ((TApplication::m_get_current_application())->m_disable_callbacks())
#define JPCallbacksEnabled() ((TApplication::m_get_current_application())->m_callbacks_enabled())

// Dfinition des callbacks

#define JPSetNoEventCallback(no_event_action,no_event_argument)  ((TApplication::m_get_current_application())->m_set_no_event_callback(no_event_action,no_event_argument))
#define JPSetClipboardChangedCallback(clipboard_changed_action,clipboard_changed_argument)  ((TApplication::m_get_current_application())->m_set_clipboard_changed_callback(clipboard_changed_action,clipboard_changed_argument))


#endif
